set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '0232210',
      NULL,
      0,
      6,
      1,
      '0243',
      2.318874,
      NULL,
      NULL,
      NULL,
      ' 0-27-1991',
      45,
      NULL,
      NULL,
      1.740116,
      3.889310,
      ' 6-23-1994',
      12,
      1,
      7.411374,
      NULL,
      2,
      ' 8-13-1990',
      ' 9-12-2001',
      NULL,
      3,
      3.371008,
      2.434355,
      2,
      1,
      1,
      4,
      0.663871,
      0.469792,
      8.864394,
      1,
      18,
      5,
      14,
      6,
      1,
      21,
      2,
      3,
      NULL,
      1,
      1,
      1,
      1.976147,
      0,
      1,
      1,
      1,
      1.026286,
      0.801765,
      1,
      2,
      3,
      3,
      NULL,
      5,
      1,
      1,
      0,
      0,
      4,
      4,
      0,
      1,
      1,
      0,
      0,
      9,
      1,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0.318795,
      NULL,
      NULL,
      2,
      1,
      2.892224,
      0.504994,
      NULL,
      0,
      NULL,
      1,
      3.918643,
      1,
      0,
      1,
      3,
      1.141517,
      0.509914,
      1.816396,
      0,
      1.851786,
      2.100781,
      1,
      0,
      1,
      4.684673,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.022296,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      4,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3.244402,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.299616,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      2,
      3,
      3,
      1,
      NULL,
      4,
      5,
      5,
      1,
      1,
      5,
      2,
      4,
      0,
      1,
      5.334304,
      2.220624,
      NULL,
      NULL,
      NULL,
      267.973148,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1.301474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.876744,
      0.789932,
      NULL,
      0.773957,
      NULL,
      NULL,
      NULL,
      1.727129,
      1.612488,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.916808,
      1.190050,
      0.546717,
      0,
      0.301948,
      287.939429,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.877032,
      NULL,
      1,
      2,
      1,
      3,
      0,
      3,
      3,
      NULL,
      2,
      NULL,
      1,
      2,
      0,
      1.236050,
      0.634845,
      0.903788,
      3,
      1,
      0.244789,
      1,
      1.489804,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1.759928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322987,
      NULL,
      21,
      63,
      68.036372,
      1,
      0,
      2,
      '00301',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.972813,
      '',
      '',
      '',
      NULL,
      56.980783,
      26,
      0.886928,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.446613,
      2.441163,
      NULL,
      1.625195,
      NULL,
      NULL,
      0.643360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.758283,
      NULL,
      NULL,
      NULL,
      1,
      2.858598,
      1,
      3.087808,
      1.838665,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.249709,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      8.660387,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.789627,
      2,
      1.290707,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.169070,
      1,
      3,
      0,
      1.192279,
      0,
      NULL,
      1.495525,
      3,
      1.809432,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296922,
      NULL,
      NULL,
      6.589883,
      2.845826,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.833400,
      2.086390,
      0,
      NULL,
      3.210066,
      1,
      0,
      NULL,
      NULL,
      0.594647,
      7,
      5,
      NULL,
      1.243722,
      2,
      3,
      1.412099,
      NULL,
      6,
      3.477074,
      7.697470,
      1,
      NULL,
      NULL,
      0.713526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.070544,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.531821,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2.389249,
      NULL,
      NULL,
      6.588228,
      2.055445,
      3.663868,
      NULL,
      NULL,
      2,
      3.439331,
      0.655603,
      0,
      2,
      0.851655,
      2.210493,
      5.715796,
      6,
      3.267879,
      2,
      0,
      0,
      NULL,
      3.621954,
      0,
      0.217857,
      NULL,
      1,
      2.258996,
      0.578465,
      0,
      5,
      8,
      NULL,
      3.808613,
      1,
      3,
      1,
      NULL,
      3,
      1.126751,
      NULL,
      0,
      1.246015,
      1,
      0.152210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.790429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.735872,
      NULL,
      NULL,
      1.676894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702321,
      0.595096,
      1,
      NULL,
      NULL,
      0.931009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.102176,
      NULL,
      NULL,
      NULL,
      0.941394,
      NULL,
      NULL,
      NULL,
      2.040214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.930512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846298,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871028,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.788601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.041122,
      NULL,
      1.868559,
      18102.070581,
      NULL,
      NULL,
      0.789516,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.253400,
      0.920406,
      1,
      NULL,
      1.127158,
      0,
      0.673045,
      NULL,
      1,
      0.131133,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      0.038283,
      0,
      1.552435,
      0,
      2.077972,
      NULL,
      1,
      1.289983,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.109448,
      NULL,
      0.436155,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.492422,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.284859,
      0,
      NULL,
      2,
      1.256067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.386522,
      NULL,
      0,
      NULL,
      3,
      NULL,
      7,
      0.547948,
      NULL,
      NULL,
      57,
      139,
      2,
      NULL,
      1.864240,
      '13143',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


