set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '03',
      2,
      19,
      '3112223',
      0.338709,
      0.631417,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '10-15-1999',
      NULL,
      60,
      NULL,
      0.732222,
      1.123494,
      ' 8- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11-15-1993',
      ' 8- 4-1976',
      NULL,
      1.981999,
      1.719760,
      1,
      NULL,
      NULL,
      0,
      3.296638,
      NULL,
      NULL,
      NULL,
      3.978855,
      5.478947,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1.690623,
      1.914247,
      0.911646,
      0.815213,
      0,
      7,
      0.939900,
      NULL,
      NULL,
      6,
      2,
      NULL,
      1,
      4,
      NULL,
      1,
      5,
      1,
      4,
      4,
      1,
      0,
      0,
      3.184530,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.984428,
      1.201870,
      1.117390,
      1.775029,
      3,
      0.733083,
      1.034613,
      3,
      1,
      0,
      1.694567,
      NULL,
      0,
      NULL,
      2.003966,
      0.349447,
      0.007295,
      NULL,
      1,
      NULL,
      7.340870,
      0,
      0,
      1.553649,
      1.946510,
      NULL,
      NULL,
      0.948673,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      2,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      4,
      1,
      2,
      1,
      NULL,
      0,
      2.647193,
      0.743970,
      ' 9-12-1980',
      153,
      ' 1-24-1986',
      NULL,
      2,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      20,
      3.368022,
      2.121218,
      NULL,
      NULL,
      0,
      3.206628,
      1.892518,
      42,
      NULL,
      NULL,
      NULL,
      0,
      1.324001,
      1.931409,
      1,
      7.323415,
      4.636140,
      0.178986,
      NULL,
      1.752199,
      1,
      NULL,
      NULL,
      NULL,
      1.772643,
      11.406344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.574242,
      1.152171,
      0.053475,
      NULL,
      0.194983,
      0.535308,
      2,
      118.599363,
      1.362255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571294,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      1,
      3.952501,
      1,
      2.680380,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0.633591,
      1.388576,
      1.962454,
      8,
      10,
      NULL,
      NULL,
      NULL,
      2.332866,
      5,
      0.414232,
      2,
      0.878838,
      NULL,
      0.796950,
      3.915798,
      3,
      NULL,
      57,
      NULL,
      20,
      6.436376,
      4,
      NULL,
      5.238429,
      NULL,
      NULL,
      NULL,
      1.870621,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      10.613383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.792786,
      NULL,
      0,
      NULL,
      NULL,
      0.796161,
      NULL,
      NULL,
      0.605966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.238957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.885030,
      0.839999,
      2.401116,
      0.751183,
      1,
      0.125765,
      1,
      0,
      1.347036,
      1,
      NULL,
      0,
      1,
      0.460648,
      0,
      0,
      NULL,
      NULL,
      1.617257,
      NULL,
      2.514771,
      NULL,
      2.284804,
      NULL,
      0,
      NULL,
      1.299868,
      NULL,
      NULL,
      NULL,
      0.219427,
      33,
      4.369400,
      0,
      1.498799,
      NULL,
      NULL,
      3.223361,
      NULL,
      1,
      NULL,
      0.161244,
      NULL,
      1.687256,
      NULL,
      0.234442,
      NULL,
      1,
      NULL,
      0.283459,
      NULL,
      0.550011,
      NULL,
      0,
      NULL,
      0.342624,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.986579,
      NULL,
      1.709133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      2.217080,
      3.887729,
      2,
      NULL,
      1,
      8.705623,
      NULL,
      2.142163,
      0,
      0.579291,
      NULL,
      NULL,
      1.090904,
      2.932385,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      3.398219,
      0,
      NULL,
      0,
      0.589854,
      NULL,
      2.405592,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.136688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.252275,
      NULL,
      0,
      2,
      7,
      3.375483,
      2,
      0,
      43.410767,
      52.354278,
      3,
      4.766619,
      2,
      '11420',
      '00312',
      '',
      1,
      '',
      '',
      '',
      0.900518,
      '',
      '',
      '');
commit;
end;
/


