set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987804,
      1.037960,
      3,
      1,
      '4000',
      1,
      1,
      NULL,
      NULL,
      ' 1-20-1974',
      40.171419,
      NULL,
      3,
      2,
      3.505281,
      NULL,
      18,
      2.504703,
      235,
      196.556661,
      0,
      '11-27-1982',
      ' 1- 4-1997',
      ' 5- 1-1977',
      1,
      1.834688,
      2.736123,
      NULL,
      1.232563,
      0.578477,
      0,
      0,
      NULL,
      2.041897,
      NULL,
      17.967181,
      6,
      14,
      16.893266,
      NULL,
      0,
      NULL,
      0,
      1,
      0.945041,
      NULL,
      0,
      1.835283,
      NULL,
      0,
      NULL,
      0.592464,
      1.360920,
      2.808235,
      1,
      4,
      1,
      2,
      2.334036,
      NULL,
      0,
      1,
      4,
      1,
      4,
      NULL,
      2,
      1,
      0,
      2,
      0,
      7,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.600607,
      1.397126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      4.203019,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      0.793058,
      NULL,
      1.905808,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      5,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      ' 6-11-1990',
      198,
      ' 2-27-2000',
      44,
      1.573982,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0.452974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      5,
      2.296303,
      0.325559,
      1.900832,
      NULL,
      8.561199,
      4,
      1,
      NULL,
      2,
      3.869450,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5.941317,
      0.468202,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.955525,
      0.912665,
      0,
      0.341584,
      NULL,
      2.850118,
      0.089231,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      2,
      3.068181,
      3.424785,
      2.060593,
      0.040680,
      0,
      1.990789,
      NULL,
      1,
      1.584102,
      0.490157,
      1,
      NULL,
      1.893075,
      0,
      0.799325,
      1,
      1,
      NULL,
      1.839096,
      NULL,
      6.108154,
      6,
      7,
      NULL,
      1,
      NULL,
      3.849161,
      4,
      2,
      1,
      3.397573,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      59,
      2,
      1,
      1.378806,
      NULL,
      '04440',
      '',
      NULL,
      '31202',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      95,
      19.978832,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063541,
      NULL,
      NULL,
      1.507741,
      NULL,
      NULL,
      1.855487,
      NULL,
      NULL,
      0.200672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.661636,
      NULL,
      NULL,
      0.668777,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095948,
      NULL,
      NULL,
      0.882009,
      NULL,
      NULL,
      1.027833,
      NULL,
      NULL,
      0.926251,
      1.251221,
      5.291087,
      0.408285,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      0.933261,
      NULL,
      NULL,
      0,
      2,
      4.095895,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.349543,
      2.073032,
      2.061425,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440978,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.139669,
      1.480015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778962,
      0,
      0.501494,
      1.356326,
      NULL,
      1.144146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052718,
      NULL,
      NULL,
      NULL,
      NULL,
      8.249367,
      2.883480,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.769671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.165056,
      NULL,
      NULL,
      0.534814,
      NULL,
      NULL,
      154.477323,
      1,
      0,
      0.781220,
      0,
      1,
      1.713649,
      0.100656,
      NULL,
      1,
      NULL,
      1.276878,
      0.813553,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.894125,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.699396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.286615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551284,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016597,
      1.000477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.077346,
      0,
      0.289888,
      NULL,
      2.385193,
      NULL,
      3,
      NULL,
      1.654221,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.122804,
      NULL,
      NULL,
      0.747154,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      2.936212,
      4,
      0,
      0.651214,
      2,
      0.568644,
      3,
      3.402452,
      0.252042,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.510918,
      NULL,
      0.122224,
      3.788902,
      NULL,
      1.057864,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.352530,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.520034,
      1.874074,
      NULL,
      1.802346,
      1.022071,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423407,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.229963,
      NULL,
      1,
      NULL,
      0.762476,
      NULL,
      0.396291,
      NULL,
      0.099677,
      NULL,
      30,
      NULL,
      NULL,
      1.101721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      99.561159,
      1,
      0,
      6.884503,
      '43440',
      '22133',
      '04202',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


