set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6107767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2300233',
      2,
      1.394833,
      2,
      NULL,
      NULL,
      1.025510,
      1.782915,
      NULL,
      NULL,
      ' 3- 4-1979',
      68,
      NULL,
      2,
      NULL,
      NULL,
      ' 8-29-1995',
      75,
      2,
      169.485242,
      NULL,
      2,
      ' 9- 6-2001',
      ' 2-16-1998',
      '11-15-1998',
      NULL,
      NULL,
      2.052797,
      0.780434,
      1.738340,
      0,
      4,
      1,
      0.972794,
      38,
      4,
      0.763398,
      3,
      13,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.182248,
      1.484455,
      1,
      0,
      1,
      0.239437,
      1,
      0,
      NULL,
      1.673469,
      0.149322,
      NULL,
      5,
      3,
      6,
      3.234996,
      5,
      1,
      1,
      0,
      1,
      2,
      0,
      2,
      5,
      5,
      0,
      NULL,
      4.760589,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.790400,
      0.210061,
      1.896355,
      1.882493,
      0.545414,
      1.998773,
      0,
      3.546082,
      0,
      0.474675,
      1.028122,
      0,
      3,
      NULL,
      NULL,
      2.894060,
      2,
      1,
      0,
      NULL,
      0,
      1,
      1.038472,
      0.764114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      4,
      4,
      1,
      1,
      NULL,
      5,
      0,
      NULL,
      1,
      0.112281,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      2.650982,
      1,
      5,
      1,
      0,
      1,
      3,
      3,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      0,
      0,
      2,
      1,
      3,
      NULL,
      2,
      5,
      NULL,
      3,
      5,
      5,
      NULL,
      NULL,
      NULL,
      657,
      ' 9-13-1987',
      1256,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.201140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672708,
      4.804873,
      1,
      0,
      1,
      NULL,
      0.084842,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.008452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.007117,
      1,
      1.552817,
      NULL,
      0,
      2.554064,
      6784,
      1,
      NULL,
      198,
      NULL,
      1999,
      0,
      0,
      1.587546,
      3,
      NULL,
      0,
      2,
      2,
      0,
      2,
      0,
      1,
      2,
      4.696524,
      12.430945,
      15,
      82.552790,
      171,
      55,
      146.954105,
      105,
      27,
      1.568751,
      NULL,
      154,
      148,
      169,
      25,
      1,
      1.613114,
      11.953127,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      17,
      50,
      1,
      1,
      2,
      '01131',
      '',
      '',
      1.177656,
      NULL,
      '',
      '',
      5.504807,
      '1304',
      NULL,
      '3330',
      NULL,
      38.716785,
      206.846975,
      49.767014,
      2,
      15,
      119.196864,
      NULL,
      5,
      NULL,
      12.080267,
      NULL,
      0.026636,
      NULL,
      NULL,
      NULL,
      10,
      3.113884,
      2,
      1.430731,
      3.232865,
      3,
      12,
      1.976022,
      1.533361,
      2,
      0.306760,
      NULL,
      NULL,
      0,
      2.646211,
      7,
      0.009631,
      0.580217,
      12.275609,
      1.600366,
      2,
      5,
      1,
      0.948737,
      16,
      1.231156,
      1,
      7,
      NULL,
      NULL,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028434,
      NULL,
      1,
      NULL,
      NULL,
      1.315208,
      NULL,
      NULL,
      1.865729,
      1.983562,
      1.713529,
      NULL,
      2,
      3.861352,
      2.331638,
      2.153054,
      0.901546,
      3,
      0.185041,
      NULL,
      2,
      1,
      0,
      1.713959,
      3,
      0.679010,
      NULL,
      0,
      NULL,
      NULL,
      2.229404,
      11.563277,
      1,
      1.439893,
      2.179342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.168951,
      NULL,
      2.159958,
      3.799263,
      1.233573,
      2.979111,
      15,
      NULL,
      1,
      NULL,
      2,
      5.930691,
      NULL,
      0,
      2,
      17,
      1.004306,
      0.375859,
      NULL,
      NULL,
      5,
      0.310617,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.535660,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.112597,
      NULL,
      NULL,
      3,
      NULL,
      1.361562,
      0,
      3.811207,
      NULL,
      5,
      5.887525,
      2,
      6,
      4,
      1.320919,
      NULL,
      3.024764,
      NULL,
      0,
      2.691965,
      NULL,
      NULL,
      NULL,
      1.541605,
      2.901296,
      18,
      2,
      11,
      1,
      9.454833,
      3.069879,
      11.404809,
      1,
      3,
      8,
      0.530000,
      2.385147,
      19.892553,
      0,
      3,
      NULL,
      1.060482,
      9,
      1,
      9,
      NULL,
      5.634053,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.357779,
      1,
      1,
      3.927346,
      NULL,
      NULL,
      1.323657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.155868,
      NULL,
      NULL,
      0.692395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.454851,
      1.658015,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      NULL,
      NULL,
      NULL,
      1.032486,
      NULL,
      NULL,
      NULL,
      1.726214,
      NULL,
      NULL,
      NULL,
      1.159388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931999,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.979991,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966433,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.032675,
      NULL,
      NULL,
      NULL,
      2.557399,
      NULL,
      NULL,
      NULL,
      4.589956,
      NULL,
      NULL,
      NULL,
      NULL,
      6.062890,
      0,
      NULL,
      NULL,
      97,
      365,
      NULL,
      18,
      1,
      0,
      NULL,
      NULL,
      0.809961,
      NULL,
      3,
      NULL,
      10,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1990,
      0.983454,
      312,
      NULL,
      1,
      1,
      0.095812,
      1,
      0.795417,
      1,
      1,
      1,
      1.950753,
      0,
      NULL,
      NULL,
      1.007376,
      1.340579,
      1,
      0,
      NULL,
      0.714929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      9.254040,
      0,
      3,
      2.048916,
      0,
      8.469661,
      1,
      0.659921,
      0.601556,
      1.778274,
      0,
      NULL,
      0.353539,
      0.994142,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2.152948,
      NULL,
      1.353916,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.251597,
      NULL,
      1.514976,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.984504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.727961,
      NULL,
      3,
      NULL,
      3,
      1.557457,
      0,
      NULL,
      28.747793,
      26,
      1,
      1.955153,
      2,
      '32424',
      '',
      NULL,
      0.142802,
      '',
      '',
      '',
      7.634496,
      '0020',
      '320',
      '0202');
commit;
end;
/


