set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0340433',
      2.104237,
      0.500494,
      0,
      3,
      '4213',
      1,
      NULL,
      0,
      45,
      ' 9-14-1977',
      NULL,
      NULL,
      1,
      3,
      0,
      ' 3-11-1999',
      NULL,
      1.367594,
      226.359513,
      130.672428,
      5,
      NULL,
      NULL,
      ' 5-22-1988',
      1.545954,
      NULL,
      0.804316,
      1,
      1,
      0,
      0,
      1.541192,
      1,
      147.268217,
      5,
      16.051101,
      1,
      13,
      18,
      NULL,
      NULL,
      4,
      NULL,
      1.327425,
      0.342640,
      NULL,
      0,
      1.863099,
      0,
      0,
      1.664273,
      1,
      NULL,
      1.983351,
      48,
      4,
      4,
      5,
      0.177192,
      NULL,
      NULL,
      3,
      0,
      3,
      2,
      NULL,
      1,
      2,
      0,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0.799032,
      1,
      NULL,
      1.019241,
      0.714657,
      1,
      NULL,
      NULL,
      NULL,
      0.419597,
      0.737090,
      1.252526,
      1,
      NULL,
      1,
      0,
      4.625431,
      0,
      1,
      0.709253,
      0.419815,
      NULL,
      NULL,
      1.061938,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1,
      2,
      1,
      3,
      NULL,
      1,
      5,
      NULL,
      6.807159,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.315002,
      NULL,
      2,
      3,
      3,
      NULL,
      3,
      1,
      0,
      2,
      NULL,
      0,
      3,
      2,
      NULL,
      0,
      2,
      3,
      2,
      1,
      0,
      0,
      3,
      2,
      0,
      1,
      0.661759,
      1.874629,
      ' 7- 6-1994',
      16.096197,
      ' 4- 9-2003',
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.728662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802579,
      NULL,
      NULL,
      1,
      3,
      2.069382,
      0.958678,
      NULL,
      NULL,
      NULL,
      0.801388,
      3,
      0.568245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.255452,
      NULL,
      0.696823,
      NULL,
      0.407590,
      0,
      0.525498,
      2151,
      2.882433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      10,
      0.562348,
      1.778179,
      1,
      2,
      NULL,
      0.533635,
      1,
      NULL,
      1.743708,
      NULL,
      NULL,
      1,
      3,
      3.901086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      2,
      0.727885,
      3,
      '33144',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      '2202',
      NULL,
      NULL,
      3.848343,
      4.171709,
      12.888621,
      NULL,
      3.658005,
      3.189951,
      5.193279,
      21,
      NULL,
      2.651822,
      0.733181,
      3,
      1,
      NULL,
      NULL,
      3.128606,
      0.673555,
      NULL,
      0.233062,
      NULL,
      NULL,
      2,
      0.720384,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2.522671,
      0.912427,
      NULL,
      NULL,
      3.918939,
      0.764956,
      0,
      0.867992,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9.762758,
      5.305198,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269531,
      2,
      0,
      1,
      0,
      0.177700,
      13.785336,
      NULL,
      NULL,
      3,
      NULL,
      0.114603,
      0.163060,
      0.283543,
      NULL,
      0,
      1.792957,
      1.820948,
      3.074881,
      1.558824,
      1.464309,
      NULL,
      1.448767,
      1,
      0,
      1.645607,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.384432,
      2.798494,
      1,
      10.385754,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.825111,
      1,
      1.143211,
      2.621796,
      NULL,
      1.644019,
      2,
      0,
      1.361887,
      NULL,
      NULL,
      NULL,
      9,
      1,
      NULL,
      0.471889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      3.048616,
      1.304369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.579867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303842,
      NULL,
      NULL,
      NULL,
      0,
      19.375496,
      3,
      1,
      2.355292,
      9.950053,
      0.778358,
      NULL,
      7,
      5.078100,
      0.442537,
      11,
      1,
      0.438084,
      3,
      1,
      2,
      3,
      2.208954,
      0.713191,
      NULL,
      1,
      0,
      1,
      4,
      0,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1.641910,
      1.063316,
      1,
      2,
      NULL,
      7,
      NULL,
      4,
      NULL,
      1.941306,
      3,
      3.904470,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.647216,
      NULL,
      NULL,
      6.245637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.421518,
      NULL,
      NULL,
      2.172367,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      0.135604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.587581,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224755,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026836,
      NULL,
      NULL,
      NULL,
      1,
      1.883186,
      NULL,
      NULL,
      3.487124,
      3,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.977959,
      0.140428,
      NULL,
      NULL,
      2.861753,
      0.213084,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      0.801148,
      NULL,
      6,
      1,
      2.245773,
      338,
      60.067419,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.145576,
      3,
      9.964054,
      0,
      12.777418,
      9,
      NULL,
      NULL,
      NULL,
      0,
      3.523843,
      1.815653,
      0,
      15.995449,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.350665,
      1,
      1,
      1.063509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      9,
      0.326817,
      5,
      3.817479,
      3,
      8.216846,
      NULL,
      NULL,
      3.802913,
      1,
      1,
      1.330267,
      0,
      1.240021,
      1.532194,
      0,
      NULL,
      1.158377,
      0.747436,
      NULL,
      1,
      1,
      2,
      1.044588,
      0.395216,
      0,
      3.369233,
      0,
      3,
      3,
      NULL,
      3,
      2.221591,
      NULL,
      1.354503,
      1.602305,
      NULL,
      NULL,
      1.870304,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591304,
      1.917428,
      0,
      1,
      1.276359,
      1.917541,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.995216,
      NULL,
      0,
      NULL,
      '02121',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2,
      '0304',
      '',
      '');
commit;
end;
/


