set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8408911';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      3.112415,
      1.912606,
      2,
      NULL,
      NULL,
      1,
      1.830039,
      NULL,
      NULL,
      NULL,
      12.601663,
      NULL,
      5,
      0,
      0.587285,
      ' 6-21-1996',
      NULL,
      1,
      223,
      41,
      0,
      NULL,
      ' 5-21-2002',
      ' 4- 8-1981',
      NULL,
      0.941042,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.832798,
      NULL,
      NULL,
      NULL,
      11,
      10,
      135,
      65.798601,
      4,
      8.443781,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      1.810660,
      0.870865,
      0,
      1,
      0.055319,
      0.965948,
      1,
      1,
      2,
      0,
      6,
      0.355407,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      4.009480,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.271173,
      0,
      NULL,
      1,
      3.593129,
      0.402888,
      0,
      3.374743,
      0,
      1.137922,
      1.459737,
      0.300688,
      0.933401,
      0,
      1,
      1,
      5,
      0,
      0,
      1.802055,
      1.396951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1.815192,
      NULL,
      1.488512,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      5,
      2,
      0,
      NULL,
      NULL,
      1,
      0,
      0.449204,
      2.211743,
      ' 5-11-1980',
      953,
      ' 7-17-1975',
      NULL,
      3,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1.968448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.954808,
      0.765339,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.118256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.800837,
      1,
      3.353993,
      0.181981,
      NULL,
      0.513141,
      2.141981,
      45,
      1.649991,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      1,
      1,
      1,
      3,
      3,
      2,
      3.569940,
      NULL,
      3,
      1.179593,
      0.407008,
      1.076189,
      1.079977,
      NULL,
      1.511624,
      5,
      1,
      1.300699,
      NULL,
      3.746377,
      0,
      NULL,
      0.953837,
      1,
      NULL,
      8.640558,
      6,
      7,
      8,
      7.755149,
      5.375060,
      4,
      3,
      4,
      NULL,
      2.260159,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      17,
      36,
      NULL,
      1,
      1.656465,
      1,
      '23142',
      '',
      NULL,
      0.016998,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.166624,
      NULL,
      407.482220,
      48.714376,
      0,
      3.037209,
      8.338226,
      3.932505,
      3,
      2.025394,
      1.429780,
      0,
      2.878071,
      3.007591,
      1,
      0.967130,
      NULL,
      NULL,
      0.384004,
      NULL,
      NULL,
      0.997285,
      NULL,
      NULL,
      1.971757,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.978245,
      NULL,
      NULL,
      1,
      1.396353,
      1,
      1.241767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.563573,
      NULL,
      NULL,
      NULL,
      0,
      0.462002,
      NULL,
      1.456521,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634897,
      1.046022,
      1,
      NULL,
      1.312745,
      1.077238,
      0.601738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.642417,
      NULL,
      0,
      1,
      2.360445,
      1,
      NULL,
      NULL,
      0,
      0,
      0.788399,
      0.039839,
      1.247432,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.563351,
      9.566138,
      1.203055,
      2.496948,
      0,
      1.211445,
      NULL,
      NULL,
      NULL,
      0.499379,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.427678,
      0.146123,
      1.151666,
      0,
      NULL,
      NULL,
      1.542869,
      NULL,
      3,
      0.554550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.812455,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.939897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.369452,
      NULL,
      NULL,
      1.339791,
      NULL,
      NULL,
      1.401877,
      0.417477,
      NULL,
      1.538399,
      NULL,
      NULL,
      NULL,
      NULL,
      3.966481,
      3.092227,
      3.185966,
      3,
      1.419579,
      NULL,
      NULL,
      1,
      1,
      1.095023,
      2.104376,
      3.038694,
      2,
      NULL,
      3.682160,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      1.393184,
      0,
      0,
      3.656916,
      NULL,
      1,
      2.389881,
      NULL,
      NULL,
      4.798297,
      NULL,
      1,
      NULL,
      NULL,
      1.496209,
      2,
      3,
      NULL,
      0,
      NULL,
      0,
      1.504284,
      1.857301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716921,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.420069,
      1.901278,
      0,
      1.935582,
      1.012858,
      NULL,
      NULL,
      6.077870,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.813184,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.105501,
      NULL,
      NULL,
      NULL,
      0.527079,
      NULL,
      NULL,
      NULL,
      1.569777,
      NULL,
      NULL,
      NULL,
      1.147637,
      NULL,
      NULL,
      NULL,
      1,
      0.812876,
      NULL,
      NULL,
      0,
      0.254836,
      NULL,
      NULL,
      3.365379,
      1.608779,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.325483,
      1,
      NULL,
      NULL,
      1,
      1.569311,
      NULL,
      NULL,
      0.770959,
      1.524070,
      NULL,
      NULL,
      5.386435,
      1.117125,
      NULL,
      NULL,
      2,
      0.451199,
      NULL,
      NULL,
      NULL,
      1,
      174,
      34.793907,
      0,
      21.272725,
      9,
      0.965833,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.010341,
      19.296737,
      NULL,
      0.410616,
      NULL,
      NULL,
      0,
      33.937341,
      NULL,
      49,
      12,
      0,
      1.774396,
      1,
      0,
      1,
      1.915538,
      0,
      1,
      0,
      0.877668,
      0.303512,
      NULL,
      1,
      1,
      1,
      1.425546,
      0.634274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      10,
      0,
      3.593136,
      0.168043,
      1,
      0.319215,
      NULL,
      0,
      1.154542,
      NULL,
      1.473012,
      0.399204,
      NULL,
      0,
      0.016893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.162203,
      NULL,
      0,
      0,
      NULL,
      0.172733,
      NULL,
      NULL,
      0.731340,
      1.431417,
      NULL,
      1,
      0,
      NULL,
      0.061001,
      NULL,
      NULL,
      2.689084,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.922912,
      NULL,
      0,
      NULL,
      2,
      5,
      2,
      0,
      NULL,
      NULL,
      48.628903,
      86.830765,
      2,
      NULL,
      3,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.066637,
      '',
      '',
      NULL);
commit;
end;
/


