set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4310878';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1101103',
      2.925682,
      1.390522,
      0,
      0,
      '4010',
      NULL,
      1,
      NULL,
      NULL,
      '10- 1-1995',
      68,
      NULL,
      NULL,
      1.615403,
      1.789844,
      ' 4-19-2002',
      NULL,
      NULL,
      195.713202,
      147.920418,
      NULL,
      ' 9-23-1986',
      ' 7-19-1985',
      NULL,
      1.732282,
      3.891218,
      0.501808,
      0,
      NULL,
      2.450391,
      1,
      0.977041,
      NULL,
      43,
      5,
      0.954106,
      9.034430,
      NULL,
      25,
      2,
      25,
      5,
      4,
      NULL,
      1.450382,
      NULL,
      1,
      1,
      1.265432,
      0.727587,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      1,
      NULL,
      0.043892,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0.544168,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      3,
      5,
      1,
      4,
      NULL,
      5,
      1,
      NULL,
      NULL,
      4,
      0,
      5,
      1,
      NULL,
      2,
      5,
      2,
      2,
      2,
      2,
      0.021156,
      0.317363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0.242593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130968,
      4.269489,
      0.913968,
      NULL,
      1,
      4.620860,
      1.831151,
      NULL,
      NULL,
      NULL,
      0.483690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1.778091,
      0,
      0,
      3.804967,
      1521.565237,
      0.245401,
      0.641025,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      0,
      0.384044,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      3.557229,
      NULL,
      NULL,
      1,
      0,
      2.789525,
      1.296219,
      1,
      4.114690,
      2.588548,
      5,
      8,
      5.862995,
      5.900648,
      1.452308,
      NULL,
      NULL,
      1,
      0.698158,
      30,
      3,
      1,
      NULL,
      NULL,
      NULL,
      13,
      1,
      4.404767,
      0.484955,
      '21440',
      '',
      '',
      0.527971,
      '',
      '',
      '',
      1.808859,
      '',
      '',
      NULL,
      0.901606,
      57,
      248,
      49,
      3,
      NULL,
      9.415032,
      16.955533,
      3,
      1,
      NULL,
      NULL,
      0.556533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.695646,
      2,
      0.313590,
      1.178590,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712347,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.711443,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.655834,
      0.215159,
      0.088362,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828878,
      NULL,
      NULL,
      1.655666,
      NULL,
      NULL,
      1.845466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.975505,
      1,
      1.475535,
      NULL,
      NULL,
      2.315678,
      1,
      NULL,
      3,
      2.505713,
      3.693451,
      0.444732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.588459,
      0.578314,
      NULL,
      NULL,
      NULL,
      6.261777,
      1,
      0,
      8.457728,
      NULL,
      0.564224,
      0,
      NULL,
      NULL,
      0,
      0.585822,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      0.095492,
      6,
      1,
      6.375771,
      1,
      NULL,
      1.069017,
      3.860838,
      NULL,
      NULL,
      1.784290,
      NULL,
      1,
      0,
      3,
      1.680725,
      9.142841,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      3,
      1.188016,
      0,
      NULL,
      0,
      1.014089,
      3.387269,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.395327,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.963755,
      NULL,
      NULL,
      0.904414,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.514021,
      NULL,
      NULL,
      2,
      2,
      3,
      0.618862,
      0,
      3,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      424.188677,
      0.711594,
      NULL,
      NULL,
      0.658838,
      NULL,
      NULL,
      3,
      1,
      1.092891,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.883047,
      1,
      NULL,
      NULL,
      NULL,
      0.713697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.418938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2.149894,
      1.404692,
      NULL,
      0,
      2.139429,
      1,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      0.088089,
      NULL,
      NULL,
      1,
      NULL,
      0.822902,
      NULL,
      1.652730,
      0.241206,
      0,
      NULL,
      1.054843,
      2,
      2,
      NULL,
      2,
      2.836511,
      7,
      2,
      NULL,
      34,
      10,
      2,
      26.031426,
      4.609108,
      NULL,
      178.896747,
      NULL,
      1,
      125.496997,
      95.527208,
      2,
      5.987478,
      0.889326,
      0,
      NULL,
      NULL,
      0.892868,
      7,
      1,
      112,
      34,
      1.581788,
      0.090262,
      1.991057,
      NULL,
      1,
      1,
      1.804832,
      0.305978,
      NULL,
      1.308132,
      0.180051,
      1.729208,
      0.419141,
      1,
      1.936664,
      1,
      0.009432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      0.391350,
      2.427337,
      1,
      0.504827,
      2.162132,
      3.991346,
      1,
      1,
      0.080180,
      0,
      0.349299,
      1.197417,
      1,
      0,
      1.858109,
      1.365910,
      NULL,
      1,
      0,
      1.780214,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.280944,
      NULL,
      NULL,
      1.922760,
      NULL,
      1.421126,
      0,
      1.937308,
      1,
      NULL,
      NULL,
      1.486742,
      0,
      1.451445,
      1.841864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396461,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.742325,
      NULL,
      3,
      NULL,
      0.322195,
      NULL,
      0.915816,
      NULL,
      1.815900,
      NULL,
      2,
      NULL,
      0.073903,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      216,
      NULL,
      1.269160,
      NULL,
      1.665291,
      0,
      1.319796,
      1,
      3,
      4,
      1.020635,
      0.474681,
      NULL,
      79.556968,
      46.526470,
      3,
      1.535500,
      7.490787,
      '1240',
      '34043',
      '40102',
      0,
      '0333',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


