set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885315';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.122127,
      0,
      2.684542,
      1.878657,
      3,
      2,
      3.648665,
      0.312565,
      '431',
      '41201401',
      NULL,
      NULL,
      '2334324',
      2,
      1.973776,
      0,
      0,
      '4423',
      2,
      0,
      NULL,
      NULL,
      ' 0-20-1993',
      94.619754,
      37.724274,
      NULL,
      1,
      0,
      ' 6-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8-15-2003',
      ' 4-29-1994',
      NULL,
      2.993512,
      0,
      3.710188,
      1,
      1,
      2.496649,
      0,
      0.290516,
      1.394417,
      3,
      3,
      18,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      0.008966,
      0.450999,
      NULL,
      5,
      0.326123,
      1,
      1,
      NULL,
      1,
      4,
      NULL,
      5,
      0,
      NULL,
      0,
      1,
      2,
      2,
      1,
      3,
      0,
      1,
      0,
      9.741227,
      1,
      2,
      1,
      NULL,
      0.318896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.684205,
      0.621752,
      0.186388,
      NULL,
      3,
      1.542516,
      1.899359,
      2.462357,
      0,
      1.800279,
      1,
      2,
      1.951184,
      1.029705,
      0,
      3.179122,
      1.023429,
      NULL,
      NULL,
      NULL,
      0.611303,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      0.382176,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      5,
      0,
      4,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.571964,
      NULL,
      5,
      4,
      1,
      3,
      2,
      3,
      2,
      3,
      1,
      5,
      5,
      5,
      2,
      1,
      1,
      2,
      0,
      3,
      3,
      5,
      3,
      1,
      2,
      NULL,
      NULL,
      5,
      3,
      1.849783,
      '10-29-1996',
      201,
      NULL,
      20.371419,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      5,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      0.591349,
      2.768302,
      1,
      6,
      0,
      NULL,
      2.923494,
      5.262406,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.737328,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.278940,
      0.274004,
      0,
      2.201118,
      27.686411,
      0.016863,
      1.687291,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.528529,
      1,
      3,
      0,
      2,
      2,
      3,
      NULL,
      2,
      2,
      1,
      2,
      0.900498,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.969531,
      0.306516,
      1.609104,
      1,
      0,
      NULL,
      1.541663,
      0.210233,
      0,
      0.988296,
      3.131611,
      0,
      2.865686,
      4,
      3,
      0,
      NULL,
      0.546841,
      2,
      1,
      2,
      0.455971,
      1,
      3.183361,
      31,
      2,
      3,
      56,
      NULL,
      37,
      65,
      0,
      3.504150,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      10.565277,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468234,
      NULL,
      NULL,
      1.385120,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.076314,
      NULL,
      NULL,
      0.452564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829168,
      NULL,
      NULL,
      0.250476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.528285,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.500500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008921,
      NULL,
      NULL,
      0.229773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.210269,
      NULL,
      NULL,
      1.540388,
      NULL,
      NULL,
      0.690063,
      4,
      0,
      1,
      NULL,
      NULL,
      1.375556,
      NULL,
      NULL,
      0.435041,
      1,
      3.619039,
      NULL,
      0.589769,
      3,
      4.268599,
      0.690557,
      2,
      2,
      NULL,
      0,
      1.312813,
      NULL,
      NULL,
      0,
      2,
      2.428993,
      NULL,
      1.427361,
      2.180861,
      5,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1.631829,
      NULL,
      NULL,
      1.693265,
      0.905816,
      NULL,
      0,
      1.528439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.859078,
      0,
      1.743283,
      3.796533,
      1,
      1,
      0,
      0.093534,
      NULL,
      NULL,
      NULL,
      5.225436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.183177,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.962960,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.685130,
      NULL,
      NULL,
      NULL,
      1.507143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.258898,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.019509,
      NULL,
      NULL,
      NULL,
      0.465208,
      NULL,
      NULL,
      NULL,
      2.818585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      3.970995,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.057051,
      NULL,
      NULL,
      0.249410,
      NULL,
      1,
      3.925414,
      7,
      0.023968,
      0.250499,
      1.803498,
      1,
      1.104922,
      1,
      0.386119,
      0,
      0.999730,
      NULL,
      0,
      1,
      1.930985,
      NULL,
      0.644962,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090308,
      0.429082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960367,
      3,
      NULL,
      1,
      NULL,
      1.606639,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2.916478,
      3.435423,
      0,
      0,
      NULL,
      NULL,
      1,
      0.181544,
      0.768226,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.068043,
      NULL,
      0.475295,
      NULL,
      NULL,
      1.006949,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.894474,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      3.818217,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.817962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.656676,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      23.777755,
      77,
      1,
      3.095536,
      0,
      '22411',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


