set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311269';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1433122',
      NULL,
      0,
      2,
      0,
      '4004',
      NULL,
      1.573599,
      NULL,
      NULL,
      ' 5- 1-1978',
      59.836418,
      NULL,
      3,
      0.872390,
      0.787009,
      '11- 7-1984',
      17.836897,
      3.102443,
      NULL,
      90.305975,
      NULL,
      '11- 9-1987',
      ' 9-18-1979',
      ' 7- 1-1989',
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1.140813,
      1,
      7,
      5.731219,
      1.089895,
      13.633065,
      2,
      NULL,
      8.736352,
      5,
      NULL,
      1,
      NULL,
      0,
      1,
      1.767674,
      1.548006,
      1.813169,
      1.493463,
      NULL,
      0,
      3.395169,
      NULL,
      3,
      0,
      1,
      0,
      2,
      1,
      0,
      5,
      1,
      0,
      4,
      0,
      4,
      NULL,
      1,
      1,
      0,
      1,
      2,
      NULL,
      0,
      1.077788,
      NULL,
      NULL,
      0.363115,
      NULL,
      NULL,
      4,
      0,
      2.470226,
      2,
      NULL,
      1.753571,
      3,
      2.464268,
      0.497184,
      NULL,
      1.750184,
      0.240362,
      1.850872,
      3.445365,
      0,
      2.084620,
      0,
      2.750150,
      3.639487,
      1,
      NULL,
      NULL,
      2,
      3,
      1,
      3,
      0.236155,
      NULL,
      NULL,
      1.768411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3.127700,
      1,
      0,
      1,
      0,
      0.152771,
      NULL,
      0,
      4,
      NULL,
      NULL,
      4,
      3,
      4,
      2,
      5,
      4,
      5,
      0,
      1,
      0,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      1,
      0,
      NULL,
      NULL,
      0.013876,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085488,
      1,
      NULL,
      NULL,
      1,
      1.675708,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.509054,
      1.481905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1.720397,
      NULL,
      NULL,
      1,
      NULL,
      3.928007,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.749341,
      2,
      3,
      0,
      1,
      3,
      2,
      3,
      NULL,
      0,
      1,
      3.601099,
      2,
      0.940841,
      0.077237,
      0,
      1,
      1,
      1.693774,
      1.457150,
      NULL,
      NULL,
      NULL,
      0.088723,
      NULL,
      0.202455,
      1,
      NULL,
      NULL,
      0,
      8.804345,
      7.409826,
      7,
      8,
      3.189933,
      5.035768,
      NULL,
      0,
      2,
      3.882094,
      1,
      0,
      44,
      3,
      1.324544,
      NULL,
      35,
      49,
      32.927272,
      NULL,
      0.359101,
      0.413943,
      '03143',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.513822,
      '',
      NULL,
      '',
      0,
      3,
      0.840322,
      42.900081,
      1,
      41.179203,
      3.005894,
      1.384453,
      3,
      2.104375,
      1,
      0,
      0.835762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.401874,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.668602,
      1.331814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.826523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.685427,
      9,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.985207,
      NULL,
      NULL,
      0.465905,
      NULL,
      NULL,
      3.604188,
      1,
      0.980176,
      0.587063,
      NULL,
      3.017615,
      0.785486,
      2.935347,
      1.000175,
      0,
      0.431223,
      NULL,
      1,
      0,
      3.248387,
      0,
      1,
      NULL,
      NULL,
      1.376594,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060356,
      0.488102,
      1.996825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.296373,
      1.476929,
      1.224605,
      0,
      0,
      NULL,
      NULL,
      4.085543,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.569208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5,
      1,
      NULL,
      NULL,
      NULL,
      3.027104,
      0,
      0.557322,
      0,
      2,
      0.557606,
      3,
      2,
      0.396283,
      NULL,
      0,
      1.129931,
      2,
      1.486209,
      NULL,
      0.997158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.406131,
      0,
      1,
      2.296584,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0.518279,
      NULL,
      0,
      1.257471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948132,
      0.261808,
      1.530193,
      1,
      0.637986,
      0.619375,
      1.918318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.186200,
      1,
      1.323588,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.781400,
      0.164033,
      0.979058,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.063222,
      1353.652952,
      1,
      0.631585,
      1.404560,
      1.564354,
      0.898335,
      1,
      0,
      0.769444,
      1.884008,
      1.298600,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1.842140,
      0,
      1.533799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      2.863811,
      1.608295,
      3,
      10.866585,
      3.540620,
      1.852451,
      1.736265,
      NULL,
      NULL,
      0.962759,
      0.867642,
      0,
      3,
      0.159462,
      NULL,
      NULL,
      1.741596,
      NULL,
      0.397013,
      1,
      NULL,
      NULL,
      1.212250,
      0,
      NULL,
      3,
      3.670673,
      3.614157,
      NULL,
      NULL,
      1.128659,
      1,
      1.501473,
      NULL,
      0.151694,
      1,
      1.707256,
      1,
      0,
      1.754984,
      0,
      1,
      1.333949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613919,
      NULL,
      NULL,
      NULL,
      1.584211,
      NULL,
      NULL,
      NULL,
      2,
      0.479440,
      NULL,
      NULL,
      99,
      131,
      4,
      1.055631,
      3,
      NULL,
      '',
      '',
      0.032710,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


