set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1040111',
      3.757588,
      NULL,
      6,
      3,
      '3012',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.737406,
      ' 2- 5-1986',
      NULL,
      1,
      307.814881,
      76.490360,
      3,
      ' 3-18-1993',
      ' 9- 3-2002',
      '10- 6-1993',
      1.665694,
      0.472197,
      1,
      NULL,
      1,
      0.833197,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      20,
      20,
      4,
      11.471205,
      NULL,
      NULL,
      8.308826,
      1.226502,
      2,
      NULL,
      0,
      1,
      1.928953,
      0.405100,
      1.464913,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      1,
      NULL,
      2,
      5,
      NULL,
      1,
      3,
      1,
      4,
      5,
      2,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.932535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      4.685167,
      3.179869,
      3,
      1,
      2.866470,
      3.644058,
      3,
      1.421780,
      3,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      3.578754,
      2,
      5,
      3,
      NULL,
      NULL,
      1,
      1,
      2.457228,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      1,
      5,
      5,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.411776,
      0,
      NULL,
      0,
      4,
      1,
      5,
      5,
      1,
      0,
      4,
      NULL,
      5,
      1,
      3,
      1,
      0,
      NULL,
      1,
      5,
      1,
      3,
      4,
      4,
      0,
      5,
      3.277281,
      2,
      NULL,
      77.349330,
      NULL,
      88,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.427149,
      0.485441,
      2,
      NULL,
      1,
      3.950226,
      0.893014,
      1.464781,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      1.575057,
      0,
      1.243054,
      4.860872,
      6,
      0,
      NULL,
      NULL,
      NULL,
      5.694872,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276098,
      1.111815,
      3.277852,
      1.661572,
      1,
      1,
      1.017791,
      46,
      0,
      1.854670,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.227506,
      3,
      0,
      0,
      0,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      3,
      0.229497,
      3,
      7.529408,
      0,
      1,
      1.090331,
      1.632595,
      1,
      1.386814,
      0,
      1.266453,
      0,
      0.393221,
      1,
      1,
      NULL,
      2,
      1,
      4.277511,
      5,
      5.629580,
      NULL,
      NULL,
      2.110643,
      1,
      1.384464,
      6,
      2.429793,
      1,
      2.332690,
      6,
      3,
      0,
      NULL,
      22,
      NULL,
      102.005116,
      NULL,
      1.268785,
      NULL,
      '02431',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.613083,
      '',
      '',
      '',
      3.800951,
      14.076237,
      20,
      22.401820,
      3,
      36.635530,
      NULL,
      3,
      4,
      2.985594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.874145,
      2,
      0.379245,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.017514,
      2.160784,
      3.898912,
      0.840918,
      NULL,
      NULL,
      3,
      0,
      0,
      0.009671,
      NULL,
      0.132395,
      NULL,
      2.271460,
      0.279200,
      0,
      NULL,
      NULL,
      3,
      0.587283,
      2,
      3,
      0.672885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.730741,
      0,
      2.038625,
      0,
      1,
      NULL,
      NULL,
      2.662590,
      NULL,
      0.737714,
      0.395167,
      2.730454,
      3,
      2.599216,
      1,
      1,
      1,
      2,
      0,
      1,
      0.280063,
      0.936346,
      0,
      NULL,
      1.614526,
      0.246998,
      NULL,
      NULL,
      1.537130,
      NULL,
      NULL,
      0.041818,
      NULL,
      NULL,
      10,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579279,
      NULL,
      NULL,
      2.718397,
      2,
      NULL,
      NULL,
      1,
      1.076193,
      1.596709,
      NULL,
      NULL,
      0,
      5.494484,
      1.345356,
      3.226598,
      NULL,
      0.254955,
      0,
      NULL,
      NULL,
      0,
      3.470383,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.137835,
      NULL,
      NULL,
      1.019596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.085225,
      1.717361,
      NULL,
      0.604083,
      NULL,
      NULL,
      5,
      1,
      1,
      7.120931,
      1.781489,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686998,
      NULL,
      3,
      2,
      2.686770,
      3.105224,
      0,
      5,
      7.214114,
      5.345661,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.753784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753120,
      NULL,
      NULL,
      1.223532,
      7.458689,
      5.181310,
      2,
      0,
      NULL,
      1,
      0.862321,
      NULL,
      1.218885,
      0.113121,
      1.428998,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.422256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741327,
      NULL,
      NULL,
      4.933396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.849594,
      0.040097,
      1.175376,
      0.072030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.327712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.758074,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.106524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686782,
      NULL,
      NULL,
      NULL,
      1.415755,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.600492,
      NULL,
      NULL,
      NULL,
      2.520136,
      NULL,
      NULL,
      NULL,
      3.016994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      2.999439,
      3,
      6,
      0,
      2,
      13.475846,
      13,
      3,
      2.951672,
      2.445349,
      1,
      NULL,
      NULL,
      NULL,
      1.172553,
      0.938767,
      1.816770,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.480873,
      NULL,
      1.776223,
      624.625317,
      4.860918,
      1,
      NULL,
      NULL,
      1,
      1,
      0.255343,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0.864489,
      1,
      1.199064,
      0.331864,
      NULL,
      2.860426,
      NULL,
      NULL,
      NULL,
      0.156987,
      NULL,
      0.367335,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990561,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.436734,
      NULL,
      NULL,
      NULL,
      1.624034,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.017171,
      1,
      0.506098,
      NULL,
      1.705546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.755385,
      NULL,
      0.617217,
      NULL,
      1,
      NULL,
      1.593578,
      1.012354,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.243230,
      NULL,
      1.662593,
      NULL,
      NULL,
      0.300753,
      1.818857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.967335,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545851,
      1.474688,
      1,
      NULL,
      3,
      NULL,
      112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      29.355050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6,
      0.273009,
      0,
      NULL,
      1,
      2.286957,
      1.180603,
      2.464453,
      0.821878,
      0.231180,
      NULL,
      NULL,
      1.754357,
      2.222143,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.195312,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.163694,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.918741,
      NULL,
      1.026825,
      NULL,
      NULL,
      1.527186,
      0.087058,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2,
      NULL,
      1.734568,
      NULL,
      0.700239,
      NULL,
      1.728918,
      NULL,
      2.133469,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.833681,
      1.948572,
      1,
      1.222427,
      NULL,
      1.527835,
      NULL,
      1,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      44.806892,
      5,
      1,
      NULL,
      '32144',
      '03410',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


