set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      2,
      0.294073,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-19-2000',
      38.409290,
      NULL,
      0,
      NULL,
      2,
      ' 7- 5-1975',
      37.863536,
      1,
      NULL,
      106,
      0,
      ' 3-20-1988',
      NULL,
      ' 3-29-1996',
      0.440449,
      0,
      1.719680,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      10,
      NULL,
      14,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      0,
      3,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2.643414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      2,
      2,
      NULL,
      2,
      NULL,
      5,
      2,
      1,
      3,
      2,
      3,
      0,
      2,
      NULL,
      NULL,
      2,
      3,
      2,
      4,
      3,
      0,
      5,
      5.703715,
      NULL,
      ' 9- 8-1989',
      100.795349,
      ' 1- 7-1987',
      56,
      1.868708,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919604,
      1.747960,
      1.508707,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.808515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.118587,
      0,
      NULL,
      3,
      1.136355,
      0,
      0.429678,
      2.965141,
      26,
      0.644366,
      0.441547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602296,
      2,
      0,
      3,
      NULL,
      3,
      3,
      1,
      2,
      1,
      2,
      NULL,
      1.350870,
      2.803237,
      1,
      1.330627,
      1,
      NULL,
      0,
      0.085691,
      0,
      0.861123,
      0.464340,
      1.595884,
      0,
      1,
      0,
      1.065335,
      3.242564,
      0.954161,
      5.609773,
      6,
      1,
      7,
      NULL,
      NULL,
      NULL,
      0.516164,
      NULL,
      3.895888,
      2.449292,
      1.187100,
      NULL,
      0,
      0,
      NULL,
      26,
      29,
      59.364753,
      1,
      0.629636,
      NULL,
      '34044',
      '',
      '',
      3,
      '2433',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      30.727840,
      NULL,
      1.369915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085908,
      1,
      0.925326,
      1.405569,
      NULL,
      NULL,
      1.131797,
      NULL,
      NULL,
      1.512959,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.126611,
      NULL,
      1.991407,
      1.397926,
      1.152485,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367933,
      NULL,
      NULL,
      2,
      NULL,
      0.346842,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.842856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.127489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.808540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432058,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.216358,
      NULL,
      NULL,
      1.037689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.455125,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757925,
      2.360777,
      0.041845,
      NULL,
      NULL,
      1.757885,
      NULL,
      NULL,
      0.806229,
      NULL,
      NULL,
      1.982101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.955217,
      NULL,
      NULL,
      1.930194,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.088367,
      NULL,
      NULL,
      3.799218,
      NULL,
      NULL,
      0.680336,
      0,
      1,
      3,
      NULL,
      1.440799,
      0,
      1.345535,
      3.225024,
      NULL,
      1.449732,
      1.540774,
      2.663889,
      1,
      3,
      2.394900,
      0.696113,
      5,
      2.696240,
      1.832560,
      1.925647,
      NULL,
      0.405961,
      0,
      NULL,
      0.484852,
      0.233943,
      0,
      1,
      1.117747,
      3.317027,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.325112,
      NULL,
      4,
      NULL,
      1.336488,
      0.484920,
      0,
      0.600355,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.616696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.016677,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.540217,
      NULL,
      NULL,
      0.869396,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.620880,
      0,
      0,
      NULL,
      NULL,
      1.843410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.423836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.122472,
      1.347076,
      NULL,
      NULL,
      0.335693,
      NULL,
      NULL,
      1.888306,
      NULL,
      NULL,
      1.772065,
      NULL,
      NULL,
      1.092114,
      NULL,
      NULL,
      1.098590,
      NULL,
      NULL,
      825,
      6.139856,
      NULL,
      0,
      0,
      1.917317,
      1,
      NULL,
      0.465317,
      NULL,
      0,
      NULL,
      0,
      1.820289,
      1.442794,
      NULL,
      1,
      NULL,
      NULL,
      3.658828,
      NULL,
      1,
      NULL,
      1.912551,
      NULL,
      NULL,
      NULL,
      0.250905,
      NULL,
      0,
      NULL,
      145.412180,
      NULL,
      0,
      7,
      NULL,
      1.002068,
      1,
      3,
      NULL,
      0,
      NULL,
      0.241892,
      NULL,
      0.443847,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.662999,
      NULL,
      0.977016,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.596728,
      NULL,
      NULL,
      NULL,
      0.439322,
      NULL,
      1.624944,
      1.086810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.892075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.785551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.328813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      7.827269,
      NULL,
      1,
      5.345779,
      2,
      4.077247,
      0.690600,
      3.959231,
      1.920725,
      1.045030,
      1.278641,
      NULL,
      0.691789,
      1.548017,
      NULL,
      0.599941,
      2,
      NULL,
      0,
      1.686461,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332180,
      1.995159,
      NULL,
      0,
      1,
      NULL,
      1.637429,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.764108,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.766577,
      NULL,
      0,
      NULL,
      0.271955,
      NULL,
      NULL,
      NULL,
      0,
      1.733756,
      NULL,
      NULL,
      26,
      54.660280,
      2,
      4,
      5.115535,
      '20132',
      NULL,
      '',
      NULL,
      '0133',
      NULL,
      '',
      0.901491,
      '',
      '',
      '');
commit;
end;
/


