set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.225639,
      NULL,
      3,
      1,
      3,
      NULL,
      1.702290,
      '30',
      '34',
      NULL,
      15.147016,
      NULL,
      4,
      0.455643,
      6,
      NULL,
      '4230',
      2,
      0,
      NULL,
      NULL,
      '11- 0-1983',
      96.227120,
      20,
      NULL,
      1.236671,
      0,
      ' 7- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.896338,
      0,
      NULL,
      1,
      1.172184,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.643996,
      0,
      NULL,
      NULL,
      1.328867,
      1.955884,
      NULL,
      3,
      2,
      4,
      1,
      2,
      1,
      1,
      NULL,
      0,
      0,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      2.462783,
      0,
      1,
      1,
      0,
      1.122107,
      NULL,
      NULL,
      0.954865,
      NULL,
      NULL,
      1,
      0,
      1,
      1.397970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      3,
      5,
      2,
      0,
      1,
      5,
      1,
      4,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0.077189,
      NULL,
      1.209791,
      3,
      NULL,
      1,
      0,
      5,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      4,
      5,
      5,
      5,
      3,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      1.422125,
      ' 2-10-1990',
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      2.337784,
      2,
      3.967308,
      1.285492,
      0.175370,
      0,
      0,
      NULL,
      0,
      1.077902,
      NULL,
      NULL,
      NULL,
      0,
      1.209632,
      NULL,
      4.449909,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.748573,
      1.459110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.606153,
      1,
      NULL,
      1.268065,
      1,
      1,
      1.139225,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.719027,
      2,
      0,
      2,
      2,
      2,
      2,
      3,
      2,
      NULL,
      3,
      1.823161,
      1,
      1,
      2,
      0.996310,
      0.444007,
      3,
      1.295179,
      1,
      0.167955,
      0,
      NULL,
      1,
      1,
      1.020797,
      NULL,
      1.052976,
      1.956044,
      3.170878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      39,
      NULL,
      NULL,
      NULL,
      4,
      0,
      6,
      '21404',
      '13420',
      '21240',
      0.610781,
      '',
      '',
      '',
      3.984428,
      NULL,
      '1133',
      '',
      0.851653,
      9,
      26.954353,
      5,
      0,
      18,
      2.200753,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.281034,
      NULL,
      NULL,
      0.149294,
      NULL,
      NULL,
      0.050545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.427044,
      NULL,
      1.757613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724650,
      NULL,
      NULL,
      1.635475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      7.591938,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359095,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835703,
      NULL,
      NULL,
      1.702272,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      0.903781,
      NULL,
      NULL,
      2.768593,
      4,
      0.741698,
      0.506993,
      0.543692,
      1,
      1,
      NULL,
      NULL,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.417623,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.612352,
      1.182496,
      NULL,
      NULL,
      NULL,
      5,
      4,
      3.001081,
      2,
      0.466847,
      1,
      1.410807,
      1,
      1,
      NULL,
      NULL,
      0.465637,
      3.794040,
      4,
      3.130360,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      1.747197,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.055068,
      NULL,
      NULL,
      0.041202,
      0.937602,
      1.605903,
      0,
      0,
      1,
      NULL,
      1.686347,
      1.769455,
      NULL,
      3,
      NULL,
      NULL,
      0.907415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604319,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.940263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.041812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241325,
      NULL,
      NULL,
      0.382252,
      1.438937,
      1.573691,
      0,
      1.133302,
      2.466302,
      1.579083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.420642,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.020341,
      NULL,
      NULL,
      NULL,
      0.663214,
      NULL,
      NULL,
      NULL,
      2.257444,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.141785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799165,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.670062,
      0,
      NULL,
      NULL,
      5,
      1.672801,
      1.507779,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401214,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.232696,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.917934,
      1,
      NULL,
      0.194139,
      0,
      0,
      0.284361,
      0,
      1.749238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.702113,
      1,
      7,
      3.892498,
      0,
      8.018257,
      3.182624,
      1.518543,
      0,
      1.592463,
      0,
      NULL,
      0.421957,
      0,
      NULL,
      1,
      1,
      NULL,
      1.328776,
      1.833471,
      NULL,
      NULL,
      1,
      NULL,
      1.866429,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.156650,
      NULL,
      3.682162,
      NULL,
      NULL,
      2,
      3.318761,
      NULL,
      1,
      3.143642,
      NULL,
      0.237925,
      1,
      0.897701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.043985,
      1.536426,
      '12121',
      '41312',
      '42024',
      NULL,
      NULL,
      '',
      NULL,
      0,
      '30130',
      '0214',
      '');
commit;
end;
/


