set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1112233',
      3.721270,
      1,
      NULL,
      1,
      '3313',
      0.675029,
      1,
      NULL,
      NULL,
      ' 2-21-1976',
      53.853782,
      NULL,
      1,
      0,
      NULL,
      ' 5-13-1988',
      2,
      0.709359,
      NULL,
      14,
      0,
      '11-27-2002',
      ' 2-10-1978',
      ' 7-21-1974',
      1,
      2,
      NULL,
      0.629733,
      NULL,
      0.161999,
      NULL,
      2.842899,
      NULL,
      NULL,
      NULL,
      7.651333,
      2,
      9,
      1,
      NULL,
      NULL,
      0,
      1,
      2.702701,
      NULL,
      0,
      NULL,
      0.813648,
      0,
      0,
      1.205974,
      NULL,
      1,
      0,
      0,
      0,
      6,
      2,
      1,
      5,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      0,
      3,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.277115,
      NULL,
      NULL,
      2,
      NULL,
      1.471278,
      2.661114,
      1.007520,
      0,
      0,
      3.170105,
      NULL,
      2,
      0.019893,
      1.715102,
      0,
      2,
      NULL,
      NULL,
      3.881856,
      1,
      1,
      1,
      1,
      4,
      2.078022,
      NULL,
      0,
      1.055681,
      1.854069,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      0,
      4,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      6.711643,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.675816,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      3,
      0,
      4,
      1,
      NULL,
      3,
      4,
      4,
      3,
      4,
      1,
      4,
      9.849208,
      0,
      ' 9-29-1974',
      12,
      NULL,
      9,
      0.001949,
      1,
      2,
      4,
      NULL,
      3,
      NULL,
      2,
      0,
      3,
      0,
      0,
      3,
      4,
      4,
      1,
      0,
      8,
      0.644687,
      10,
      0.731852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.170203,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      1.866578,
      1,
      0.818226,
      1.479346,
      2.102249,
      NULL,
      NULL,
      1.444689,
      NULL,
      NULL,
      1.977109,
      4.665771,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.341307,
      0,
      0,
      0.506688,
      1,
      1,
      NULL,
      NULL,
      23.793526,
      1.177567,
      0.896848,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.446891,
      2,
      3,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      2,
      2.125347,
      0,
      8.788129,
      NULL,
      163.117274,
      157,
      NULL,
      109,
      NULL,
      NULL,
      1.187344,
      0.434712,
      1.548058,
      1.659854,
      0.696889,
      1,
      2,
      17.555294,
      1,
      0.950643,
      1,
      NULL,
      7,
      NULL,
      1,
      0,
      2.679848,
      1,
      1.919185,
      1,
      1,
      26,
      1,
      2,
      NULL,
      NULL,
      NULL,
      97,
      NULL,
      NULL,
      1,
      '02031',
      NULL,
      NULL,
      1.388405,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.979295,
      22,
      33.548009,
      0,
      0.043366,
      NULL,
      4.982185,
      NULL,
      3,
      0,
      0,
      2,
      0.014857,
      NULL,
      NULL,
      1,
      0.641702,
      1,
      NULL,
      0,
      0.399421,
      1,
      3,
      0,
      0,
      1.157939,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.366511,
      0,
      2.587984,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.114949,
      0.938608,
      2.178514,
      NULL,
      3.280887,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.884777,
      3,
      2.443248,
      0,
      0,
      1.198085,
      1.787072,
      NULL,
      NULL,
      2,
      0,
      1,
      0.076213,
      2,
      0,
      0.011059,
      NULL,
      1,
      1.151483,
      1.522978,
      3.421471,
      0.417259,
      0,
      1,
      NULL,
      3,
      NULL,
      1.852056,
      3,
      3,
      0.586838,
      NULL,
      1,
      1,
      4,
      0,
      3,
      0,
      0.667346,
      NULL,
      NULL,
      NULL,
      0.796595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.455726,
      2.608374,
      2.022378,
      1.736609,
      0.466883,
      NULL,
      NULL,
      7.718250,
      0,
      0.746957,
      1.632683,
      0,
      NULL,
      1.545918,
      NULL,
      1,
      6.584777,
      7,
      1.012254,
      0.668990,
      NULL,
      NULL,
      1.796741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681767,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.838434,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.825167,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      5.788450,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.646127,
      0,
      2,
      2.951813,
      0.044682,
      NULL,
      2.023626,
      3.696459,
      3,
      2.710970,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      2,
      1.888708,
      0,
      2,
      NULL,
      2.706884,
      1.886476,
      2.656918,
      2.838077,
      0.135535,
      2,
      NULL,
      0,
      1.952700,
      1.480776,
      1.943076,
      1,
      0,
      1.415665,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      10.132759,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.369992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.834427,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.606209,
      1,
      1.393317,
      1.132359,
      NULL,
      NULL,
      4,
      2.879540,
      NULL,
      NULL,
      2.581438,
      2.448081,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.579963,
      2.881224,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.982731,
      NULL,
      NULL,
      0.598963,
      NULL,
      NULL,
      NULL,
      1.625785,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.334835,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.240530,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.090383,
      6.625541,
      NULL,
      NULL,
      1.355572,
      NULL,
      NULL,
      NULL,
      2,
      31.575708,
      NULL,
      NULL,
      4.481772,
      NULL,
      0.588883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147324,
      NULL,
      1,
      394.242777,
      5.738246,
      NULL,
      NULL,
      1.247051,
      1,
      0.779093,
      1,
      1.112965,
      0,
      0.537797,
      1.211077,
      NULL,
      3.465708,
      0,
      1,
      NULL,
      0.979129,
      0,
      0.563622,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.896725,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.330661,
      NULL,
      0.468679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923599,
      NULL,
      NULL,
      NULL,
      0.220784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139462,
      0.329130,
      NULL,
      NULL,
      2,
      NULL,
      0.092661,
      NULL,
      2,
      NULL,
      3.874036,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.433669,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887139,
      NULL,
      3.150155,
      NULL,
      7.805423,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      38,
      NULL,
      1,
      1.806074,
      3.104213,
      3.492296,
      0,
      1,
      1,
      2,
      3,
      1,
      NULL,
      2,
      2.020306,
      0,
      0,
      1.603734,
      0,
      1,
      1,
      1.116206,
      0.256114,
      3,
      NULL,
      0.943213,
      1,
      0.951501,
      1,
      0,
      0,
      1.147199,
      0.728080,
      0,
      1,
      NULL,
      1.614629,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.536664,
      0.144154,
      NULL,
      2,
      NULL,
      0.058572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.993030,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.648904,
      NULL,
      1.137409,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.431123,
      5,
      0.559888,
      2,
      0,
      1.654685,
      NULL,
      0.744747,
      NULL,
      NULL,
      4,
      2,
      4,
      NULL,
      NULL,
      NULL,
      38.861531,
      NULL,
      1,
      NULL,
      5,
      '23123',
      '44232',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


