set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      2,
      0.657559,
      1,
      1,
      '3330',
      2.387896,
      NULL,
      NULL,
      NULL,
      ' 7-22-1981',
      48,
      NULL,
      3,
      NULL,
      1.634221,
      ' 5- 1-1987',
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1996',
      ' 8-18-1986',
      ' 5-16-2000',
      1.216478,
      0,
      NULL,
      NULL,
      1.905016,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      6,
      0,
      30.037437,
      32,
      NULL,
      NULL,
      NULL,
      1,
      7,
      0,
      2,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.614808,
      0,
      0.096058,
      0.744367,
      1.333215,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0.306104,
      1,
      1.220914,
      0,
      0.230313,
      1,
      1,
      0,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      1.508193,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      0,
      1,
      2,
      NULL,
      0,
      2,
      3,
      0,
      3.979473,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1.494296,
      4,
      3,
      1,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      4,
      0,
      0,
      3,
      4,
      1,
      0,
      5,
      4,
      4,
      2,
      NULL,
      5,
      4,
      4,
      4,
      3.402128,
      NULL,
      ' 9- 7-2002',
      4,
      ' 2- 8-1995',
      NULL,
      0,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1,
      1,
      2,
      4,
      NULL,
      NULL,
      0,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.660414,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1.662796,
      NULL,
      0.360355,
      NULL,
      3.914560,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.283327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.169936,
      1,
      0.276151,
      1.543099,
      0.292422,
      0.470181,
      NULL,
      NULL,
      2.288473,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      0,
      1,
      1,
      3,
      1,
      0,
      3,
      0,
      1,
      3.065683,
      10.261685,
      19,
      180,
      80,
      135,
      88,
      23,
      128.807944,
      0.218268,
      0,
      NULL,
      NULL,
      1,
      1.000693,
      0,
      3.130835,
      2.043001,
      2.853198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      7,
      79.482191,
      NULL,
      0.146077,
      5.263751,
      NULL,
      '13324',
      '',
      1.910568,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      20,
      32,
      NULL,
      0.021550,
      NULL,
      7,
      3,
      0,
      3.398117,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.089564,
      3.168376,
      1,
      1.345369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.128341,
      2.378513,
      0.992228,
      0.885996,
      NULL,
      NULL,
      0,
      1.280395,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.662175,
      NULL,
      NULL,
      0,
      9.022426,
      5.332130,
      NULL,
      1.020375,
      NULL,
      NULL,
      NULL,
      0.883615,
      NULL,
      NULL,
      NULL,
      0.492512,
      3.600487,
      NULL,
      1.972225,
      3,
      0.698217,
      1,
      NULL,
      NULL,
      1.726545,
      0,
      1,
      NULL,
      1,
      0,
      2,
      0.738572,
      1,
      0.881316,
      1.023830,
      1.999577,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1.971050,
      NULL,
      NULL,
      NULL,
      NULL,
      9.494500,
      3,
      3,
      0.332413,
      NULL,
      NULL,
      NULL,
      0.795310,
      NULL,
      NULL,
      NULL,
      1.128101,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      0.057982,
      NULL,
      0,
      NULL,
      NULL,
      8.126865,
      9.420971,
      3.911127,
      3,
      NULL,
      1,
      3.217885,
      1.223446,
      1.755322,
      NULL,
      7.547745,
      0.520789,
      0.546577,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.309134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.459290,
      2.196775,
      0.193059,
      NULL,
      NULL,
      2,
      1,
      4,
      NULL,
      7.055895,
      3,
      4,
      0.121361,
      0.885665,
      NULL,
      NULL,
      NULL,
      3.928742,
      3.666652,
      1.317754,
      0.750154,
      3.086131,
      NULL,
      4,
      5.671369,
      3.511479,
      2,
      3.915697,
      2.614713,
      5,
      NULL,
      NULL,
      0,
      3.934278,
      2,
      0,
      3.931510,
      0.248824,
      1,
      3,
      4,
      7.228202,
      NULL,
      3,
      1,
      2,
      3,
      2.660742,
      1.771054,
      0,
      1,
      NULL,
      1.992778,
      NULL,
      NULL,
      4.020097,
      NULL,
      NULL,
      9.694726,
      NULL,
      NULL,
      0.892392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.893726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      3,
      1.619788,
      0.482344,
      0.162792,
      1.748934,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      2.728591,
      NULL,
      NULL,
      NULL,
      2.427552,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.300609,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.686456,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0.491485,
      NULL,
      NULL,
      3.774359,
      1.410995,
      NULL,
      NULL,
      1.287905,
      0.913154,
      NULL,
      NULL,
      2.034682,
      0,
      NULL,
      NULL,
      NULL,
      3.536518,
      NULL,
      NULL,
      0.588278,
      1.591736,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.979851,
      0.219572,
      NULL,
      1.912251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034130,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226288,
      260,
      3.979388,
      NULL,
      0,
      3,
      NULL,
      1.617433,
      1.774479,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1.163991,
      1.824411,
      NULL,
      0.661265,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.467386,
      NULL,
      1.877025,
      NULL,
      48,
      NULL,
      2.569684,
      NULL,
      34,
      NULL,
      1.910163,
      NULL,
      2,
      0.839706,
      NULL,
      NULL,
      NULL,
      1.590158,
      NULL,
      1,
      NULL,
      1.276609,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.102307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806977,
      2,
      NULL,
      1,
      NULL,
      1.694047,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.861266,
      NULL,
      0,
      1.558738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978302,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516982,
      1,
      NULL,
      1.470966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008555,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      0.945374,
      3,
      3,
      1.943550,
      NULL,
      1.225065,
      0.136990,
      0,
      NULL,
      2,
      1,
      0.451368,
      0.086515,
      0,
      NULL,
      1.364900,
      1,
      0,
      0.896537,
      0.301583,
      1,
      NULL,
      0.975632,
      1.087666,
      0,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      0.957824,
      NULL,
      NULL,
      NULL,
      NULL,
      2.154710,
      1.525217,
      1.348484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385617,
      0.874808,
      NULL,
      0,
      0.211796,
      0,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      57.683660,
      85.212132,
      2,
      1,
      4,
      '00014',
      '11333',
      '21131',
      0.081783,
      '',
      '',
      '',
      1.069218,
      '',
      '',
      '');
commit;
end;
/


