set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      0.074194,
      0,
      4,
      NULL,
      '1242',
      3,
      1.060908,
      NULL,
      NULL,
      ' 3- 8-2002',
      11.288004,
      NULL,
      NULL,
      3,
      0.851431,
      '11- 7-1977',
      30,
      4.822352,
      NULL,
      99,
      0,
      NULL,
      ' 0- 3-1986',
      NULL,
      0,
      2.440864,
      1,
      NULL,
      0,
      0,
      0,
      3.124213,
      NULL,
      NULL,
      NULL,
      3.607343,
      1.752077,
      NULL,
      23.709145,
      1,
      2,
      2,
      NULL,
      6.240645,
      NULL,
      2,
      NULL,
      0,
      0,
      0.072559,
      0,
      6.449327,
      1,
      NULL,
      0.909280,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      3,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      1,
      1,
      3.252544,
      0,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.143851,
      NULL,
      0,
      0.374325,
      NULL,
      3.566424,
      2,
      1,
      0.161113,
      3.025686,
      NULL,
      1.667889,
      0,
      NULL,
      0.259497,
      1.448264,
      5,
      0,
      3,
      NULL,
      1,
      0,
      1.785132,
      0.354792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      3,
      3,
      0,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1.810340,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      4,
      1,
      2,
      1,
      0,
      5,
      NULL,
      3,
      0,
      0,
      3,
      1,
      NULL,
      2,
      '11-29-2001',
      NULL,
      ' 4- 2-1980',
      2.776180,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      NULL,
      3,
      2,
      3,
      3,
      4,
      6,
      1.523581,
      2.477835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      0,
      0.387821,
      4,
      0,
      NULL,
      1.054582,
      NULL,
      7,
      5,
      0.563548,
      2.072536,
      3,
      3,
      NULL,
      2,
      2,
      4.635195,
      0,
      5,
      0.347083,
      3,
      0.261213,
      NULL,
      NULL,
      0.065912,
      2.289559,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1.412118,
      6,
      1,
      0.040867,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      8,
      18.036501,
      155.625887,
      138.341596,
      56.204294,
      66,
      79,
      38,
      1,
      0.754733,
      1,
      1,
      NULL,
      0.403961,
      0,
      NULL,
      16,
      1.725385,
      5,
      0,
      2.626386,
      2.546162,
      3.119537,
      1,
      5.690608,
      3,
      NULL,
      1,
      2,
      NULL,
      5.280225,
      1,
      1.768560,
      NULL,
      2,
      71,
      80.421614,
      4,
      1,
      7,
      '30223',
      '30001',
      '14143',
      1.097265,
      '',
      NULL,
      '',
      1.369043,
      NULL,
      '',
      '',
      1,
      NULL,
      33,
      NULL,
      1,
      NULL,
      0.305785,
      0,
      5,
      0.369475,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071139,
      2,
      2,
      0,
      0,
      3.160831,
      NULL,
      3.291391,
      1,
      1,
      0,
      2.264399,
      1,
      1,
      NULL,
      NULL,
      3,
      0.323551,
      2.792270,
      1.105495,
      NULL,
      NULL,
      3.690986,
      3,
      0.967735,
      2,
      NULL,
      1.412237,
      0,
      9,
      0.288165,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.938076,
      0,
      0.196213,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      3,
      0.573210,
      2,
      0.776727,
      0.934105,
      1.911648,
      3,
      NULL,
      1,
      1.519209,
      NULL,
      3.686674,
      NULL,
      1,
      3,
      0,
      0.885665,
      NULL,
      1.251799,
      0.513547,
      5,
      8,
      5,
      1,
      0.202243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.847700,
      1,
      2,
      1.972911,
      1,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      6.710346,
      7,
      0,
      3.263935,
      NULL,
      0.664308,
      2.467356,
      1,
      NULL,
      3,
      NULL,
      0.755261,
      1.265754,
      NULL,
      NULL,
      1.051317,
      NULL,
      NULL,
      1.155972,
      NULL,
      NULL,
      1.964750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.065636,
      2,
      0,
      NULL,
      NULL,
      5.301118,
      1.584512,
      NULL,
      7.510943,
      7,
      0.983348,
      NULL,
      6.817592,
      NULL,
      0,
      NULL,
      NULL,
      1.787346,
      2.640740,
      1.074387,
      NULL,
      2.437794,
      1.745923,
      NULL,
      0,
      NULL,
      NULL,
      3.831526,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.030654,
      2,
      NULL,
      3.391036,
      2,
      5,
      3.864429,
      NULL,
      0.614876,
      0.787496,
      2.018233,
      2.676382,
      2,
      4,
      NULL,
      NULL,
      1.143213,
      1.336400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.968729,
      NULL,
      NULL,
      1.204489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.241937,
      NULL,
      NULL,
      0.035103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.334628,
      NULL,
      NULL,
      3.155633,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11.025804,
      NULL,
      NULL,
      1,
      1.999512,
      1.452607,
      1.709920,
      1,
      1,
      NULL,
      NULL,
      NULL,
      7,
      5.607462,
      NULL,
      NULL,
      0,
      2.593788,
      NULL,
      NULL,
      2.846679,
      3,
      NULL,
      NULL,
      NULL,
      0.927551,
      NULL,
      NULL,
      0.118208,
      2,
      NULL,
      NULL,
      1.401989,
      0.908180,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3.295881,
      0.904519,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.776362,
      NULL,
      NULL,
      3.497857,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      27,
      1.268302,
      0.653195,
      4,
      NULL,
      0.952672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.327673,
      NULL,
      NULL,
      1.581733,
      NULL,
      NULL,
      0,
      NULL,
      0.532101,
      513.164607,
      6,
      3,
      0.252686,
      NULL,
      0.091980,
      1,
      NULL,
      2,
      0,
      3.372231,
      NULL,
      0,
      0.054763,
      0,
      NULL,
      0.836853,
      1,
      0,
      0,
      0.673830,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.559775,
      NULL,
      28.473049,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.067996,
      NULL,
      1,
      NULL,
      1.204232,
      NULL,
      1.575660,
      NULL,
      0.148697,
      NULL,
      0.450752,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.151676,
      NULL,
      NULL,
      NULL,
      1.731590,
      NULL,
      2.077585,
      NULL,
      0.980003,
      0.508724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524610,
      NULL,
      1.860508,
      NULL,
      NULL,
      NULL,
      1.536178,
      NULL,
      1.001131,
      0.099115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.173578,
      NULL,
      5.230865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.872657,
      2,
      NULL,
      1.964529,
      NULL,
      1.266484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558489,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.507207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608829,
      1.877676,
      2.099973,
      NULL,
      NULL,
      NULL,
      2.886275,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.223836,
      NULL,
      3.386524,
      NULL,
      13.573486,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1.252288,
      1,
      1,
      1,
      0,
      1,
      0.578219,
      0.142083,
      2,
      0,
      1,
      3.183634,
      0.484993,
      0,
      1.397948,
      0,
      1.815985,
      NULL,
      NULL,
      0,
      0.858530,
      3,
      0.449516,
      1,
      NULL,
      NULL,
      NULL,
      0.934418,
      0.172522,
      NULL,
      1.978326,
      0,
      0.229816,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.567107,
      1.812018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.994627,
      NULL,
      1.957272,
      NULL,
      2.629294,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.567268,
      NULL,
      2.900262,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.414837,
      NULL,
      NULL,
      NULL,
      0.493313,
      18,
      0.957933,
      0.245606,
      1,
      NULL,
      0,
      1.572965,
      1,
      1,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      79,
      88.916333,
      0,
      NULL,
      2,
      '01324',
      '23423',
      NULL,
      1.142825,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


