set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2242320',
      1.707287,
      1,
      NULL,
      1,
      '3201',
      NULL,
      0.995503,
      NULL,
      NULL,
      ' 8-11-1976',
      27,
      NULL,
      0,
      0,
      1.600708,
      ' 4-29-1989',
      NULL,
      NULL,
      161,
      NULL,
      2,
      '11- 7-1989',
      ' 6- 2-2000',
      ' 0-15-1992',
      0.611188,
      NULL,
      1.641946,
      0,
      0,
      2,
      8,
      3.408609,
      NULL,
      NULL,
      NULL,
      12.515523,
      1.244112,
      24.088867,
      20,
      1,
      33.500844,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      0.832979,
      NULL,
      NULL,
      0,
      NULL,
      1.868113,
      1.610794,
      NULL,
      1,
      0,
      2,
      1,
      2,
      0.255167,
      0.701856,
      0.822126,
      1,
      0,
      NULL,
      1.025528,
      1,
      0,
      0.528360,
      0.755486,
      NULL,
      NULL,
      0.005547,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.692914,
      1,
      0,
      1,
      0,
      1,
      0,
      2,
      1,
      1,
      1,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      2.143585,
      ' 4- 9-2001',
      55,
      ' 2- 5-1976',
      NULL,
      0,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.095850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      24,
      3.106267,
      1.221525,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.078745,
      1,
      1.969901,
      0.062025,
      1,
      2,
      0.887557,
      5.120418,
      0.461264,
      7.620345,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.398053,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420074,
      0.910125,
      0,
      0,
      1,
      1.844489,
      0.069016,
      2.292948,
      13.597664,
      1.226962,
      1.694763,
      NULL,
      NULL,
      NULL,
      2,
      1.641884,
      2,
      3,
      0,
      0,
      2,
      NULL,
      3,
      2,
      3,
      NULL,
      1,
      0.218694,
      0.404813,
      2,
      2.520055,
      1,
      1.473834,
      NULL,
      0,
      NULL,
      0.990200,
      0.521449,
      1.747983,
      1,
      1.168198,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      3.464078,
      NULL,
      9,
      5.311567,
      2.966851,
      NULL,
      1,
      1.205524,
      0.331392,
      3.516094,
      0,
      30.154199,
      NULL,
      2,
      NULL,
      11,
      NULL,
      49.166069,
      2,
      NULL,
      0,
      '22200',
      '',
      '',
      2.677299,
      '34331',
      '',
      '',
      0.722592,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3.502070,
      0.224506,
      0.927702,
      1.889766,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.793113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.518130,
      NULL,
      1,
      1,
      3.572455,
      1.866508,
      3,
      1.646053,
      0,
      1,
      1.637585,
      1,
      NULL,
      0.360436,
      NULL,
      1.857425,
      1,
      1.075770,
      1,
      0.143963,
      0,
      1.349405,
      NULL,
      NULL,
      1.486703,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.596324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254023,
      0,
      1.955700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.648318,
      NULL,
      NULL,
      NULL,
      0.160916,
      NULL,
      NULL,
      NULL,
      1.353361,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.940687,
      NULL,
      NULL,
      NULL,
      0.480323,
      NULL,
      1,
      NULL,
      1.970311,
      0.190182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.187074,
      NULL,
      1,
      0,
      0.018172,
      2,
      1,
      1.870843,
      0,
      1,
      1.630571,
      NULL,
      0,
      1.166674,
      0,
      0.560655,
      1.915621,
      NULL,
      0,
      NULL,
      0,
      0.489253,
      1.147170,
      0,
      1,
      1.385253,
      1.948302,
      NULL,
      0.057586,
      NULL,
      NULL,
      0,
      0,
      1.226088,
      0,
      0,
      0,
      NULL,
      0.725869,
      0,
      1.934225,
      2.581847,
      1.046905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.435441,
      0.534955,
      NULL,
      2,
      3.289371,
      1.643021,
      0,
      0.608048,
      NULL,
      1,
      2.272205,
      NULL,
      2.228081,
      3.620812,
      2.668754,
      0.557234,
      0,
      1.000688,
      0,
      0.566510,
      0.663737,
      0,
      0.939872,
      0.341903,
      2,
      0.272568,
      1.047382,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      0.446963,
      0.624781,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      111,
      121,
      4,
      0,
      NULL,
      '11404',
      '',
      '',
      0,
      '21102',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


