set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5905417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0211220',
      0.944144,
      0,
      2,
      1,
      NULL,
      0.052841,
      3.369512,
      5,
      NULL,
      '10-25-1998',
      51.327322,
      NULL,
      3,
      3.047828,
      1.544267,
      ' 8- 8-1985',
      40.719133,
      2.358447,
      72,
      34,
      1,
      NULL,
      NULL,
      ' 7-16-1982',
      3,
      1,
      0,
      0,
      1.286852,
      2.664229,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      2,
      0,
      14.452306,
      NULL,
      2.545030,
      5,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      0.770766,
      0.195483,
      1.476396,
      0,
      2,
      3,
      3,
      0.113089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252228,
      NULL,
      3,
      3,
      0,
      0,
      2,
      3,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2.630652,
      0.448200,
      1.142112,
      NULL,
      1,
      NULL,
      5,
      0,
      0.049523,
      1.348492,
      1.697823,
      NULL,
      3,
      0.710341,
      0,
      1,
      4,
      3,
      NULL,
      7,
      1,
      4,
      NULL,
      0.879319,
      0.775632,
      3.620802,
      0.926386,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.060976,
      16.514810,
      98.494550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933518,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035391,
      NULL,
      NULL,
      0.246887,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.599668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.723337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.487338,
      NULL,
      NULL,
      0.903420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.730468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700136,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561061,
      NULL,
      NULL,
      0.321442,
      NULL,
      NULL,
      0.055905,
      NULL,
      NULL,
      0.650006,
      NULL,
      NULL,
      1.126167,
      1.439592,
      1,
      1,
      0,
      1.696386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.422562,
      NULL,
      3,
      0.114487,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.415917,
      NULL,
      NULL,
      NULL,
      0.603241,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      2.509160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.126534,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.195519,
      NULL,
      NULL,
      NULL,
      0.711659,
      NULL,
      2.594142,
      5.358601,
      NULL,
      2,
      0.276134,
      NULL,
      NULL,
      2.674687,
      632,
      1732.938638,
      0,
      NULL,
      NULL,
      0.154542,
      NULL,
      NULL,
      3,
      1929.291624,
      NULL,
      1.010302,
      NULL,
      NULL,
      1,
      NULL,
      0.125802,
      19754,
      1968.083335,
      NULL,
      NULL,
      1,
      0.315657,
      1,
      1,
      NULL,
      1,
      2,
      0.374227,
      3.199681,
      1.864782,
      1.720260,
      1,
      NULL,
      1.788125,
      2,
      0.642431,
      0,
      NULL,
      2,
      NULL,
      1.178506,
      NULL,
      0.688169,
      NULL,
      0,
      NULL,
      8.776855,
      NULL,
      1.315518,
      NULL,
      11.888904,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.047503,
      NULL,
      1.987637,
      NULL,
      2,
      NULL,
      3.598102,
      NULL,
      1.605720,
      NULL,
      1.016668,
      NULL,
      1.730054,
      NULL,
      1.081076,
      NULL,
      0,
      NULL,
      1.833888,
      NULL,
      0,
      NULL,
      2,
      1.626195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830273,
      NULL,
      NULL,
      0.001467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049928,
      NULL,
      0.371854,
      NULL,
      0.424334,
      NULL,
      1.263688,
      1.539566,
      NULL,
      NULL,
      1.714983,
      NULL,
      2.196782,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.468923,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      1.407198,
      NULL,
      NULL,
      NULL,
      0,
      1.839746,
      2,
      NULL,
      1.902075,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.826777,
      NULL,
      1.106480,
      NULL,
      1,
      1,
      NULL,
      11,
      38.605616,
      3,
      2.780521,
      2.672521,
      3,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      2.079567,
      3,
      2,
      1.979268,
      0,
      NULL,
      1,
      0,
      1,
      0.995068,
      0.190629,
      0.108683,
      0,
      1.633719,
      1.359861,
      3,
      17,
      7,
      NULL,
      NULL,
      0.545996,
      0.141152,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.651661,
      1.912092,
      0.205129,
      NULL,
      0.419864,
      0,
      1.591164,
      0.687433,
      1.439435,
      NULL,
      0.879913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596713,
      0.583086,
      0,
      0,
      NULL,
      NULL,
      3,
      5,
      5,
      1.375281,
      NULL,
      NULL,
      72,
      NULL,
      NULL,
      0,
      3.360297,
      '41412',
      '04344',
      '41202',
      1,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


