set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1130132',
      1.600831,
      1.738440,
      3,
      NULL,
      '3443',
      2.628412,
      1.720822,
      NULL,
      NULL,
      ' 7- 8-1982',
      28,
      NULL,
      NULL,
      NULL,
      2,
      ' 0-29-1976',
      2.601904,
      1,
      NULL,
      86.226333,
      1,
      ' 1-20-1975',
      NULL,
      ' 3- 1-1979',
      2,
      0,
      0,
      0.557905,
      0.399228,
      3.784670,
      2,
      1.181704,
      NULL,
      NULL,
      NULL,
      1.031390,
      6.386600,
      9,
      1.247156,
      1,
      30.129393,
      1,
      0,
      NULL,
      1.253535,
      2,
      1,
      NULL,
      0,
      1.348226,
      0.675023,
      1.933024,
      0,
      1,
      1,
      0,
      2,
      2,
      1.754515,
      2,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      4.902967,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.707787,
      2,
      1.561304,
      0,
      0.219971,
      1,
      0.403456,
      2,
      3,
      1.560985,
      1,
      0.609634,
      1.413171,
      0,
      2,
      2.977833,
      3,
      2,
      3,
      2,
      0,
      1,
      0,
      3.758760,
      1,
      NULL,
      NULL,
      0.820018,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      5,
      0,
      5,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      NULL,
      3,
      0,
      1,
      1,
      5,
      2,
      4,
      0,
      3,
      4,
      4,
      NULL,
      3,
      4,
      2,
      2,
      1,
      1,
      4,
      NULL,
      0,
      ' 1- 4-1994',
      NULL,
      NULL,
      65,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      3.542188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.818279,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      0,
      1.127197,
      3,
      1.568088,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1.431049,
      NULL,
      NULL,
      3,
      3,
      1.949385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.148756,
      NULL,
      0.623400,
      1.850145,
      0.810373,
      0.750830,
      1.639709,
      1.524369,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.754928,
      1.591703,
      1,
      2,
      1,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      1.819932,
      NULL,
      0,
      NULL,
      1.633781,
      NULL,
      0,
      1,
      0,
      0.389657,
      4,
      9,
      4,
      5.321614,
      NULL,
      4,
      NULL,
      0.262869,
      5,
      3,
      3,
      NULL,
      24.935164,
      2,
      0.783912,
      NULL,
      3,
      10,
      84.691098,
      1,
      0,
      0,
      '11031',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.415027,
      '',
      '',
      '',
      NULL,
      7,
      34.387103,
      40,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163804,
      NULL,
      NULL,
      0.563863,
      NULL,
      NULL,
      0.374716,
      NULL,
      NULL,
      1.551813,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      1.417569,
      0,
      0,
      NULL,
      NULL,
      0.353211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6,
      7.850161,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224814,
      1.055624,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.577369,
      1,
      0,
      3.442491,
      1.740989,
      NULL,
      0,
      0.634249,
      0.039882,
      1.206399,
      0,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.197413,
      0,
      1,
      1,
      1.502868,
      NULL,
      NULL,
      NULL,
      1.653024,
      NULL,
      NULL,
      NULL,
      0.342433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453881,
      NULL,
      NULL,
      0.475163,
      NULL,
      NULL,
      1.145612,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012908,
      NULL,
      NULL,
      0.451860,
      NULL,
      NULL,
      0.957061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307912,
      NULL,
      NULL,
      1.598904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094782,
      NULL,
      NULL,
      4.319369,
      2.000904,
      NULL,
      1.740473,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725044,
      0,
      NULL,
      NULL,
      1.733396,
      3,
      0.343383,
      NULL,
      1.383631,
      3,
      2,
      NULL,
      3.132216,
      0,
      NULL,
      2.883274,
      NULL,
      0,
      2.782901,
      NULL,
      NULL,
      2,
      3,
      6,
      6.463227,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.057800,
      0.144135,
      0.883811,
      0.878625,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095919,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.840719,
      NULL,
      NULL,
      1.369323,
      NULL,
      NULL,
      0.767601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754373,
      NULL,
      NULL,
      0.768223,
      0.322690,
      0,
      0.869324,
      0.501998,
      1,
      NULL,
      NULL,
      NULL,
      1.149970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394763,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.229939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.033229,
      NULL,
      NULL,
      NULL,
      3.134098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.880135,
      NULL,
      NULL,
      NULL,
      1.524401,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.779342,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      32.191920,
      0.872585,
      0.005505,
      0,
      0,
      1,
      1,
      1.262772,
      NULL,
      0,
      0.301694,
      1.752800,
      NULL,
      NULL,
      0.514000,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      4,
      0,
      NULL,
      0.889179,
      3,
      5,
      2,
      3,
      1.415114,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.404626,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.611164,
      NULL,
      2,
      0,
      NULL,
      1,
      0.264818,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.601326,
      1,
      NULL,
      1.106447,
      1.493717,
      1.488534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726040,
      NULL,
      0.506469,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1,
      NULL,
      NULL,
      72.009457,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


