set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      2,
      '11',
      '11',
      50.609013,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      '1301',
      NULL,
      0.540429,
      NULL,
      NULL,
      '10-24-1996',
      8.233545,
      10.263526,
      NULL,
      1,
      3.697920,
      ' 0- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-25-1996',
      ' 7- 1-2002',
      ' 6-22-1996',
      3,
      NULL,
      0,
      0.417233,
      0,
      1.727358,
      NULL,
      0,
      NULL,
      NULL,
      3,
      10,
      7.904832,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.618573,
      0,
      0,
      1,
      0,
      0,
      0.326773,
      NULL,
      NULL,
      0.803755,
      0,
      NULL,
      4,
      0,
      NULL,
      5,
      0,
      0,
      0,
      1,
      1,
      2,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.923985,
      NULL,
      1,
      0,
      3,
      3.813925,
      1,
      NULL,
      2,
      0,
      0.575012,
      1.855208,
      1.890189,
      NULL,
      NULL,
      1,
      1,
      11.699898,
      0,
      NULL,
      2,
      0.369959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      5,
      4,
      3,
      2,
      2,
      0,
      0,
      3,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1.537692,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      0,
      4,
      2,
      1,
      5,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      5,
      4,
      0,
      3,
      1,
      4,
      1,
      1,
      5,
      5,
      7,
      2.000268,
      ' 9- 2-1999',
      380,
      ' 0-23-2002',
      94.127649,
      1.250855,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      0.995772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.850742,
      3.177387,
      3,
      1,
      0.599138,
      0.627437,
      1.965442,
      3.837455,
      5.110534,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      5,
      0,
      7.373543,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.232938,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1.104234,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.487356,
      3,
      1,
      1,
      1,
      2,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      2.377723,
      0,
      1.308280,
      NULL,
      0,
      0.970447,
      1,
      0.343962,
      1.572266,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1.351453,
      5,
      NULL,
      4,
      2.917025,
      NULL,
      5,
      1.331229,
      4,
      2.467567,
      2,
      NULL,
      0,
      NULL,
      0.351761,
      48,
      1,
      3.305092,
      14,
      NULL,
      42,
      74.141151,
      3,
      0.217734,
      NULL,
      '10130',
      '',
      NULL,
      1.120792,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      40.584561,
      NULL,
      1.466181,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.047939,
      2.100371,
      1.654002,
      NULL,
      NULL,
      0.352309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.370378,
      1,
      NULL,
      NULL,
      1.660913,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434569,
      NULL,
      NULL,
      1.905598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      3.268105,
      0.819455,
      2.024360,
      0.921842,
      NULL,
      1,
      NULL,
      0.556841,
      3,
      1.416007,
      0,
      0.641524,
      NULL,
      0,
      0,
      0.855547,
      2,
      3.480048,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.713424,
      2.954787,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489343,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.644388,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      7,
      5,
      NULL,
      1.552532,
      NULL,
      NULL,
      1.244050,
      NULL,
      NULL,
      0.428960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503953,
      NULL,
      NULL,
      2.643486,
      2,
      1.958601,
      1.471045,
      NULL,
      NULL,
      3,
      4.207265,
      2,
      NULL,
      3,
      3,
      0.366995,
      NULL,
      NULL,
      3.531627,
      NULL,
      0,
      1,
      3.399106,
      1,
      0,
      NULL,
      3.091329,
      6,
      6,
      NULL,
      NULL,
      NULL,
      2,
      2.748534,
      3,
      0,
      1.999048,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.731327,
      3.083371,
      0,
      1,
      1.454899,
      1.276113,
      0,
      2,
      0.405550,
      1.341862,
      NULL,
      1.869182,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.521621,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.505854,
      NULL,
      NULL,
      0.492167,
      1.263213,
      0,
      NULL,
      1.379556,
      1.799738,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028673,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.352681,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.039811,
      1.049783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.508035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969216,
      NULL,
      NULL,
      0.196612,
      NULL,
      0,
      221.333407,
      0,
      0.686549,
      0.774899,
      1,
      1,
      0,
      0,
      1.711705,
      1,
      0,
      0.404358,
      1.354107,
      1,
      NULL,
      1.311378,
      0,
      0.335456,
      1,
      1.376936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      9,
      4.808363,
      0,
      5.377048,
      0,
      2,
      3,
      0.995455,
      1,
      1,
      1.357671,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.839722,
      NULL,
      NULL,
      1.613913,
      NULL,
      0.506843,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.563807,
      NULL,
      1.808815,
      NULL,
      NULL,
      1.704203,
      1.814464,
      NULL,
      1,
      3.193565,
      NULL,
      NULL,
      1.944424,
      NULL,
      2,
      1,
      1.350089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.886282,
      NULL,
      1,
      1,
      NULL,
      3,
      1,
      0,
      7.100454,
      30,
      3,
      3.105474,
      1,
      '23330',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.394283,
      NULL,
      NULL,
      '');
commit;
end;
/


