set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8200571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.370590,
      1,
      2.510451,
      2.079090,
      2.566626,
      2,
      NULL,
      1.628408,
      NULL,
      '30200432',
      65.725399,
      73,
      NULL,
      3,
      NULL,
      0,
      0,
      '2224',
      4,
      1.884323,
      NULL,
      NULL,
      ' 8- 0-1974',
      200.517023,
      62.622926,
      NULL,
      NULL,
      2.098409,
      ' 5- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-19-2000',
      ' 1-26-1977',
      '11-10-2002',
      0.009956,
      2.420152,
      NULL,
      NULL,
      0.277335,
      NULL,
      4,
      0.223508,
      0.777018,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.884445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      5,
      0,
      NULL,
      4,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      1,
      2,
      NULL,
      2,
      NULL,
      0,
      0.850427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.248517,
      1,
      NULL,
      NULL,
      0.174934,
      NULL,
      NULL,
      3,
      2,
      3,
      0,
      0,
      4,
      3,
      1,
      NULL,
      0,
      4,
      5,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.583870,
      NULL,
      1.602384,
      1,
      5,
      1,
      NULL,
      5,
      1,
      3,
      1,
      1,
      4,
      3,
      0,
      1,
      0,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      ' 6-16-1998',
      NULL,
      ' 0-21-2003',
      0,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      3,
      0,
      0,
      2.307916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.986519,
      2.573488,
      NULL,
      NULL,
      3.256035,
      0.561179,
      1.996362,
      0,
      5,
      0.801368,
      1.337761,
      1,
      NULL,
      NULL,
      NULL,
      0.825619,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1.585082,
      3.380379,
      0,
      1.423819,
      NULL,
      23.320216,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.259156,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      2,
      2,
      3,
      0,
      1,
      2.568150,
      1.394728,
      NULL,
      9,
      0,
      0.445348,
      0,
      NULL,
      NULL,
      3.441599,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      0.628026,
      0,
      1.362255,
      NULL,
      9.107818,
      0,
      NULL,
      0,
      2.629003,
      NULL,
      3,
      1.693276,
      1,
      3,
      NULL,
      10.462760,
      3,
      2.878935,
      54,
      NULL,
      21,
      NULL,
      1,
      0,
      NULL,
      NULL,
      '',
      NULL,
      1.941715,
      '',
      NULL,
      '',
      1.969293,
      '',
      '',
      '',
      2,
      33.685104,
      203,
      NULL,
      3.141144,
      2.242382,
      5,
      3.264645,
      5,
      3.595643,
      2.258806,
      NULL,
      0.828363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.368396,
      0,
      2,
      0.761847,
      NULL,
      NULL,
      0.983953,
      NULL,
      NULL,
      0.254147,
      NULL,
      1,
      0.504458,
      NULL,
      NULL,
      NULL,
      0,
      1.296228,
      0,
      NULL,
      NULL,
      0.066842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.748810,
      0.472535,
      5.805756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.453595,
      NULL,
      3.915423,
      2,
      3.045276,
      1.604688,
      0.539798,
      NULL,
      1,
      2,
      NULL,
      0,
      3.531648,
      0,
      NULL,
      0,
      NULL,
      1.332398,
      1,
      0.171687,
      NULL,
      0.083719,
      1.792807,
      0,
      1.635242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.923685,
      1,
      5,
      0,
      NULL,
      0,
      1.469120,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.163160,
      NULL,
      NULL,
      0.667323,
      1,
      0,
      0,
      0.011633,
      1,
      3,
      0,
      0.673523,
      8.504786,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.534207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261567,
      NULL,
      NULL,
      0.338796,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.311946,
      1.583370,
      4,
      0,
      1,
      NULL,
      NULL,
      0.871538,
      3.124302,
      NULL,
      0,
      2.957166,
      NULL,
      NULL,
      0.600141,
      1.976465,
      1,
      NULL,
      1.352072,
      3.079648,
      4.751107,
      0.112309,
      7,
      0.980428,
      0.069157,
      3.222033,
      NULL,
      1,
      0,
      1.731902,
      0,
      1,
      2.285884,
      1.839414,
      2,
      6.454868,
      0.981270,
      3.716214,
      NULL,
      1.726124,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.276119,
      NULL,
      1.941434,
      1,
      NULL,
      NULL,
      1.896424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.067669,
      NULL,
      NULL,
      3.583632,
      0.534322,
      1,
      1.333499,
      0.952111,
      3,
      1.333509,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.031418,
      NULL,
      NULL,
      NULL,
      0.045688,
      NULL,
      NULL,
      NULL,
      1.954835,
      NULL,
      NULL,
      NULL,
      1.337317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.243925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.938932,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6.089322,
      1.546225,
      1,
      8.292575,
      3.606194,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012884,
      1.206093,
      NULL,
      0,
      NULL,
      NULL,
      1.640461,
      NULL,
      1,
      396,
      8.265373,
      1.326467,
      NULL,
      1,
      0,
      NULL,
      1,
      1.107840,
      1,
      1,
      1.630964,
      1.222795,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1.064933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305209,
      0.167369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824285,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.794054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.669294,
      NULL,
      NULL,
      0,
      0,
      0.402711,
      0,
      1,
      0.029061,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.980685,
      1,
      0,
      3.034326,
      3,
      3,
      1.139191,
      0.316245,
      1.210165,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.178759,
      2.304037,
      NULL,
      0.908127,
      NULL,
      NULL,
      1,
      1.975515,
      NULL,
      0,
      3.397467,
      NULL,
      1.771904,
      0.528673,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.541107,
      NULL,
      1.487274,
      0.830357,
      NULL,
      0.492789,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128054,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.990732,
      NULL,
      NULL,
      46.848591,
      74,
      2,
      NULL,
      NULL,
      '10102',
      '',
      '',
      0.458610,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


