set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9608507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.511743,
      NULL,
      1.723883,
      0.908983,
      NULL,
      1.000986,
      3,
      NULL,
      '430',
      '03013230',
      31.493149,
      26,
      NULL,
      4.528404,
      0,
      NULL,
      NULL,
      '4441',
      2.425809,
      1,
      NULL,
      NULL,
      ' 8-11-1992',
      88.115857,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-2001',
      NULL,
      ' 5- 8-1981',
      0.289191,
      3.855951,
      0.278660,
      NULL,
      0,
      2,
      2,
      0.227537,
      1,
      3.599351,
      8,
      NULL,
      3.501213,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      2.833737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      NULL,
      0,
      1,
      0,
      2,
      3,
      1,
      1,
      4,
      NULL,
      NULL,
      0,
      0,
      2.060799,
      0,
      NULL,
      2,
      2,
      0.762671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.591616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      2,
      0,
      0,
      2,
      0,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      4,
      3,
      4,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      3,
      0.440193,
      2.303583,
      NULL,
      NULL,
      ' 4-13-1978',
      121,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.009299,
      NULL,
      NULL,
      0.067517,
      1.328033,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.366916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936397,
      0.792264,
      0,
      0.245203,
      1,
      0,
      0,
      2,
      NULL,
      2,
      1.602347,
      NULL,
      NULL,
      NULL,
      0,
      0.929462,
      1,
      1,
      2,
      3,
      NULL,
      3,
      3,
      1,
      2,
      NULL,
      3,
      1.631861,
      0.386528,
      2,
      0.865039,
      0,
      1.353636,
      0.378275,
      1.585194,
      0.044610,
      1.306280,
      NULL,
      NULL,
      0,
      1.398830,
      NULL,
      NULL,
      0,
      2.273720,
      1.197740,
      11.800043,
      8.999538,
      0.779255,
      4.935151,
      10,
      NULL,
      3.221424,
      3.418439,
      6,
      2,
      NULL,
      2.983390,
      23.943697,
      1,
      0,
      NULL,
      NULL,
      13,
      24.560852,
      0,
      5,
      3.990921,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.042141,
      34,
      68.680069,
      7.470068,
      2,
      15.737132,
      4,
      NULL,
      5,
      2,
      3.749642,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.630178,
      2.518066,
      3,
      1,
      2.354194,
      0,
      0,
      NULL,
      NULL,
      2,
      2,
      0.740022,
      1.577394,
      0.283617,
      0.868997,
      NULL,
      0,
      0.758461,
      NULL,
      0,
      1.427874,
      0,
      2.281293,
      1,
      1,
      NULL,
      NULL,
      5.333675,
      10.606398,
      NULL,
      NULL,
      1.181915,
      NULL,
      NULL,
      NULL,
      0.212194,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0.050488,
      1.909299,
      3.838275,
      1,
      0.941814,
      1,
      3.212132,
      NULL,
      2.688942,
      NULL,
      NULL,
      NULL,
      3.847864,
      2.703734,
      0,
      0.513672,
      0,
      0.393598,
      0,
      NULL,
      3.015881,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1.682751,
      5,
      2.260942,
      6.033349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.722356,
      NULL,
      NULL,
      NULL,
      1.258666,
      1,
      NULL,
      0,
      3.751008,
      NULL,
      1,
      1,
      9,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.815942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.168720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.082890,
      3.559049,
      0.597023,
      NULL,
      NULL,
      1,
      1.717766,
      2.636772,
      0.263911,
      2.177004,
      1,
      1.646707,
      0,
      3,
      4.318664,
      4,
      3,
      NULL,
      1,
      1,
      3.081950,
      0.835011,
      NULL,
      0.734132,
      3,
      0,
      0.108367,
      2.600739,
      NULL,
      NULL,
      2,
      3,
      1.152324,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1.577827,
      2.459449,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.210375,
      NULL,
      NULL,
      1.226408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.131936,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.441815,
      0.357080,
      0.871143,
      0.170795,
      0.652329,
      1.021926,
      NULL,
      NULL,
      5.754613,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383338,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.088192,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651789,
      NULL,
      NULL,
      NULL,
      0.391149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266213,
      NULL,
      NULL,
      NULL,
      NULL,
      52.520003,
      46,
      NULL,
      2.864710,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.374847,
      NULL,
      NULL,
      1.765979,
      NULL,
      NULL,
      0.767689,
      NULL,
      1.541171,
      NULL,
      4.547990,
      0,
      2,
      1,
      0,
      1.665242,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.161108,
      1.837094,
      0.214195,
      1.745634,
      NULL,
      0,
      3,
      NULL,
      1.743202,
      NULL,
      1.962050,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.812070,
      NULL,
      0,
      NULL,
      3.562833,
      24,
      40.812135,
      2.485267,
      1,
      NULL,
      NULL,
      0.072540,
      NULL,
      NULL,
      NULL,
      3.182818,
      NULL,
      2.551492,
      NULL,
      NULL,
      NULL,
      1.864857,
      NULL,
      0.429274,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.426255,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.302839,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368607,
      0.127880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.044265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495867,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.763981,
      1.766839,
      NULL,
      3.187168,
      NULL,
      1,
      NULL,
      298,
      NULL,
      2.314085,
      NULL,
      0.251361,
      NULL,
      0.350704,
      1.830403,
      2.104500,
      11.864710,
      37.139824,
      2.588404,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.272322,
      0,
      1.349978,
      3.955543,
      2,
      0,
      0.041588,
      NULL,
      NULL,
      NULL,
      3.307137,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.224609,
      NULL,
      1,
      NULL,
      NULL,
      1.469491,
      1.627208,
      NULL,
      0,
      0.022523,
      NULL,
      0.126500,
      1,
      NULL,
      0.587741,
      1,
      NULL,
      3,
      0.130764,
      0.144525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595680,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      26.756302,
      26,
      NULL,
      1.602740,
      1,
      '41340',
      '40322',
      '40043',
      NULL,
      '',
      '',
      '',
      0.316979,
      '',
      NULL,
      '');
commit;
end;
/


