set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9308280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3104113',
      NULL,
      0.737549,
      0,
      0,
      NULL,
      0.267725,
      0,
      NULL,
      NULL,
      ' 2-22-1985',
      21.792842,
      NULL,
      NULL,
      2.962422,
      1.225374,
      ' 4-14-1994',
      NULL,
      2,
      NULL,
      118.943727,
      1,
      '10-21-1995',
      NULL,
      ' 3-10-1986',
      3.548185,
      NULL,
      NULL,
      3.567105,
      0,
      1.759071,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.555051,
      16.018775,
      NULL,
      5,
      21,
      3,
      NULL,
      4.372125,
      0,
      0,
      3,
      0.917227,
      2.697266,
      1,
      0.223010,
      1,
      0,
      1.715542,
      0.454009,
      3,
      1,
      1,
      0,
      3,
      0,
      1,
      NULL,
      4,
      0,
      2,
      NULL,
      2,
      3,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1.257423,
      NULL,
      NULL,
      1.694503,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.877137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      5,
      5,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      3,
      0,
      0,
      1,
      1,
      0.172077,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      0,
      3,
      4,
      1,
      3,
      4,
      0,
      NULL,
      2,
      2,
      4,
      4,
      2,
      0,
      NULL,
      1,
      1,
      5,
      NULL,
      5,
      NULL,
      NULL,
      3,
      ' 0-12-1998',
      NULL,
      ' 7-22-2002',
      30.396465,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1.499819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.888031,
      1,
      0.898433,
      NULL,
      0.724923,
      NULL,
      NULL,
      NULL,
      1,
      0.310841,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107518,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      3.888520,
      NULL,
      1.121319,
      NULL,
      NULL,
      NULL,
      0,
      0.103752,
      1,
      0,
      1,
      2,
      2,
      2,
      NULL,
      2,
      3,
      0,
      2,
      2.894297,
      17,
      5,
      3.812359,
      3.153650,
      0,
      NULL,
      0,
      0.307357,
      2.314777,
      NULL,
      0,
      1,
      NULL,
      0.496888,
      0,
      1,
      2.866599,
      1.742506,
      0,
      3.274279,
      6,
      0,
      7,
      7,
      0.058728,
      NULL,
      0,
      NULL,
      NULL,
      2.210280,
      NULL,
      0,
      2.803438,
      NULL,
      1,
      2,
      4.970218,
      NULL,
      0,
      1,
      '10344',
      '',
      '',
      0,
      '',
      '',
      '',
      1.870540,
      '',
      '',
      '',
      0,
      15,
      82.857307,
      14.090630,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.416671,
      NULL,
      1.908091,
      NULL,
      NULL,
      1,
      1.918501,
      1,
      0.880000,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      3,
      0.963931,
      0,
      1,
      NULL,
      2,
      0.866140,
      0.524155,
      NULL,
      NULL,
      1,
      0.774429,
      NULL,
      NULL,
      0.729763,
      2,
      1,
      9,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.207531,
      NULL,
      NULL,
      NULL,
      1.169499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061976,
      NULL,
      NULL,
      0.572048,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.867971,
      1.228478,
      0,
      11.789784,
      2.072295,
      2,
      0.509647,
      NULL,
      NULL,
      0.353804,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.187533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.366179,
      2,
      0.090715,
      4.203719,
      0,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      3,
      2.688296,
      3.357927,
      2,
      NULL,
      0,
      0.598434,
      3.911621,
      0,
      1,
      0,
      0.850928,
      3.080029,
      1,
      0.149769,
      1.281036,
      0,
      NULL,
      0,
      9,
      1,
      7.761866,
      8.830227,
      NULL,
      3,
      1,
      2,
      3,
      0,
      0,
      0,
      1.543868,
      0.691854,
      1.647799,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631092,
      NULL,
      NULL,
      0.085492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.831828,
      NULL,
      NULL,
      0.435263,
      NULL,
      NULL,
      1.095115,
      NULL,
      NULL,
      2.903107,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0.736757,
      NULL,
      NULL,
      1.967402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.775818,
      NULL,
      NULL,
      NULL,
      3.873240,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.234022,
      NULL,
      NULL,
      NULL,
      2.867486,
      10.048577,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.936260,
      NULL,
      0,
      94,
      0,
      0,
      0.946679,
      0,
      NULL,
      NULL,
      1,
      1.144741,
      1.148431,
      1,
      0,
      0.732504,
      NULL,
      1,
      1.178894,
      0.658755,
      0,
      1,
      1.554130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1.312276,
      2,
      1.389304,
      2.798348,
      2,
      8,
      2.423258,
      3.103415,
      0,
      1.193976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0.723061,
      NULL,
      1.297347,
      NULL,
      NULL,
      0.122645,
      2,
      NULL,
      0.447468,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.103706,
      1,
      NULL,
      0.679434,
      2.919677,
      NULL,
      0,
      NULL,
      NULL,
      3.854395,
      1.627947,
      1.250959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      5,
      1.824437,
      NULL,
      NULL,
      65,
      34,
      3,
      0.966319,
      0.361265,
      '03133',
      '',
      '',
      0.514960,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


