set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      '1312',
      0,
      1.006536,
      NULL,
      NULL,
      ' 2-28-2003',
      23.288498,
      NULL,
      4,
      3.643417,
      0,
      ' 8-22-1974',
      43.818333,
      1.087970,
      215,
      111,
      NULL,
      NULL,
      ' 6-19-2000',
      ' 8- 8-1998',
      2.192591,
      0.769101,
      2.649024,
      2.881757,
      0,
      0,
      7,
      0.681889,
      NULL,
      NULL,
      NULL,
      0,
      4.827531,
      NULL,
      NULL,
      4,
      9.411309,
      NULL,
      0,
      0,
      1.147533,
      NULL,
      NULL,
      3.094267,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.915652,
      0,
      2,
      2,
      0.916505,
      5,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      4.618630,
      0,
      0,
      2,
      0,
      1.096548,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      2.318592,
      2,
      1,
      0.023496,
      1,
      NULL,
      0,
      2.510537,
      0,
      NULL,
      NULL,
      1,
      1.790240,
      1.614965,
      0.359411,
      3,
      1.340116,
      2,
      3,
      NULL,
      NULL,
      0,
      0,
      2.448824,
      1,
      NULL,
      NULL,
      0.389058,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      4,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5,
      3,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      4,
      3,
      5,
      5,
      1,
      3,
      NULL,
      NULL,
      1,
      2,
      0,
      4,
      4,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      5,
      2,
      6,
      1,
      ' 1- 8-1995',
      44,
      ' 1-16-1990',
      188,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1.255162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394725,
      1.267633,
      0.424126,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083951,
      1,
      4,
      1.419991,
      1.637946,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.362163,
      0,
      1,
      1.587816,
      0,
      1.809073,
      3.581856,
      38,
      0,
      1.928375,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      3,
      3,
      2,
      3,
      NULL,
      2,
      1,
      1,
      0,
      2,
      2.599501,
      3.460235,
      0.704222,
      0.712431,
      2.582823,
      0,
      1.226934,
      NULL,
      1.236628,
      0.144022,
      1.387162,
      1.585748,
      1,
      3,
      1.327435,
      3.095714,
      1,
      11.507705,
      4.969442,
      5.534622,
      NULL,
      3.321790,
      NULL,
      0,
      0,
      7,
      2.359298,
      0,
      1.400473,
      3.610227,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      3,
      0,
      2.444265,
      '32342',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      25.605724,
      NULL,
      0.894126,
      1.621376,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.448588,
      2.100261,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.574399,
      3,
      3.280085,
      1,
      NULL,
      NULL,
      NULL,
      1.542572,
      1.177803,
      0.661053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.591964,
      1.951003,
      0,
      NULL,
      NULL,
      0.688228,
      9.420059,
      0,
      1,
      0.808912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      2,
      0.966716,
      3.864585,
      2.716689,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.016090,
      NULL,
      2.469369,
      3.420489,
      0.258491,
      1.834016,
      1,
      3,
      1.059009,
      1,
      3,
      2,
      2,
      0.624373,
      1,
      3,
      1.181819,
      NULL,
      1,
      NULL,
      0,
      7.938762,
      1.794857,
      2,
      1,
      1.967034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0.764505,
      NULL,
      NULL,
      1,
      NULL,
      0.885225,
      0.483086,
      NULL,
      NULL,
      1.346592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506103,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.691589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898841,
      NULL,
      NULL,
      2,
      5,
      2,
      1.213666,
      NULL,
      NULL,
      3,
      NULL,
      1.830680,
      NULL,
      2.791871,
      2.039613,
      2.250791,
      0.398648,
      0.097044,
      6,
      4.072075,
      NULL,
      NULL,
      0,
      2,
      2.646453,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      5,
      0,
      4,
      2.890009,
      5,
      0.975889,
      0,
      NULL,
      0.934260,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.077518,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.017950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.659387,
      1.583813,
      NULL,
      0.745929,
      1.765682,
      0.865276,
      NULL,
      NULL,
      3.257335,
      NULL,
      NULL,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      1.427721,
      NULL,
      NULL,
      NULL,
      1.561654,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504678,
      NULL,
      NULL,
      NULL,
      0.122506,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831201,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.788364,
      1.463749,
      0,
      0,
      NULL,
      NULL,
      1.861249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.117329,
      1.592801,
      9,
      0,
      0.035054,
      1.278059,
      0.044147,
      1,
      1,
      0.561694,
      0,
      0,
      0,
      1.540906,
      0.212788,
      1,
      1.650619,
      0,
      0,
      1.097857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.045636,
      0.254494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568135,
      0.139134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437277,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.195639,
      NULL,
      0,
      NULL,
      0.610986,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      2.878309,
      1,
      0.368664,
      1,
      NULL,
      1,
      1,
      0.662768,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068549,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.429600,
      NULL,
      NULL,
      NULL,
      0.783682,
      NULL,
      0,
      0.472394,
      NULL,
      1.615700,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.279596,
      1.850970,
      1.379255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      7,
      1.863663,
      NULL,
      NULL,
      46.671326,
      91.900480,
      0,
      0.550966,
      3,
      '24034',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


