set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9834038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2,
      3,
      0,
      2.326572,
      3.367307,
      NULL,
      2,
      '210',
      '43231032',
      0.809762,
      NULL,
      '2034241',
      3.513748,
      1,
      1,
      1,
      '1411',
      0.246454,
      0,
      NULL,
      NULL,
      ' 8- 8-1986',
      89.077045,
      117,
      NULL,
      3,
      3,
      ' 3-10-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1996',
      ' 2-26-1999',
      NULL,
      2.534271,
      NULL,
      0.083359,
      3.317244,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      19,
      5.880874,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3,
      3.294129,
      5,
      NULL,
      5,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      2,
      3,
      1,
      5.846641,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.001200,
      NULL,
      NULL,
      0,
      NULL,
      8,
      1,
      1.602443,
      2.972079,
      2.518738,
      0,
      1,
      0.625503,
      3,
      NULL,
      0,
      0.334809,
      0,
      1,
      0.040674,
      0,
      0.036753,
      0,
      1,
      NULL,
      8,
      0,
      2,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      5,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      0.004115,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1.132278,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      4,
      NULL,
      5,
      2,
      5,
      5,
      NULL,
      2,
      0,
      3,
      0,
      3,
      2,
      1,
      2.358373,
      ' 9-26-1983',
      NULL,
      '10- 0-1984',
      342.238750,
      3.303733,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      1,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749823,
      NULL,
      0,
      0.926770,
      1,
      0.734790,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.954759,
      0.942120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.303867,
      1.258727,
      NULL,
      2.744684,
      0.751148,
      0,
      3.151956,
      38,
      2.707917,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.485695,
      1,
      1,
      1,
      3,
      2,
      1,
      1,
      3,
      3,
      3,
      1,
      NULL,
      0,
      0,
      1,
      0.164641,
      1,
      NULL,
      0.295060,
      1,
      1,
      1,
      NULL,
      1,
      0.624290,
      0,
      0,
      0,
      1.415935,
      NULL,
      4,
      3.642191,
      NULL,
      6.774974,
      2,
      0.314072,
      4,
      3,
      5,
      0,
      1,
      2.736390,
      51,
      NULL,
      0.016040,
      24,
      NULL,
      16,
      NULL,
      0,
      2,
      2.597255,
      '42324',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.824786,
      NULL,
      NULL,
      '',
      NULL,
      29,
      80.799887,
      NULL,
      NULL,
      19.065854,
      0,
      NULL,
      4,
      2.679383,
      2.493626,
      3.301000,
      0.083475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.636844,
      1.654084,
      0,
      1.399517,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727526,
      3.295116,
      NULL,
      3.164180,
      0.820342,
      3.994972,
      NULL,
      NULL,
      NULL,
      2,
      1.541345,
      3.945285,
      2.422271,
      0.600215,
      2,
      0.348179,
      NULL,
      NULL,
      3,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.808679,
      NULL,
      NULL,
      NULL,
      0.750365,
      1,
      2,
      0.473650,
      NULL,
      NULL,
      3,
      1,
      2.756556,
      2.606447,
      3.491160,
      0,
      2,
      0.666793,
      1,
      1,
      3.566501,
      0,
      1,
      1.434214,
      1,
      NULL,
      0,
      2,
      NULL,
      0.779955,
      NULL,
      NULL,
      1.786526,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.066650,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      9,
      4.451728,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.806383,
      1.436089,
      3.215729,
      1,
      NULL,
      NULL,
      1.455389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.404762,
      NULL,
      NULL,
      1.558633,
      NULL,
      NULL,
      3,
      5,
      6.163836,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.625720,
      2.575493,
      2.326222,
      1.176331,
      0.189546,
      0,
      0.556616,
      6.945274,
      3.332269,
      6.029258,
      1,
      1.770839,
      3.683999,
      3.576088,
      1.500439,
      3,
      0,
      3,
      NULL,
      NULL,
      2.566094,
      0.454151,
      6,
      7.374478,
      5.144582,
      5,
      1,
      NULL,
      0.248939,
      3,
      2,
      0,
      0,
      NULL,
      0.844695,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.858869,
      NULL,
      NULL,
      2.445783,
      NULL,
      NULL,
      1,
      NULL,
      1.557724,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.669403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.324984,
      NULL,
      NULL,
      NULL,
      1.214592,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.077839,
      1.549653,
      43.752197,
      6.474742,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      0,
      0,
      NULL,
      1.574330,
      1,
      0.032340,
      NULL,
      0,
      1.682525,
      0.243824,
      0.799236,
      0,
      NULL,
      0,
      1,
      1.062753,
      1.160961,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984142,
      0.474312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991877,
      1.145630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621314,
      0.527523,
      1.415871,
      1,
      0,
      0,
      NULL,
      NULL,
      0.299532,
      1.060005,
      NULL,
      1.985504,
      0,
      1,
      0.881253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      5,
      5,
      3.540436,
      3,
      NULL,
      NULL,
      NULL,
      1.436838,
      0.959083,
      0,
      NULL,
      1.228501,
      2.855265,
      NULL,
      0.435883,
      3.732281,
      NULL,
      1.852782,
      3,
      NULL,
      0.844554,
      1.141020,
      NULL,
      0.240388,
      1,
      NULL,
      1.299933,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.959806,
      NULL,
      0.254730,
      NULL,
      NULL,
      1.424704,
      1.813338,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.071472,
      NULL,
      4,
      3,
      3,
      0.712006,
      1,
      0,
      NULL,
      50,
      0,
      3,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


