set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7727700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '3021234',
      3.955510,
      NULL,
      1,
      0,
      '3012',
      3,
      2.460336,
      NULL,
      14,
      ' 3-12-1983',
      NULL,
      NULL,
      NULL,
      0,
      0.271383,
      '10- 6-1991',
      NULL,
      1,
      12,
      79.482621,
      2,
      ' 6- 9-1998',
      ' 4- 4-1997',
      NULL,
      2,
      1.235694,
      0.928769,
      0.103941,
      NULL,
      NULL,
      2,
      0.296148,
      0,
      NULL,
      0,
      9.435580,
      6.921644,
      23.935902,
      NULL,
      5,
      21.768920,
      5,
      NULL,
      8,
      0,
      0,
      NULL,
      0.029661,
      0,
      1.555429,
      0,
      0,
      1,
      1,
      1.826268,
      7,
      0,
      NULL,
      3.161193,
      2,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1.456013,
      0,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.097543,
      NULL,
      1,
      NULL,
      1,
      1,
      1.946740,
      0,
      1,
      1.714233,
      0,
      2.016805,
      0.643497,
      0,
      1,
      0.406095,
      0.198283,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      1,
      1.928124,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      3,
      0,
      1,
      3,
      0,
      0,
      3,
      1,
      1,
      0,
      1,
      4,
      2,
      1,
      0,
      0,
      1,
      NULL,
      2.198609,
      5,
      NULL,
      NULL,
      NULL,
      1,
      3,
      4,
      4,
      NULL,
      2,
      0,
      3,
      5,
      3,
      0,
      2,
      4,
      4,
      1,
      2,
      3,
      1,
      1,
      3,
      1,
      NULL,
      3.811456,
      '11- 0-1992',
      2,
      ' 6-24-1992',
      4,
      2.890998,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317256,
      3,
      9.335351,
      3.879399,
      NULL,
      3.474044,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793335,
      7.483968,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.753815,
      1.731472,
      NULL,
      0,
      1,
      NULL,
      29.599441,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.937714,
      3,
      3,
      2,
      2,
      3,
      3,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      0.742548,
      1.983941,
      2,
      1,
      1.950944,
      2,
      1.843275,
      0.583348,
      NULL,
      NULL,
      0,
      1.036643,
      1,
      1.091565,
      1,
      0.676547,
      3.849884,
      0.423388,
      NULL,
      2,
      0,
      7,
      NULL,
      3.780501,
      0,
      3.649565,
      0.777627,
      0.851000,
      0.290790,
      2.691401,
      20.564368,
      2,
      0,
      NULL,
      0,
      9,
      37,
      5,
      NULL,
      NULL,
      '30124',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1.911022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705828,
      1,
      1,
      1.819717,
      NULL,
      NULL,
      0.980488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.377674,
      44.787071,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.791285,
      1.569602,
      1,
      1,
      0.530811,
      1.221746,
      1.229069,
      1.262286,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.117481,
      NULL,
      1.541007,
      NULL,
      1.591713,
      NULL,
      0,
      NULL,
      7,
      NULL,
      NULL,
      31,
      1,
      1.609038,
      1.313385,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848046,
      NULL,
      0.308702,
      NULL,
      0.609090,
      NULL,
      NULL,
      NULL,
      0.878049,
      NULL,
      1.773299,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.377661,
      NULL,
      1,
      NULL,
      0,
      3,
      0.509906,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093295,
      NULL,
      0.392575,
      NULL,
      1.771902,
      NULL,
      0.528647,
      0.764702,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630265,
      0.347095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.019925,
      NULL,
      0.969531,
      NULL,
      NULL,
      NULL,
      0.569983,
      NULL,
      1.352774,
      NULL,
      1.306433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      7,
      1.737741,
      6,
      4.114775,
      1,
      13,
      NULL,
      NULL,
      1.774689,
      1.134720,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      1.941234,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.301074,
      NULL,
      1.186888,
      3.903856,
      NULL,
      0.198243,
      2,
      NULL,
      NULL,
      1.753994,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      3.097862,
      0.572000,
      0.209906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367620,
      NULL,
      1.144668,
      NULL,
      0.970682,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      68.780531,
      35.356980,
      1,
      NULL,
      3,
      '41331',
      '',
      '',
      1.447641,
      '00323',
      '',
      '',
      1.667336,
      '',
      '',
      NULL);
commit;
end;
/


