set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6817387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      0.455117,
      NULL,
      1,
      '1144',
      1.179369,
      NULL,
      NULL,
      NULL,
      ' 7-14-1997',
      NULL,
      NULL,
      3,
      1,
      1,
      ' 9-18-1974',
      74.429588,
      2.703584,
      203.634999,
      NULL,
      0,
      '10-10-1998',
      ' 8-11-1995',
      '10-24-1974',
      NULL,
      0,
      0.241931,
      0.290965,
      1.709251,
      2,
      8,
      1.580706,
      NULL,
      61.993565,
      NULL,
      19.639863,
      NULL,
      NULL,
      18.950361,
      1,
      6.552442,
      2,
      0,
      7,
      1.546717,
      1,
      NULL,
      1,
      NULL,
      1.541160,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      2.251609,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1,
      2,
      NULL,
      1,
      1.823805,
      NULL,
      NULL,
      1.482995,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.339432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      2,
      NULL,
      1,
      4,
      4,
      4,
      5,
      2,
      NULL,
      1,
      8.623845,
      NULL,
      0,
      NULL,
      NULL,
      0.755940,
      NULL,
      NULL,
      0,
      3,
      0,
      5,
      NULL,
      5,
      3,
      NULL,
      NULL,
      3,
      3,
      NULL,
      4,
      0,
      3,
      NULL,
      1,
      5,
      4,
      3,
      0,
      5,
      NULL,
      1,
      0,
      0.901567,
      3.847386,
      ' 2- 0-1983',
      202,
      NULL,
      515.310946,
      3.429430,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      5,
      4,
      1,
      1.465776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512917,
      6,
      1,
      1.532191,
      NULL,
      1.838054,
      NULL,
      NULL,
      NULL,
      0.033322,
      2.537215,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.500328,
      1,
      1,
      NULL,
      0.231967,
      0.048324,
      1.577743,
      20,
      1.442528,
      1.492963,
      NULL,
      NULL,
      NULL,
      0,
      0.886104,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      3,
      NULL,
      1,
      1,
      2,
      3.942070,
      3.320539,
      1.024250,
      NULL,
      0,
      1,
      1,
      3,
      1.406459,
      0,
      1.474015,
      1,
      0,
      0,
      0.333632,
      0.176256,
      0.640383,
      NULL,
      NULL,
      4,
      2,
      9,
      NULL,
      4.275532,
      NULL,
      7,
      2.461527,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      20,
      NULL,
      59,
      1,
      NULL,
      0.333276,
      '42230',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.178947,
      NULL,
      409.101418,
      26,
      1,
      31.422922,
      NULL,
      6,
      2,
      2,
      2.181557,
      2.530212,
      1,
      2.541119,
      0,
      2.607185,
      NULL,
      0.525195,
      1,
      NULL,
      0,
      1.388613,
      NULL,
      NULL,
      2,
      3.172648,
      0,
      3,
      1,
      1.892189,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.528321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.590194,
      2,
      NULL,
      1.669046,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.941088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730777,
      NULL,
      NULL,
      0.918744,
      NULL,
      NULL,
      0.942405,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511238,
      NULL,
      NULL,
      3,
      1,
      1.376484,
      0.630088,
      NULL,
      NULL,
      NULL,
      NULL,
      2.266339,
      3.520881,
      NULL,
      1,
      0.120133,
      NULL,
      NULL,
      1.147121,
      2,
      1.333071,
      1.787538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993202,
      NULL,
      NULL,
      0.343269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789785,
      NULL,
      NULL,
      3,
      1,
      0.046392,
      1.466605,
      0,
      NULL,
      5.628549,
      0.176124,
      NULL,
      6.387447,
      1,
      NULL,
      5,
      5,
      1.525723,
      0,
      3.576999,
      NULL,
      NULL,
      2.803394,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      3.932348,
      2,
      2,
      2,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      2,
      2.847365,
      3.578162,
      0.205534,
      3.033494,
      0.802221,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      1.649413,
      1.389696,
      1,
      1.023575,
      3,
      NULL,
      NULL,
      1.131446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.495643,
      NULL,
      NULL,
      0.906285,
      NULL,
      NULL,
      2.915492,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.962657,
      NULL,
      NULL,
      3.621808,
      NULL,
      NULL,
      4.061459,
      NULL,
      NULL,
      1,
      NULL,
      1.563428,
      1.921960,
      1.602376,
      0.318771,
      0.007068,
      NULL,
      NULL,
      3.969615,
      2,
      NULL,
      NULL,
      60,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.213981,
      NULL,
      NULL,
      NULL,
      2,
      1.548226,
      NULL,
      NULL,
      0.252486,
      NULL,
      NULL,
      NULL,
      0.122088,
      NULL,
      NULL,
      NULL,
      0,
      0.881747,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.919120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.136165,
      NULL,
      NULL,
      NULL,
      0.551485,
      1.820285,
      NULL,
      NULL,
      0.174726,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.601109,
      0.179893,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      138.089742,
      5.712621,
      1.641512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.270228,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.426168,
      NULL,
      1,
      7,
      NULL,
      1,
      0.897929,
      1,
      0,
      0,
      0.299237,
      NULL,
      0.947858,
      NULL,
      0,
      1,
      1,
      0.906308,
      0,
      1,
      1.855522,
      NULL,
      0.137760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.821194,
      2.909736,
      3.468713,
      3,
      5.875466,
      0,
      3.009277,
      NULL,
      1.751497,
      0.061363,
      1,
      0.129672,
      0.774130,
      1,
      1.163240,
      3.688111,
      1,
      1,
      1.701566,
      0.422469,
      1.918958,
      0,
      NULL,
      0,
      1.595362,
      0.190722,
      1,
      1.206914,
      NULL,
      1.734684,
      NULL,
      1.562859,
      1.436663,
      1.625724,
      1,
      0.046386,
      0,
      1,
      0.515070,
      0,
      0.797412,
      0.964885,
      3.259508,
      1.704812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023543,
      NULL,
      NULL,
      0,
      0.683524,
      2,
      3,
      1,
      2,
      NULL,
      3,
      10,
      33,
      NULL,
      1,
      0,
      NULL,
      '00021',
      '41440',
      0,
      '',
      '',
      '',
      1.719562,
      '',
      '',
      '');
commit;
end;
/


