set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '2300002',
      3.599289,
      0.858808,
      2,
      3,
      '1244',
      2.431362,
      1.449075,
      NULL,
      NULL,
      ' 7-17-1996',
      5,
      NULL,
      3,
      NULL,
      0,
      NULL,
      27.314561,
      0,
      81,
      85.952386,
      1,
      ' 7- 5-1985',
      ' 6- 4-2002',
      ' 1- 8-1976',
      0.439854,
      2,
      NULL,
      NULL,
      0.587492,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.136951,
      3,
      3,
      NULL,
      3,
      12,
      3,
      3,
      0,
      0.909650,
      2,
      1,
      1,
      0,
      NULL,
      0.115050,
      NULL,
      0,
      1.935176,
      1.384226,
      2,
      3,
      NULL,
      0,
      1,
      0,
      3,
      1,
      1,
      4,
      0,
      0,
      0,
      1,
      1,
      1,
      11.023371,
      NULL,
      0,
      0,
      0,
      0.537276,
      NULL,
      NULL,
      0.400215,
      NULL,
      NULL,
      0,
      1,
      0,
      0.818347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.943304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      4,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      0,
      1.557831,
      NULL,
      1.458332,
      NULL,
      3,
      0,
      1,
      NULL,
      5,
      5,
      0,
      1,
      0,
      1,
      2,
      4,
      NULL,
      3,
      1,
      5,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.740828,
      3,
      ' 3-22-1983',
      140.066323,
      ' 9-10-1986',
      5.061543,
      0.188724,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.508723,
      2.378779,
      0.156749,
      2,
      NULL,
      NULL,
      3,
      NULL,
      4.610704,
      3,
      0,
      3,
      NULL,
      3.412802,
      0.171736,
      3,
      1,
      0,
      1,
      0.403262,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.061665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.453913,
      NULL,
      1.449966,
      1.601992,
      NULL,
      1,
      NULL,
      33,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.325173,
      3,
      0,
      1,
      1,
      3,
      0,
      NULL,
      1,
      3,
      3,
      3,
      2.993604,
      3.494284,
      0.815556,
      1,
      NULL,
      1,
      0,
      0.569384,
      NULL,
      0,
      NULL,
      0.182025,
      1,
      0.525236,
      1,
      NULL,
      2.508045,
      1,
      1.955839,
      11,
      3.091610,
      0.109480,
      4,
      1.855960,
      NULL,
      3.563286,
      7.778446,
      3.977454,
      2.967130,
      2,
      NULL,
      1,
      3,
      NULL,
      70,
      71,
      NULL,
      4,
      0.899377,
      5.388788,
      '11200',
      '13131',
      '',
      1.009058,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.146355,
      35.757323,
      22.752535,
      41.859003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.048185,
      NULL,
      NULL,
      1.542893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121306,
      0,
      0.086554,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.530110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.149624,
      NULL,
      NULL,
      1.032506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.440426,
      NULL,
      1,
      12.286826,
      NULL,
      NULL,
      3.957757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.806982,
      NULL,
      NULL,
      1.131108,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.436106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951920,
      NULL,
      0,
      0.303080,
      NULL,
      NULL,
      1.898824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.416084,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.469884,
      3.992476,
      1.072454,
      0.194526,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.374346,
      NULL,
      NULL,
      1.378111,
      NULL,
      1.943671,
      NULL,
      NULL,
      NULL,
      1.825294,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.384458,
      NULL,
      3.592160,
      1,
      NULL,
      NULL,
      0.437634,
      2,
      NULL,
      0,
      2.325832,
      3,
      NULL,
      NULL,
      NULL,
      0.457081,
      NULL,
      0,
      1,
      1.009790,
      1,
      NULL,
      NULL,
      1.682801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367903,
      NULL,
      1,
      1.058946,
      0.961320,
      0.328733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.072889,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.808073,
      NULL,
      NULL,
      1.356851,
      NULL,
      NULL,
      0.889636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304831,
      NULL,
      0,
      45.215099,
      5,
      1,
      0,
      0.395007,
      NULL,
      1.811891,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.847708,
      NULL,
      1.486912,
      0.884113,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055655,
      1.153278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848677,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.808102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130083,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.625437,
      33,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      0,
      3,
      1.199105,
      3,
      1,
      NULL,
      1,
      1.434982,
      NULL,
      1.386042,
      NULL,
      0.483470,
      0.546895,
      NULL,
      1.576388,
      NULL,
      NULL,
      1.378760,
      0,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310137,
      2.902246,
      NULL,
      0,
      1,
      NULL,
      1.492874,
      1.052586,
      NULL,
      NULL,
      2,
      NULL,
      1.390482,
      NULL,
      NULL,
      3,
      1.849908,
      0.591063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.980015,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      0.974643,
      NULL,
      NULL,
      8.952676,
      NULL,
      NULL,
      1.976298,
      4.725381,
      '34333',
      '23020',
      '21232',
      0.302682,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


