set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '0010022',
      0.217676,
      0.208622,
      0,
      3,
      '2300',
      0.556960,
      1.426103,
      NULL,
      NULL,
      ' 6-16-1990',
      15,
      NULL,
      3,
      0,
      NULL,
      ' 3-17-1979',
      34.282022,
      2,
      NULL,
      78,
      2,
      NULL,
      ' 0-13-1986',
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.332801,
      NULL,
      4,
      11.705753,
      3,
      NULL,
      2.484047,
      0,
      0,
      0,
      NULL,
      1.280369,
      0.544194,
      0.979279,
      NULL,
      NULL,
      0,
      1.580152,
      3,
      2,
      1,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      4,
      3,
      NULL,
      0,
      5,
      0,
      2,
      2,
      1,
      1.801602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.540837,
      0,
      NULL,
      1,
      1.645904,
      1.115196,
      1.346150,
      1.517930,
      1.562807,
      1,
      0,
      1,
      0.971094,
      1.925906,
      0,
      1,
      NULL,
      1,
      3,
      0,
      1,
      0,
      3.412523,
      0.865908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      2,
      2,
      3,
      1,
      2,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      5,
      2,
      NULL,
      2,
      0,
      5,
      NULL,
      NULL,
      3,
      3,
      NULL,
      4,
      2,
      1,
      0,
      4,
      2,
      4,
      3,
      1,
      5,
      0,
      4,
      2,
      ' 2-21-1985',
      1.051458,
      NULL,
      0.647859,
      0.632564,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      1.789135,
      1.649277,
      0,
      0.450687,
      1.977512,
      NULL,
      3,
      2,
      0,
      NULL,
      1.385012,
      3.190174,
      0.149730,
      1.106062,
      2,
      1.473820,
      NULL,
      NULL,
      5.351222,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.659651,
      2.803659,
      1.550764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1.755140,
      1,
      0.570700,
      18.946217,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.115718,
      2,
      3,
      3,
      1,
      1,
      3,
      0,
      3,
      1,
      3,
      NULL,
      3,
      3.158773,
      0.817599,
      1,
      0.222205,
      0.236585,
      3.432477,
      NULL,
      NULL,
      NULL,
      1.015484,
      1.628563,
      1,
      1.871747,
      NULL,
      0,
      1,
      3,
      0.761967,
      2.767022,
      9,
      2,
      1.663876,
      2,
      6,
      3,
      1.455981,
      2,
      3.687557,
      0,
      1,
      39,
      0,
      NULL,
      NULL,
      22,
      8,
      45.764284,
      4,
      0.758051,
      NULL,
      '00020',
      '',
      NULL,
      0.407458,
      '22422',
      NULL,
      '',
      0.408832,
      '0104',
      '',
      '',
      NULL,
      30,
      8,
      37.313885,
      1.276852,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.918662,
      NULL,
      NULL,
      0.730555,
      NULL,
      NULL,
      1.910856,
      NULL,
      NULL,
      1.123511,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235859,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.062123,
      NULL,
      NULL,
      1.876219,
      NULL,
      NULL,
      0.084922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.453989,
      NULL,
      NULL,
      1.903302,
      NULL,
      NULL,
      1.836514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.844212,
      NULL,
      NULL,
      0.298466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.734631,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477201,
      NULL,
      NULL,
      0.104115,
      NULL,
      NULL,
      3.070774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.542972,
      0.097029,
      NULL,
      3,
      0,
      NULL,
      5,
      3,
      2,
      NULL,
      2.847080,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.798946,
      1.908985,
      5,
      1.557162,
      NULL,
      NULL,
      0.548199,
      NULL,
      NULL,
      NULL,
      0.924502,
      0.144883,
      1.487988,
      0,
      0.881077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221373,
      NULL,
      1,
      NULL,
      0.850933,
      0.173279,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591605,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.390295,
      0.166717,
      0.109657,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.662287,
      0,
      NULL,
      NULL,
      0.505075,
      NULL,
      NULL,
      1.512962,
      NULL,
      1.700885,
      3.085694,
      2.616182,
      1,
      0.662754,
      NULL,
      0.454047,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.857175,
      1,
      0,
      1.578306,
      0.254295,
      1.364461,
      0.831688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593940,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447294,
      0.049981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.709882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.456990,
      NULL,
      1.413369,
      NULL,
      99,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      0.179823,
      1.201056,
      13,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      0.142598,
      0,
      1,
      2,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.517795,
      NULL,
      NULL,
      1.895235,
      NULL,
      3.426824,
      NULL,
      NULL,
      NULL,
      0.831052,
      NULL,
      1.254269,
      3.974611,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.518414,
      2,
      NULL,
      1,
      1.408849,
      NULL,
      1,
      1.929173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.602128,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      0.608846,
      NULL,
      NULL,
      142.849773,
      15.105070,
      2,
      0.139690,
      4.928458,
      '10043',
      '01214',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '4223',
      '',
      '');
commit;
end;
/


