set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1401034',
      5,
      0.401303,
      3,
      2,
      '2202',
      3,
      0.306430,
      NULL,
      NULL,
      '11- 6-1989',
      55,
      NULL,
      NULL,
      2.421005,
      0.694985,
      NULL,
      49.634650,
      2,
      NULL,
      131.118048,
      3,
      '11-15-1996',
      ' 6-19-1984',
      NULL,
      2,
      1,
      2,
      0.203241,
      0.700533,
      2.512107,
      2,
      0.020244,
      0,
      0.065037,
      NULL,
      11,
      5.149833,
      15.589912,
      19,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1.930333,
      1.284035,
      1.219506,
      0,
      0,
      1,
      2.467416,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.915665,
      1.969054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      5,
      2,
      NULL,
      0,
      5,
      0,
      NULL,
      0,
      1,
      NULL,
      0.954359,
      3,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      3,
      4,
      3,
      0,
      4,
      4,
      1,
      1,
      1,
      1.168332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2.512179,
      2.972514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.980729,
      1.793526,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.379124,
      3.306169,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.860709,
      1,
      1.672328,
      0,
      1.745965,
      0,
      3,
      11.074623,
      2,
      0,
      24.581872,
      NULL,
      NULL,
      1,
      0.655124,
      2,
      0,
      1,
      3,
      3,
      0,
      2,
      NULL,
      0,
      3,
      NULL,
      3,
      3,
      3.671349,
      NULL,
      0,
      0.054610,
      NULL,
      0.947014,
      1,
      0.051419,
      1.424384,
      NULL,
      1.727943,
      0,
      0,
      0,
      1,
      NULL,
      0.349611,
      0.976925,
      NULL,
      5.395681,
      2,
      7.879104,
      NULL,
      4.265271,
      NULL,
      NULL,
      NULL,
      3.002298,
      0.405027,
      NULL,
      3,
      NULL,
      NULL,
      27,
      28,
      NULL,
      0,
      NULL,
      1.654616,
      '13210',
      '',
      '',
      1.851423,
      NULL,
      NULL,
      '',
      3,
      '4234',
      '',
      NULL,
      3,
      26.403106,
      2.546171,
      30.868463,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.787880,
      NULL,
      NULL,
      0.777239,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.012822,
      NULL,
      1.340988,
      3.336279,
      1,
      1,
      0.677643,
      NULL,
      NULL,
      1.773737,
      NULL,
      NULL,
      0.134804,
      1.929887,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.442894,
      1,
      2,
      1.093897,
      0.087353,
      1,
      0.728699,
      NULL,
      NULL,
      NULL,
      0.776806,
      NULL,
      NULL,
      NULL,
      0.075604,
      1,
      0,
      0.474426,
      NULL,
      NULL,
      1.658613,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930633,
      0.383540,
      1,
      NULL,
      NULL,
      1.155647,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.280102,
      NULL,
      NULL,
      1.236938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      1.641261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147496,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.892746,
      NULL,
      NULL,
      6.270931,
      0,
      0.286170,
      1,
      0.704936,
      1.981415,
      2,
      0.944550,
      1,
      6.338599,
      NULL,
      0.543421,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.725894,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.106187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020892,
      NULL,
      0,
      3.980865,
      1.793209,
      0.995818,
      1,
      1.700960,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.574428,
      2.272364,
      2.964876,
      NULL,
      2,
      2,
      NULL,
      2,
      4.363680,
      3.039127,
      3.931476,
      1,
      2.090592,
      1,
      2.774287,
      NULL,
      3.789436,
      3.218248,
      1.623012,
      3,
      1.463396,
      7,
      5,
      4.791307,
      3,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      1,
      1.424514,
      NULL,
      3.685537,
      NULL,
      NULL,
      2.736809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.336352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.753137,
      NULL,
      1.117083,
      0.096695,
      0.710894,
      0.424001,
      3,
      NULL,
      NULL,
      6,
      3.777676,
      NULL,
      NULL,
      0.827393,
      NULL,
      NULL,
      NULL,
      0.896283,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      0.377217,
      NULL,
      NULL,
      0.916187,
      0.305255,
      NULL,
      NULL,
      NULL,
      0.379460,
      NULL,
      NULL,
      1.619577,
      2.549051,
      NULL,
      NULL,
      0.869474,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.495399,
      NULL,
      NULL,
      1.261520,
      NULL,
      NULL,
      NULL,
      1.429288,
      1.686909,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.703603,
      0.717123,
      NULL,
      NULL,
      2.452033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.763950,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.948496,
      NULL,
      1.817639,
      524.253367,
      18,
      1.408345,
      1,
      1.089029,
      0,
      1.371231,
      0.560040,
      NULL,
      NULL,
      0.806081,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.900300,
      0.792984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.495628,
      0.365254,
      1.941007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587448,
      0.599123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846095,
      0.554714,
      NULL,
      2,
      NULL,
      2.786736,
      NULL,
      185.350423,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      29,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.708026,
      1,
      0,
      2.153209,
      0,
      4.382944,
      2.615099,
      1.449110,
      3,
      1.682386,
      NULL,
      1.666588,
      0.079632,
      0.931839,
      1,
      1.833571,
      1.236714,
      1,
      1,
      1,
      0,
      3.538416,
      2.456184,
      1,
      0.177659,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1.265152,
      0,
      1,
      0,
      1,
      0.809658,
      2,
      2.254089,
      1,
      0,
      1.030872,
      3.732074,
      0,
      1.791066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696763,
      1.834764,
      0.828447,
      NULL,
      0,
      0,
      2,
      4,
      0,
      NULL,
      NULL,
      NULL,
      113.324937,
      3,
      0.728515,
      3,
      NULL,
      '',
      NULL,
      3.000933,
      '14204',
      '',
      '',
      2,
      '1140',
      '',
      '');
commit;
end;
/


