set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8836024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0400330',
      0,
      0,
      1,
      0,
      '0004',
      3.048635,
      1.678133,
      NULL,
      NULL,
      ' 5-21-1980',
      0,
      NULL,
      NULL,
      0,
      1.908979,
      ' 7-27-1982',
      0,
      NULL,
      48,
      NULL,
      0,
      NULL,
      ' 0- 8-1993',
      NULL,
      1.804756,
      0.632502,
      NULL,
      0.166210,
      0,
      2.481729,
      0,
      0.321281,
      1.563392,
      NULL,
      NULL,
      8.549311,
      3,
      3,
      4,
      NULL,
      2.814949,
      2,
      2,
      2,
      1,
      NULL,
      1,
      1.122107,
      0.004966,
      NULL,
      0,
      1,
      0.754468,
      NULL,
      1.843862,
      1,
      3,
      2,
      3.884575,
      3,
      1,
      NULL,
      NULL,
      5,
      0,
      4,
      0,
      NULL,
      1,
      1,
      1,
      6,
      1,
      1,
      NULL,
      NULL,
      0.475623,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.951079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.570940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      4,
      3,
      4,
      3,
      2,
      NULL,
      NULL,
      NULL,
      9.824340,
      1,
      NULL,
      1,
      NULL,
      1.759340,
      NULL,
      1.346039,
      0,
      1,
      0,
      0,
      3,
      5,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      4,
      1,
      4,
      1,
      0,
      NULL,
      2,
      0,
      0,
      3,
      0,
      NULL,
      1.474779,
      2.142634,
      NULL,
      2,
      ' 6-14-1974',
      NULL,
      0.673786,
      0,
      0,
      0,
      1,
      NULL,
      2,
      1,
      0,
      1,
      3,
      1,
      2,
      5,
      NULL,
      NULL,
      4,
      2.876515,
      NULL,
      NULL,
      1,
      ' 8-16-2003',
      6.408922,
      ' 9-21-1981',
      17,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7,
      1.775480,
      0.797780,
      1.061890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.092926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999916,
      1.528115,
      0,
      0.288810,
      1.485105,
      1.560038,
      1,
      9,
      1.991024,
      1.720666,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      3,
      NULL,
      2,
      0,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.060201,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      9,
      3.531741,
      NULL,
      2,
      3.692064,
      NULL,
      1,
      3.921375,
      1.449263,
      3,
      1,
      23.534114,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11.004524,
      2,
      NULL,
      2,
      '20420',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.930671,
      '',
      '',
      '',
      0.225266,
      36.654319,
      44,
      13,
      0.366439,
      NULL,
      2.469628,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.589245,
      NULL,
      NULL,
      0,
      1,
      2,
      0.398181,
      0,
      2.598017,
      0,
      NULL,
      NULL,
      1.171814,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.352175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.858765,
      6,
      4.424135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.614966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225986,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.716645,
      1,
      0,
      0.634825,
      NULL,
      NULL,
      0,
      NULL,
      1.664392,
      7,
      1.165034,
      0.708054,
      2,
      3,
      1.748076,
      2.844202,
      NULL,
      1,
      NULL,
      4,
      0.426262,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.218203,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      2.504922,
      0,
      4,
      NULL,
      0.492966,
      1.196062,
      NULL,
      NULL,
      5,
      1,
      0.430770,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.957414,
      1,
      NULL,
      NULL,
      0.400094,
      2,
      1,
      1,
      1.221582,
      2,
      3,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      9.966838,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      0.619822,
      1.169053,
      0.792365,
      3.977161,
      NULL,
      NULL,
      3.234102,
      NULL,
      NULL,
      113.257343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446968,
      NULL,
      NULL,
      1.839032,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793508,
      NULL,
      NULL,
      3.183573,
      NULL,
      NULL,
      0.886955,
      NULL,
      NULL,
      0.384784,
      0.409488,
      0,
      0.769681,
      NULL,
      1.360462,
      NULL,
      NULL,
      NULL,
      3.340097,
      2,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.975646,
      NULL,
      NULL,
      NULL,
      0,
      1.922945,
      NULL,
      NULL,
      0.815157,
      1.568772,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437449,
      NULL,
      NULL,
      NULL,
      1.033572,
      NULL,
      NULL,
      NULL,
      3.979045,
      NULL,
      NULL,
      NULL,
      1.503442,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799861,
      2,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.664641,
      0.452303,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603532,
      2.486859,
      2.974211,
      NULL,
      NULL,
      NULL,
      0.075723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685421,
      NULL,
      NULL,
      1.912584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2567,
      25.631009,
      1,
      3.119989,
      1,
      0.769179,
      0.573770,
      2,
      0,
      2.125960,
      1,
      NULL,
      1.063220,
      NULL,
      NULL,
      1.159074,
      1.299978,
      0.127434,
      1.082130,
      0.221360,
      NULL,
      0.113949,
      NULL,
      0,
      NULL,
      1.247521,
      NULL,
      0,
      NULL,
      1.858048,
      NULL,
      117,
      NULL,
      2.471039,
      5,
      NULL,
      0.843753,
      0.528995,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.383230,
      NULL,
      0.460720,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.283003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206813,
      NULL,
      NULL,
      NULL,
      0.651913,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0.894054,
      1.810148,
      NULL,
      1,
      0.547847,
      0,
      NULL,
      0.839656,
      0.711176,
      NULL,
      0,
      0.463072,
      1,
      1,
      0.854806,
      0,
      1.888788,
      1.862656,
      0.122309,
      NULL,
      0,
      1.960710,
      0.894333,
      3,
      0.580267,
      0,
      NULL,
      NULL,
      0,
      0,
      1.571343,
      1,
      0,
      1.807333,
      1.034971,
      0,
      2,
      3,
      1.700856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.735507,
      NULL,
      1.227481,
      1.187094,
      0.958064,
      NULL,
      1,
      3,
      1.450015,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1.154230,
      1,
      '00411',
      NULL,
      NULL,
      0.980046,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


