set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      1,
      1.362714,
      3,
      0,
      '1213',
      2.799748,
      0,
      NULL,
      NULL,
      ' 2-19-1990',
      35,
      NULL,
      5,
      NULL,
      1.246544,
      NULL,
      1.506385,
      3.512132,
      278,
      NULL,
      0,
      ' 7-29-1976',
      ' 9-21-2001',
      ' 3-27-2001',
      2,
      1.678119,
      1.027373,
      0.691470,
      0,
      0.393269,
      3,
      0.727280,
      1,
      NULL,
      4,
      11.284294,
      NULL,
      20,
      NULL,
      5,
      2.748560,
      0,
      2,
      5,
      0.608954,
      0,
      1,
      NULL,
      1.262572,
      1,
      0.292359,
      1.004259,
      1,
      0,
      1.160655,
      0,
      2,
      NULL,
      3,
      2,
      1,
      2,
      3,
      0,
      1,
      1,
      0,
      3,
      1,
      4,
      1,
      2.000616,
      0,
      2,
      NULL,
      NULL,
      1.472989,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      0.337864,
      0.008780,
      1.333757,
      NULL,
      0.790202,
      NULL,
      1.104702,
      NULL,
      0.819294,
      0,
      0,
      NULL,
      2.729396,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0.863914,
      NULL,
      NULL,
      0.399238,
      NULL,
      NULL,
      1,
      3,
      5,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      5,
      0,
      2,
      0,
      0,
      NULL,
      1,
      0.046455,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      4,
      1,
      1,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      1,
      3,
      NULL,
      4,
      2,
      4,
      0,
      1,
      0,
      1,
      3,
      5,
      1.065686,
      '10- 2-1978',
      NULL,
      NULL,
      25,
      0,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983850,
      0,
      NULL,
      3.937331,
      NULL,
      1.585890,
      4,
      5.915470,
      4.123027,
      NULL,
      6,
      1.595347,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.778056,
      0.675074,
      0.193131,
      0.706040,
      1,
      0,
      3,
      21,
      0,
      0.231064,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.491169,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      2,
      NULL,
      0.839959,
      3.025314,
      1.841609,
      0.851961,
      NULL,
      6.299970,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0.746927,
      2,
      1,
      NULL,
      NULL,
      6,
      11.630656,
      6.705927,
      0.884970,
      5.335473,
      3,
      1.037415,
      0,
      3.407732,
      0,
      20.314850,
      0,
      0.286576,
      NULL,
      21,
      NULL,
      17,
      4,
      0.131286,
      2.309240,
      NULL,
      '44321',
      '',
      1.796811,
      '',
      '',
      '',
      2,
      '4402',
      '',
      '',
      1.226906,
      34.772459,
      11.614137,
      37,
      2,
      51.276785,
      3,
      0.850157,
      0,
      1.567307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.060646,
      0.355930,
      0.245510,
      NULL,
      2.144654,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.478761,
      0.031138,
      1.463252,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.817244,
      0,
      1.748147,
      NULL,
      1,
      2,
      0,
      NULL,
      10.628057,
      0,
      1,
      2.563665,
      0,
      1.873617,
      13.516796,
      1,
      NULL,
      NULL,
      NULL,
      1.324987,
      1,
      2.184473,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.100835,
      NULL,
      1,
      1,
      1.453658,
      0.163510,
      0,
      0,
      0.880805,
      NULL,
      0.267169,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.429695,
      NULL,
      NULL,
      3,
      NULL,
      9,
      0,
      7,
      0,
      0,
      0.419108,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236766,
      NULL,
      NULL,
      3,
      NULL,
      2.401553,
      NULL,
      NULL,
      0.785934,
      NULL,
      3.156778,
      1.465359,
      3,
      NULL,
      5.075925,
      0,
      3,
      1.447195,
      3,
      1,
      0.215400,
      5,
      5,
      0.963219,
      0.547155,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.956425,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.545365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.958708,
      1,
      2,
      0,
      0.344671,
      0.913391,
      NULL,
      NULL,
      NULL,
      1,
      7.105548,
      1,
      NULL,
      NULL,
      2.786833,
      0.789804,
      1,
      3,
      1.852886,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      4.435073,
      2.764951,
      1,
      3,
      3,
      1,
      3,
      0,
      2,
      0,
      2,
      2,
      NULL,
      1.665189,
      4.170201,
      NULL,
      3,
      3.590567,
      NULL,
      0.113924,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.830367,
      NULL,
      NULL,
      0.369244,
      NULL,
      0,
      NULL,
      NULL,
      1.234680,
      0,
      NULL,
      3.352113,
      1.433436,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.651965,
      NULL,
      3,
      2,
      NULL,
      2.821758,
      2,
      NULL,
      1.850010,
      NULL,
      1.612356,
      0,
      NULL,
      NULL,
      1.081385,
      1,
      NULL,
      NULL,
      0.902720,
      1.084201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.487778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.251465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071701,
      NULL,
      NULL,
      NULL,
      0,
      1.385077,
      NULL,
      NULL,
      1.580327,
      NULL,
      NULL,
      NULL,
      0,
      1.146314,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.398212,
      1.926616,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.997466,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773836,
      NULL,
      NULL,
      0.729948,
      3,
      NULL,
      0.760512,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      237.993098,
      NULL,
      NULL,
      1.266558,
      0.518528,
      NULL,
      1,
      1,
      1,
      2,
      0,
      3.802280,
      1.583308,
      2.510513,
      0.498820,
      NULL,
      NULL,
      1.540837,
      1,
      1.349802,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.784167,
      NULL,
      0.867556,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.321813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.908403,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.858713,
      NULL,
      3.195921,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.596103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.128251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.037407,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.214593,
      NULL,
      0.937067,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.303218,
      1.366323,
      3,
      3,
      NULL,
      0,
      3,
      1.520685,
      1,
      0,
      1,
      NULL,
      1,
      1.308320,
      NULL,
      NULL,
      3,
      1.225228,
      NULL,
      1.545366,
      NULL,
      0.475350,
      0.194740,
      3.155357,
      3.870815,
      3,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0.380022,
      0,
      0,
      1,
      3.689139,
      1,
      NULL,
      NULL,
      0.076874,
      2.413517,
      3,
      3,
      0,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.759445,
      NULL,
      1.923630,
      NULL,
      1,
      NULL,
      0.844523,
      NULL,
      0.406008,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.625000,
      NULL,
      109,
      0,
      NULL,
      1,
      0.866231,
      NULL,
      NULL,
      0.068081,
      NULL,
      0,
      NULL,
      3.647646,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.733148,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.591820,
      NULL,
      0.542971,
      NULL,
      NULL,
      NULL,
      3.977171,
      131.711035,
      NULL,
      NULL,
      1,
      1,
      1.989545,
      1.819849,
      NULL,
      1,
      0,
      4,
      3,
      NULL,
      NULL,
      NULL,
      98.948934,
      103.042455,
      0,
      0.032077,
      0.789219,
      '23441',
      '20303',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '4230',
      '',
      NULL);
commit;
end;
/


