set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0411244',
      5,
      NULL,
      NULL,
      NULL,
      '0404',
      1.035722,
      1,
      NULL,
      NULL,
      ' 2-28-1987',
      40,
      NULL,
      NULL,
      3,
      2.028810,
      ' 9- 3-1987',
      36,
      2,
      160,
      42,
      3,
      ' 7-27-1982',
      ' 0-11-1988',
      '11-13-1998',
      0.336464,
      1.626002,
      2.240878,
      1,
      0,
      1.450416,
      2,
      0,
      0,
      NULL,
      8,
      12.541754,
      3.384741,
      24,
      NULL,
      3,
      18,
      NULL,
      1,
      2,
      0.942772,
      2,
      NULL,
      1.323320,
      NULL,
      0.043450,
      0.464074,
      3,
      0.473283,
      NULL,
      1.289297,
      1,
      5,
      5,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      4,
      0,
      0,
      NULL,
      4.282578,
      0,
      2,
      1,
      NULL,
      1.060765,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      0.567791,
      3.505744,
      NULL,
      1.897651,
      1.496370,
      1.357038,
      0.606236,
      NULL,
      0.126358,
      0,
      NULL,
      NULL,
      0.827161,
      NULL,
      0.127373,
      1,
      1,
      2,
      NULL,
      0,
      2,
      0,
      1,
      1.828673,
      1.376142,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      0,
      0,
      1,
      3.908270,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      1,
      4,
      NULL,
      1,
      4,
      NULL,
      5,
      NULL,
      ' 0-29-1984',
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      5,
      2,
      2,
      0,
      2,
      0,
      4,
      3,
      0,
      1,
      3,
      10.152708,
      2,
      1,
      2,
      ' 1-20-2002',
      5.278713,
      ' 4-10-1975',
      13,
      0.929013,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.217972,
      0.699946,
      3,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.550647,
      2.128503,
      4,
      0.640942,
      4.949464,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679708,
      1,
      0,
      1.381037,
      NULL,
      1.812314,
      0,
      0,
      33,
      3,
      1.243699,
      NULL,
      NULL,
      NULL,
      0,
      1.479105,
      3.923245,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      2,
      0,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      3.495592,
      1,
      1.500275,
      1,
      0,
      0,
      1,
      1.140481,
      NULL,
      0,
      3.520858,
      0,
      1.244702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082298,
      NULL,
      22,
      NULL,
      87.121179,
      NULL,
      0,
      3.643380,
      '04402',
      '02132',
      '',
      1,
      NULL,
      '',
      NULL,
      1.642990,
      '',
      '',
      '',
      0.343964,
      63.520603,
      2,
      55.777023,
      2.681906,
      15,
      2,
      3,
      4,
      2.263350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.174433,
      NULL,
      1,
      0.459979,
      1,
      1.911752,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218967,
      NULL,
      0.009374,
      3,
      3.990493,
      2.263342,
      1.094884,
      NULL,
      3,
      3,
      1,
      0,
      0,
      NULL,
      6.397053,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      1.905919,
      NULL,
      NULL,
      NULL,
      3.163472,
      1.548479,
      6.137102,
      12.416002,
      NULL,
      NULL,
      9.468132,
      NULL,
      NULL,
      2.355424,
      1,
      0.617491,
      NULL,
      0,
      1.676753,
      0.900692,
      0.636486,
      1,
      NULL,
      0.664178,
      1.643176,
      1,
      1,
      1.920523,
      0.331242,
      0.440183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291923,
      NULL,
      NULL,
      0.063338,
      3.372712,
      0.727467,
      1,
      1.677381,
      11.801582,
      6.121898,
      16,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      1.699102,
      14,
      NULL,
      NULL,
      3.910296,
      3.333408,
      0.594964,
      2.155911,
      NULL,
      1,
      NULL,
      1,
      0,
      7,
      8.891602,
      0,
      1.819856,
      0.289921,
      0.031094,
      1.797795,
      NULL,
      NULL,
      0.774207,
      NULL,
      NULL,
      1.938156,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.721746,
      NULL,
      NULL,
      1.462422,
      NULL,
      NULL,
      NULL,
      5.283963,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.133558,
      0.306727,
      0,
      NULL,
      3,
      2.132078,
      1.145388,
      0.134309,
      3.653972,
      8,
      NULL,
      7.435186,
      1.792937,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725079,
      3,
      0.793201,
      NULL,
      0.785295,
      NULL,
      9.605910,
      5.975095,
      NULL,
      3,
      5,
      1,
      2,
      0,
      4,
      2,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.657023,
      NULL,
      NULL,
      3.137152,
      NULL,
      NULL,
      0.064477,
      NULL,
      NULL,
      0.617163,
      NULL,
      NULL,
      3,
      2.242019,
      NULL,
      3,
      18,
      NULL,
      2.727086,
      3,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      0,
      NULL,
      6,
      10.435802,
      NULL,
      0.839783,
      0,
      1,
      1,
      0.916979,
      0.232321,
      3.550626,
      1.753792,
      NULL,
      NULL,
      0.042524,
      0.973533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742377,
      3,
      NULL,
      NULL,
      1.981936,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724930,
      NULL,
      NULL,
      2,
      1.144548,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.170403,
      1,
      NULL,
      NULL,
      1,
      0.951540,
      NULL,
      NULL,
      1.761453,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.885224,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      1.738828,
      NULL,
      NULL,
      NULL,
      1.564133,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316807,
      NULL,
      NULL,
      3,
      10,
      NULL,
      1.731409,
      NULL,
      NULL,
      1.438948,
      NULL,
      NULL,
      8138,
      28,
      0.071486,
      1,
      0.131666,
      0,
      0.754595,
      0.138988,
      0.839728,
      1.957438,
      0,
      NULL,
      NULL,
      NULL,
      0.005226,
      0.428213,
      0.633621,
      NULL,
      0.833125,
      1.725984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.820052,
      1.533039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.240499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029827,
      1,
      0.457013,
      NULL,
      1.554805,
      NULL,
      742,
      NULL,
      3,
      NULL,
      0.039976,
      NULL,
      0.420975,
      NULL,
      0.914004,
      1.482610,
      3.751614,
      NULL,
      1.007618,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      0,
      3,
      NULL,
      2,
      4.342156,
      1.671697,
      3.218731,
      0.198581,
      1,
      1,
      1,
      3,
      2,
      0,
      1.650182,
      3.798066,
      NULL,
      NULL,
      0,
      0,
      1,
      0.911762,
      1.406684,
      0.868234,
      NULL,
      2,
      NULL,
      NULL,
      1.808707,
      3.164427,
      1,
      3,
      1.729125,
      NULL,
      1.759687,
      2.581462,
      0.980106,
      3,
      NULL,
      1,
      2.293425,
      0,
      2,
      0,
      1.677899,
      0,
      0,
      NULL,
      0.451612,
      0,
      0.566739,
      NULL,
      0,
      1.879232,
      0,
      1,
      1,
      1.647138,
      NULL,
      1.470220,
      NULL,
      1.874727,
      NULL,
      3.339981,
      NULL,
      1.810027,
      0,
      0,
      NULL,
      0,
      7,
      0,
      1.428125,
      0.547328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536420,
      0.684818,
      0,
      1.449692,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.974630,
      3,
      '22332',
      '01403',
      NULL,
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


