set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1443433',
      0.076881,
      0,
      5,
      0,
      NULL,
      2.566793,
      NULL,
      NULL,
      NULL,
      '10-25-1989',
      8.654273,
      NULL,
      0,
      NULL,
      2,
      ' 3-13-1993',
      NULL,
      3,
      309.635878,
      43,
      0,
      ' 9-15-1974',
      ' 1-21-1998',
      ' 3-13-1992',
      3.628959,
      1,
      3,
      1.930993,
      NULL,
      0,
      2,
      NULL,
      1.369344,
      18.787569,
      NULL,
      7.791893,
      2.331146,
      10,
      7,
      1,
      NULL,
      5,
      NULL,
      5,
      NULL,
      3,
      NULL,
      0.145725,
      0,
      1.085673,
      1,
      NULL,
      0.606237,
      1.346218,
      NULL,
      1,
      0,
      0,
      0.613906,
      1,
      0,
      1,
      3,
      3,
      1,
      3,
      3,
      3,
      3,
      4,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      0.583691,
      NULL,
      1.882795,
      0,
      0.235836,
      NULL,
      NULL,
      NULL,
      3,
      1.823652,
      1,
      1,
      2,
      NULL,
      0.214225,
      1,
      0,
      0,
      9.574228,
      2,
      2,
      0.478910,
      NULL,
      1,
      3.790481,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      4,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      4,
      1,
      1.362424,
      2,
      0,
      1,
      0,
      1.411237,
      NULL,
      0.741380,
      1,
      4,
      0,
      4,
      3,
      NULL,
      2,
      2,
      3,
      NULL,
      3,
      5,
      5,
      3,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      4,
      NULL,
      4,
      2,
      4,
      3.760324,
      1,
      NULL,
      7,
      ' 7-24-1985',
      18,
      1,
      NULL,
      0,
      4,
      5,
      NULL,
      NULL,
      1,
      3,
      3,
      4,
      0,
      5,
      NULL,
      3,
      0,
      4,
      7,
      1,
      13,
      2,
      ' 0-25-1985',
      1.842154,
      '11-18-1975',
      17,
      0.458445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      8,
      0,
      NULL,
      2,
      1.555448,
      1,
      0.721728,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.020010,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.412620,
      1.844105,
      1,
      NULL,
      1,
      NULL,
      1.937565,
      37.726504,
      3.905501,
      0.971835,
      NULL,
      NULL,
      NULL,
      1,
      0.833774,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      3,
      1,
      3.311061,
      3.724753,
      NULL,
      1,
      1.117781,
      7.818038,
      0.108235,
      1.089732,
      0.429854,
      0,
      0,
      1.605209,
      NULL,
      0,
      NULL,
      0.752664,
      1.493837,
      0,
      5.278748,
      6.691408,
      3,
      NULL,
      6.993141,
      0,
      NULL,
      3,
      7,
      NULL,
      1,
      0.533388,
      57.407460,
      1,
      NULL,
      NULL,
      14,
      NULL,
      62,
      0,
      NULL,
      5.298400,
      NULL,
      '12040',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '2400',
      '',
      '',
      2,
      37.067978,
      13.205054,
      41,
      3.962820,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      1.324480,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.949581,
      1,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.724482,
      NULL,
      3.203263,
      2,
      1,
      1.700068,
      0,
      1.689332,
      NULL,
      3.428485,
      1.822508,
      0,
      3,
      1.482398,
      2,
      2.843719,
      NULL,
      0,
      0.606329,
      3,
      2.292777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.779747,
      0.480122,
      NULL,
      NULL,
      0.203829,
      NULL,
      NULL,
      2.388044,
      0.932064,
      0.855133,
      0.622889,
      0.888123,
      NULL,
      1.316419,
      0.499043,
      NULL,
      NULL,
      NULL,
      0.226579,
      0,
      0,
      1.162774,
      1,
      0.435082,
      NULL,
      NULL,
      0.871165,
      NULL,
      NULL,
      2.604180,
      2,
      17.947245,
      3.282748,
      6.462062,
      2.329281,
      3,
      3.385933,
      11.506473,
      2,
      8,
      1.149295,
      NULL,
      NULL,
      NULL,
      1.495516,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3.485807,
      0.704158,
      NULL,
      0.543033,
      NULL,
      NULL,
      9.649866,
      0.188027,
      1.648473,
      3,
      0,
      3,
      NULL,
      NULL,
      7.412412,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.548575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.649687,
      NULL,
      NULL,
      0,
      3.539611,
      0,
      0.082235,
      0,
      NULL,
      2,
      0,
      1.309828,
      5,
      1.913458,
      3.670410,
      0,
      3.437553,
      NULL,
      3,
      NULL,
      NULL,
      3.757256,
      2.743748,
      NULL,
      2,
      0,
      0,
      6,
      NULL,
      1,
      0.890416,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1,
      1,
      NULL,
      0.046883,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      23.525236,
      9,
      NULL,
      0,
      1.615388,
      NULL,
      0,
      2,
      NULL,
      2.325040,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.050442,
      0.126749,
      NULL,
      0.627750,
      NULL,
      NULL,
      3.181368,
      NULL,
      NULL,
      0.203446,
      NULL,
      NULL,
      3,
      3.502133,
      NULL,
      1,
      0.063506,
      NULL,
      3,
      0,
      NULL,
      3,
      6,
      NULL,
      1.035146,
      NULL,
      1.916793,
      1,
      1,
      NULL,
      3,
      2.356049,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508894,
      0.659920,
      NULL,
      NULL,
      19,
      1.986139,
      NULL,
      NULL,
      6.720138,
      0.211608,
      NULL,
      NULL,
      13,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.029002,
      NULL,
      NULL,
      1.654583,
      1,
      NULL,
      NULL,
      0,
      3.701661,
      NULL,
      NULL,
      0.240584,
      0,
      NULL,
      NULL,
      0.537943,
      0.531766,
      NULL,
      NULL,
      3.465476,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.334873,
      5.968284,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      11.133364,
      2,
      1.345313,
      NULL,
      NULL,
      0.573745,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      10.531295,
      1.926900,
      1,
      1,
      NULL,
      NULL,
      1,
      0.953443,
      3,
      1,
      0,
      1.881627,
      3,
      0.065394,
      0.913590,
      1,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.717384,
      NULL,
      0.914309,
      NULL,
      77.201822,
      NULL,
      NULL,
      NULL,
      24.652343,
      0,
      0.238749,
      NULL,
      NULL,
      1.721405,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.853815,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.555297,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.572726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692328,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      100.477985,
      NULL,
      0.490803,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.249627,
      1.692450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.067887,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797942,
      2.408831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.215406,
      NULL,
      0.721279,
      0,
      0,
      NULL,
      NULL,
      1.274220,
      NULL,
      880.803671,
      NULL,
      2.251108,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      0,
      28,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.333018,
      NULL,
      0,
      1.636568,
      2.976966,
      1.527130,
      NULL,
      0,
      0,
      1.181762,
      0.989065,
      0.289691,
      1,
      NULL,
      3.960635,
      NULL,
      0.299616,
      3,
      0,
      1.426417,
      0,
      NULL,
      0,
      1.584339,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1.892539,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.958412,
      1,
      0,
      3.193033,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.318227,
      NULL,
      0.646460,
      NULL,
      1.445071,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.146215,
      NULL,
      1,
      38,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860000,
      1.154213,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      29.283927,
      122.223458,
      5,
      0.376950,
      6.207676,
      '30342',
      '31203',
      '13124',
      0.602760,
      '',
      '',
      '',
      1,
      '1022',
      NULL,
      '');
commit;
end;
/


