set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      41.961648,
      21.761624,
      NULL,
      0,
      NULL,
      3,
      1,
      '0212',
      2,
      NULL,
      NULL,
      NULL,
      ' 8- 2-2003',
      36.960291,
      86.263037,
      NULL,
      3.629052,
      2,
      '11- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 8-10-2001',
      NULL,
      ' 5- 2-1999',
      1,
      2,
      2.178441,
      2.328052,
      NULL,
      1,
      3,
      0,
      1.685368,
      6.575244,
      7,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      0,
      0.373486,
      1,
      1,
      NULL,
      0.016941,
      1,
      2.465480,
      NULL,
      3,
      2,
      NULL,
      2.495177,
      3,
      0,
      1,
      5,
      0,
      0,
      3,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1.947140,
      2.878769,
      1,
      0,
      NULL,
      1,
      1,
      1.008099,
      1.567068,
      1.231543,
      0,
      1,
      3,
      0.861978,
      0,
      1,
      0,
      5.358141,
      3,
      0,
      NULL,
      0.660312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1.306384,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0,
      0,
      0,
      NULL,
      0.128602,
      NULL,
      140,
      ' 0- 7-2003',
      2,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      NULL,
      0.623652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.384713,
      0,
      1.533557,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.956313,
      NULL,
      0.070748,
      NULL,
      0.161937,
      1.577359,
      0,
      2,
      0.763427,
      1.359024,
      2.142269,
      1,
      NULL,
      NULL,
      0.105436,
      0.394362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353552,
      1,
      NULL,
      1.376196,
      0.726008,
      NULL,
      0.818161,
      0.183467,
      0.135105,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.682070,
      3.001692,
      3,
      0,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      1.843515,
      1.707663,
      0.709102,
      1,
      0.929326,
      NULL,
      0.684725,
      1,
      1.995856,
      0,
      1.275606,
      0,
      1.197060,
      NULL,
      2.288195,
      4,
      9,
      8.401277,
      5,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      39.725805,
      2,
      2.980132,
      3,
      NULL,
      71,
      NULL,
      NULL,
      1.858480,
      NULL,
      '10040',
      '34403',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      3,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772396,
      NULL,
      NULL,
      2,
      NULL,
      0.354054,
      0.417213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092151,
      NULL,
      NULL,
      1.707137,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      141,
      0,
      2.629010,
      NULL,
      NULL,
      0,
      0,
      0.712149,
      1.905638,
      0,
      1.556631,
      1,
      1,
      1,
      1.010107,
      0.739802,
      NULL,
      1,
      2.294722,
      1,
      0,
      NULL,
      1,
      NULL,
      0.836128,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.509739,
      NULL,
      1,
      1.420848,
      NULL,
      1.426893,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.998339,
      NULL,
      1,
      NULL,
      0.770871,
      NULL,
      0.912361,
      NULL,
      NULL,
      NULL,
      1.605090,
      NULL,
      NULL,
      NULL,
      1.103621,
      NULL,
      1.921657,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140390,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.944753,
      1.808762,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.218746,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      305.050579,
      NULL,
      2.824750,
      NULL,
      2.362939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      286.368400,
      NULL,
      2,
      NULL,
      0.437531,
      NULL,
      1.199460,
      NULL,
      2.241452,
      0.797031,
      34.586484,
      NULL,
      0.743367,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.802870,
      0,
      0,
      0.147245,
      0,
      5,
      3.130125,
      1,
      NULL,
      0,
      1,
      NULL,
      1.411749,
      0,
      NULL,
      0,
      0,
      NULL,
      1.420483,
      0.785417,
      NULL,
      1,
      1,
      NULL,
      0,
      0.209616,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.444470,
      NULL,
      1,
      1.513944,
      NULL,
      1.609547,
      0.750468,
      NULL,
      0.367254,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.181866,
      NULL,
      1.768768,
      NULL,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      15.311747,
      NULL,
      4,
      2.585156,
      5.471785,
      '44402',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.360377,
      '',
      '',
      '');
commit;
end;
/


