set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9803416';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      0,
      0.589585,
      3.883950,
      1.608472,
      NULL,
      3,
      0,
      '012',
      '31011031',
      62,
      NULL,
      '4232342',
      3.164674,
      1.469572,
      2,
      1,
      '2144',
      1,
      1.443917,
      NULL,
      NULL,
      ' 5- 1-1981',
      NULL,
      5,
      NULL,
      1,
      1,
      '10-10-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '11- 8-2001',
      0.625155,
      1,
      1,
      0.206622,
      0,
      0.359102,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      9.083442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.151708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      4,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      0.983105,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.980533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      3.315679,
      NULL,
      NULL,
      NULL,
      0.206866,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      3.913389,
      0,
      1,
      NULL,
      1,
      0.909003,
      NULL,
      0.938067,
      0,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      ' 7-20-1996',
      NULL,
      ' 0- 5-2003',
      9.110349,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.333341,
      1.116773,
      2.030264,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.567140,
      7,
      0.222935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896759,
      1.586408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.527714,
      1.664565,
      1.840633,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.288060,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022760,
      1,
      2,
      3,
      NULL,
      3,
      3,
      2,
      2,
      3,
      0,
      NULL,
      2.591265,
      1.432631,
      NULL,
      NULL,
      NULL,
      0,
      0.564406,
      0,
      NULL,
      0.359498,
      0.689915,
      0,
      0,
      0.120545,
      0,
      0,
      0.555875,
      NULL,
      1.958866,
      8,
      NULL,
      0,
      11,
      10.916676,
      2.833129,
      0,
      3.134886,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.761964,
      68,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '42414',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      6,
      56,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.761866,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.658632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354452,
      1.520574,
      0,
      1.367893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396059,
      NULL,
      NULL,
      1.776934,
      1,
      1,
      4.216485,
      NULL,
      NULL,
      0,
      0.008595,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.623713,
      1.664235,
      1.538965,
      0.749080,
      NULL,
      NULL,
      0.737571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706520,
      NULL,
      NULL,
      1.910984,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.718947,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622802,
      NULL,
      NULL,
      NULL,
      0.575295,
      NULL,
      NULL,
      1.447820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518610,
      NULL,
      NULL,
      0.388564,
      NULL,
      NULL,
      1.075208,
      NULL,
      NULL,
      0.447023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.588693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.703963,
      3,
      1.314102,
      1,
      2.379843,
      0,
      7.702013,
      5.824334,
      0.830918,
      1.650188,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.951762,
      3.115156,
      0,
      NULL,
      2.378458,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      3,
      3.523654,
      1.287271,
      2.095212,
      2,
      2.324783,
      3,
      0,
      NULL,
      3.311582,
      0,
      7,
      7.689309,
      0,
      1.063814,
      NULL,
      NULL,
      0.889120,
      0,
      0.161844,
      1.868841,
      0.784745,
      1.987534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838369,
      1.708827,
      NULL,
      0,
      1.460928,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.474383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.876522,
      1,
      0,
      0,
      1.880857,
      NULL,
      0.373070,
      1.003761,
      1,
      1.926492,
      1,
      0,
      0.221410,
      NULL,
      1,
      0.591517,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      NULL,
      2,
      3,
      4.686813,
      0,
      NULL,
      1,
      0.126319,
      1.950594,
      NULL,
      0,
      0,
      NULL,
      1.293380,
      0.443348,
      NULL,
      1,
      1,
      NULL,
      1.976041,
      NULL,
      NULL,
      0.766928,
      1.556268,
      NULL,
      0,
      0.529081,
      NULL,
      NULL,
      0.721757,
      NULL,
      0.489036,
      0,
      NULL,
      1.227686,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.199127,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.950039,
      NULL,
      4,
      4,
      NULL,
      0,
      NULL,
      NULL,
      79,
      123,
      2,
      4.162935,
      0.707709,
      '23023',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


