set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1424132',
      0,
      1,
      2,
      1,
      NULL,
      1.251067,
      2,
      0,
      55.757268,
      ' 2-15-1986',
      95.686107,
      NULL,
      NULL,
      0.329884,
      NULL,
      ' 9- 5-1987',
      4,
      2.511062,
      154,
      113.446615,
      0,
      NULL,
      NULL,
      ' 3- 4-1995',
      2,
      0.346450,
      0.834816,
      1,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      10,
      6.060049,
      6.567614,
      NULL,
      3,
      NULL,
      1,
      0,
      9.879540,
      0.078034,
      0,
      0,
      0.453737,
      0.734291,
      1,
      1.297430,
      1,
      0,
      0,
      0.979605,
      2,
      0,
      2,
      0.127385,
      1,
      NULL,
      4,
      1,
      5,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      7.870253,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.818476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.523981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      0,
      NULL,
      2,
      0,
      3,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1.168806,
      1,
      0,
      1,
      0,
      1.656694,
      NULL,
      1.316759,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      2,
      1,
      5,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4,
      2,
      4,
      0,
      NULL,
      0,
      3,
      ' 8- 0-1997',
      265.062334,
      ' 6-20-1975',
      137.322937,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.083953,
      1,
      0,
      0,
      1.703397,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.004939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939835,
      0.872469,
      1.109003,
      0.696106,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      1,
      2,
      NULL,
      3,
      3,
      1,
      2.168778,
      2.366662,
      2.913008,
      1.836009,
      0.124316,
      9,
      1.730919,
      1,
      NULL,
      0.701204,
      0,
      0.205025,
      NULL,
      1,
      1,
      1,
      3,
      0.918884,
      2,
      0.045369,
      5,
      5,
      10,
      7,
      0.033499,
      1.716078,
      0,
      NULL,
      0.851880,
      2,
      23.471673,
      3,
      1.955495,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '20132',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.863057,
      12.896104,
      NULL,
      10.780023,
      2,
      27.969716,
      3,
      3,
      0,
      2,
      3,
      NULL,
      0.372000,
      NULL,
      NULL,
      2.791675,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.318414,
      2,
      1,
      NULL,
      NULL,
      3.942350,
      3.790707,
      0,
      0,
      NULL,
      NULL,
      0.100395,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.794634,
      NULL,
      1.900323,
      NULL,
      NULL,
      6.469150,
      5.283072,
      2,
      0,
      0.991506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142026,
      NULL,
      NULL,
      0.769318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.417737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.832130,
      1.929218,
      NULL,
      NULL,
      1.017741,
      NULL,
      NULL,
      NULL,
      0.955693,
      NULL,
      NULL,
      3,
      2.423191,
      1.915559,
      NULL,
      NULL,
      2.459521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.655301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.182211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.127755,
      5.968822,
      NULL,
      6,
      0.124780,
      NULL,
      3,
      3,
      1.462497,
      0.991621,
      1.823137,
      NULL,
      1,
      NULL,
      3,
      0,
      4.322359,
      2.834580,
      1.807148,
      0,
      1,
      2.266237,
      0,
      1,
      3.001355,
      0.145098,
      2.486190,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.830362,
      6.074560,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.010545,
      NULL,
      2.867650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.808852,
      0.488014,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.198405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091361,
      1.018089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972356,
      0.918666,
      NULL,
      NULL,
      NULL,
      1.573052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.205762,
      2.127098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789272,
      NULL,
      NULL,
      0.590215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.385426,
      15,
      8,
      1,
      NULL,
      NULL,
      1.266510,
      NULL,
      NULL,
      0.306716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.090822,
      NULL,
      0,
      NULL,
      0,
      0.286019,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.078802,
      0.932427,
      0.079895,
      0.413968,
      NULL,
      1,
      0,
      0,
      1,
      0.909494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      2,
      NULL,
      2,
      0,
      NULL,
      2.016318,
      2,
      1,
      NULL,
      NULL,
      0.595056,
      0.618628,
      0.592764,
      3.169118,
      1.712217,
      3,
      3.317678,
      NULL,
      1,
      0.459762,
      NULL,
      3.323857,
      2,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      0.414823,
      NULL,
      2.125938,
      NULL,
      0.056295,
      0,
      1,
      2,
      1.405435,
      1,
      1,
      1,
      NULL,
      3.588720,
      1.128078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378488,
      0,
      1.968900,
      0,
      1.363528,
      NULL,
      1,
      NULL,
      2,
      2.820766,
      2.291441,
      NULL,
      36.023152,
      108,
      4,
      NULL,
      NULL,
      '23024',
      '',
      '',
      0,
      '10402',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


