set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9846199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      1,
      4,
      1,
      2,
      2,
      7,
      1,
      '203',
      '2',
      2.500972,
      NULL,
      NULL,
      NULL,
      0.738930,
      NULL,
      2,
      '3244',
      NULL,
      0,
      NULL,
      NULL,
      ' 4- 0-1981',
      31,
      NULL,
      NULL,
      2,
      0.784129,
      ' 6-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-11-1988',
      ' 3-26-2001',
      NULL,
      NULL,
      1.487073,
      NULL,
      1.139111,
      1,
      2,
      3,
      1.887391,
      NULL,
      NULL,
      NULL,
      11,
      4.503249,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0.043755,
      1.165779,
      0,
      1,
      1.268773,
      1.636446,
      2,
      3,
      2,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      0.434097,
      NULL,
      NULL,
      1.596385,
      NULL,
      NULL,
      0,
      1,
      0.891374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      NULL,
      4,
      5,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.098428,
      0,
      1,
      0,
      1,
      5,
      0,
      5,
      NULL,
      0,
      0,
      5,
      5,
      4,
      1,
      0,
      4,
      NULL,
      4,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3,
      ' 2-20-1994',
      124,
      ' 9-29-2002',
      4,
      0.601989,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233895,
      NULL,
      9,
      4.330188,
      0.046103,
      3.547038,
      0.384496,
      NULL,
      NULL,
      NULL,
      1.103239,
      0.847169,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      1.221409,
      0.050894,
      3.105367,
      NULL,
      NULL,
      1.752718,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876849,
      0.935351,
      3,
      3,
      2,
      1,
      2,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      2.076978,
      NULL,
      0.015028,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      5.959793,
      NULL,
      1.697627,
      NULL,
      3,
      3.953539,
      NULL,
      4,
      NULL,
      NULL,
      4,
      1,
      2.482757,
      0,
      NULL,
      6,
      2,
      0,
      3,
      24,
      3,
      NULL,
      NULL,
      NULL,
      8,
      10,
      0,
      1,
      2.097341,
      '40242',
      NULL,
      '',
      2,
      '02203',
      '',
      NULL,
      2,
      '4420',
      '',
      '',
      2.116800,
      NULL,
      10.207738,
      42.343750,
      0,
      24,
      4,
      3,
      NULL,
      0,
      3.307580,
      2.625552,
      1.341151,
      0,
      0,
      0.539286,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.388452,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.857529,
      0,
      2.923400,
      0,
      NULL,
      NULL,
      0.408218,
      NULL,
      NULL,
      1.846476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      0.857722,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.254516,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.759829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.693983,
      NULL,
      0.219086,
      3,
      2,
      1,
      3,
      6.331453,
      0.821377,
      0,
      0.162411,
      1.820199,
      NULL,
      1.057898,
      NULL,
      NULL,
      5.818885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.769549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.603110,
      0.298263,
      0,
      NULL,
      NULL,
      2,
      2.766644,
      NULL,
      0.487431,
      NULL,
      0,
      1.354425,
      NULL,
      NULL,
      NULL,
      5,
      1.442774,
      NULL,
      1,
      0,
      3.695117,
      NULL,
      1,
      NULL,
      2.586487,
      NULL,
      1,
      0.899120,
      1,
      0.248683,
      0.564717,
      6,
      1.757635,
      4,
      NULL,
      1.759359,
      NULL,
      NULL,
      1,
      1.028295,
      0.083295,
      1,
      0.908731,
      1.223366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974812,
      1,
      0,
      NULL,
      0,
      0,
      1.662447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756803,
      NULL,
      NULL,
      NULL,
      2.521039,
      12,
      NULL,
      1,
      NULL,
      5.955890,
      1,
      NULL,
      NULL,
      NULL,
      0.713417,
      1.754429,
      1.123821,
      NULL,
      NULL,
      1.540712,
      NULL,
      NULL,
      1.437792,
      NULL,
      NULL,
      289.635682,
      NULL,
      NULL,
      0,
      1.250666,
      NULL,
      NULL,
      NULL,
      0.932472,
      1,
      0.963202,
      1,
      0,
      1,
      NULL,
      1.693156,
      1,
      0.950912,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.849558,
      NULL,
      144,
      NULL,
      3.965956,
      NULL,
      1.001045,
      2.616207,
      3,
      4,
      NULL,
      1,
      NULL,
      0.282983,
      NULL,
      0.134458,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.810453,
      NULL,
      1.924847,
      NULL,
      0,
      NULL,
      1.946380,
      NULL,
      0.706099,
      3,
      0,
      1.654210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558591,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.630771,
      NULL,
      0,
      NULL,
      0.011823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599637,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200637,
      2.996929,
      NULL,
      NULL,
      NULL,
      0.589404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.718440,
      0.804656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      4.186713,
      1,
      3.319975,
      2,
      1,
      3,
      3.130169,
      3,
      0.998525,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222400,
      1,
      NULL,
      NULL,
      3.919720,
      NULL,
      0.514864,
      1.805833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952748,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728029,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38.794359,
      79.782027,
      NULL,
      4.617555,
      5.405229,
      '02402',
      '11243',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '4120',
      '',
      '');
commit;
end;
/


