set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1140423',
      3.665345,
      1.410969,
      5,
      0,
      '1404',
      2,
      NULL,
      NULL,
      NULL,
      ' 1-17-1998',
      NULL,
      NULL,
      4,
      3.639260,
      0,
      ' 3-22-1998',
      NULL,
      0,
      NULL,
      9,
      0,
      '10-22-1997',
      ' 9-21-1978',
      ' 8- 5-1986',
      0,
      0.820477,
      1.824052,
      1,
      1,
      1,
      3,
      1,
      1.566180,
      NULL,
      4,
      17.212002,
      5,
      NULL,
      27.229469,
      1,
      18.400287,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1.494925,
      0.515709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1.407356,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      4,
      1,
      NULL,
      4,
      1,
      5,
      3,
      1,
      2,
      NULL,
      0,
      1,
      3,
      5,
      2,
      4,
      1,
      1,
      5,
      1,
      NULL,
      2,
      5,
      3.250715,
      ' 8- 8-2003',
      99.755273,
      ' 7-13-1993',
      165.545034,
      2,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      22,
      0,
      1.484284,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694033,
      1,
      3.109502,
      0,
      2.364485,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971897,
      0.683684,
      1.099057,
      1.444343,
      NULL,
      0,
      2,
      30,
      0,
      0.394996,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      2,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.129572,
      1,
      0,
      1.682018,
      3.975308,
      0,
      0.491798,
      0.049181,
      1.718400,
      0.582179,
      NULL,
      0.192924,
      1.494056,
      0,
      1,
      1.999834,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      75,
      NULL,
      3,
      1,
      1,
      '20310',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      6,
      52.589838,
      0.002792,
      42,
      5.222240,
      1,
      0,
      0.237457,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3.625370,
      0.282620,
      NULL,
      NULL,
      0.710712,
      NULL,
      NULL,
      2,
      3.568584,
      NULL,
      0,
      NULL,
      NULL,
      0.673373,
      NULL,
      NULL,
      0.783010,
      NULL,
      NULL,
      0.584026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      2.745905,
      1,
      0.881075,
      NULL,
      NULL,
      NULL,
      2,
      0.635986,
      2.824382,
      0.837090,
      NULL,
      1.411635,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.832119,
      NULL,
      3.263488,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.451880,
      0,
      NULL,
      0.322983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420010,
      1.983114,
      2,
      2.097548,
      NULL,
      NULL,
      0.499028,
      NULL,
      NULL,
      0.214458,
      NULL,
      NULL,
      0.622155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.190572,
      NULL,
      NULL,
      0.306739,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.528271,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.110126,
      3.890054,
      0.283008,
      NULL,
      NULL,
      1.630168,
      2.519194,
      2.091235,
      1.907798,
      2.293053,
      NULL,
      1.997509,
      NULL,
      NULL,
      1.857229,
      NULL,
      NULL,
      1.064691,
      3.205367,
      2.685194,
      0.799016,
      3.658294,
      1,
      1.421063,
      0,
      NULL,
      NULL,
      2,
      1,
      3.163613,
      0.763658,
      NULL,
      2,
      3.599041,
      0.979680,
      1,
      NULL,
      NULL,
      1.236922,
      2.694913,
      4.734645,
      2,
      NULL,
      5.768988,
      0.153306,
      3,
      3,
      1.309222,
      0,
      0.813541,
      0.424573,
      1,
      0.931613,
      NULL,
      NULL,
      0.464975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798696,
      NULL,
      NULL,
      1.804850,
      NULL,
      NULL,
      1.765012,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.073788,
      NULL,
      1.667796,
      1,
      3.842486,
      1,
      NULL,
      4.532141,
      1.156257,
      NULL,
      NULL,
      11.724485,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1.383212,
      NULL,
      NULL,
      0.279171,
      0.604907,
      NULL,
      NULL,
      3.950717,
      0.171513,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      19.188256,
      NULL,
      NULL,
      13.190679,
      2.493141,
      NULL,
      NULL,
      1.313760,
      1.672060,
      NULL,
      NULL,
      2.177665,
      3.588179,
      NULL,
      NULL,
      12,
      6.211646,
      NULL,
      NULL,
      3.553931,
      NULL,
      NULL,
      NULL,
      3.152247,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      6.914818,
      NULL,
      NULL,
      0,
      0.898483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.188913,
      42,
      NULL,
      0.269167,
      NULL,
      NULL,
      0.102487,
      NULL,
      NULL,
      0.990180,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.383130,
      NULL,
      0,
      0.189016,
      1.273134,
      0,
      1,
      1.346659,
      1.443200,
      1.546520,
      0,
      NULL,
      NULL,
      1.193982,
      0,
      0.160801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.391369,
      0.499020,
      3.012880,
      3,
      10.557011,
      1.890987,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1.950367,
      NULL,
      1,
      0.796465,
      NULL,
      0,
      0.701714,
      NULL,
      1.075085,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.386947,
      0,
      NULL,
      0,
      1.869677,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.359434,
      0.215985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.391232,
      NULL,
      0.141736,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894412,
      NULL,
      NULL,
      8.494787,
      55.056955,
      1,
      0,
      NULL,
      '31211',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


