set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3431341',
      3,
      0,
      1,
      2,
      NULL,
      NULL,
      0.931026,
      NULL,
      NULL,
      ' 1-12-1999',
      64,
      NULL,
      5,
      1.211753,
      1.746254,
      ' 3- 3-1996',
      NULL,
      2,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      ' 9-19-1994',
      3,
      2.138987,
      1.870606,
      NULL,
      1.271436,
      NULL,
      1,
      1.628457,
      NULL,
      4,
      1,
      0,
      3,
      13,
      20.228045,
      NULL,
      18,
      5,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      3.152501,
      1,
      0,
      4,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      6.008118,
      0,
      1,
      NULL,
      NULL,
      0.819330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      3,
      0,
      1,
      0,
      NULL,
      3,
      2,
      4,
      1,
      5,
      5,
      1,
      2,
      1,
      NULL,
      ' 4-19-1992',
      129,
      ' 4- 0-1993',
      185.370889,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.137425,
      1,
      0,
      NULL,
      NULL,
      2.811474,
      2,
      NULL,
      3,
      1.195740,
      3,
      NULL,
      3.494202,
      0.414485,
      0,
      2,
      0.009282,
      4.334527,
      0,
      6,
      NULL,
      0.937085,
      NULL,
      NULL,
      0,
      6.645585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      23.851079,
      0.405731,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.722288,
      2,
      2,
      0,
      0,
      3,
      2,
      NULL,
      3,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      0.146244,
      NULL,
      0,
      0,
      0.378258,
      0,
      0,
      1.693140,
      0,
      0.833956,
      0,
      1,
      NULL,
      1.518077,
      0,
      9.251593,
      11.834802,
      7,
      11,
      0.756548,
      1,
      NULL,
      1.116549,
      0.006546,
      2.904072,
      3,
      3.494920,
      NULL,
      NULL,
      3,
      NULL,
      32,
      60,
      NULL,
      0,
      0.814339,
      1,
      '40212',
      '',
      '',
      0.215593,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      16.609434,
      15,
      37.962266,
      2.164367,
      NULL,
      4,
      1.648954,
      1,
      0.934708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.162148,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.138547,
      NULL,
      NULL,
      0.879266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.662554,
      2.728477,
      2,
      0,
      0.320388,
      NULL,
      NULL,
      NULL,
      0.199449,
      NULL,
      NULL,
      NULL,
      2.938531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.487011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213057,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.195696,
      4.757547,
      0,
      0.137521,
      NULL,
      NULL,
      NULL,
      1.976756,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.120050,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.461398,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.050344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842905,
      NULL,
      NULL,
      0.455954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.850998,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.670654,
      7,
      0,
      1.478614,
      2.174367,
      NULL,
      1.773655,
      3.429083,
      1.023398,
      0.926357,
      NULL,
      NULL,
      2.698320,
      2.425885,
      2.455135,
      4,
      7.579866,
      1,
      4,
      4.597450,
      1.468505,
      NULL,
      0,
      0,
      1.287459,
      0.184452,
      1.955101,
      NULL,
      1.055715,
      3.686298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266013,
      NULL,
      NULL,
      1.631086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1.734243,
      NULL,
      NULL,
      1.164236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179888,
      NULL,
      NULL,
      NULL,
      0.465748,
      NULL,
      NULL,
      NULL,
      1.052741,
      NULL,
      NULL,
      NULL,
      1.342392,
      NULL,
      NULL,
      NULL,
      3.217637,
      NULL,
      NULL,
      NULL,
      1.132178,
      NULL,
      NULL,
      NULL,
      0.241568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.491751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562544,
      NULL,
      NULL,
      NULL,
      1.697106,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.649709,
      3,
      NULL,
      0.167719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.746611,
      0.164364,
      0,
      0,
      0,
      0,
      0,
      1,
      0.688741,
      0,
      0,
      1,
      NULL,
      1.003099,
      0.509722,
      0,
      0,
      1.754513,
      1.409328,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      3.096319,
      3,
      1,
      5,
      2,
      2.062869,
      0,
      1,
      1.820432,
      NULL,
      0,
      0.146511,
      NULL,
      0,
      0.770977,
      NULL,
      0.836234,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.584485,
      NULL,
      2,
      1,
      NULL,
      0.294579,
      0.951444,
      NULL,
      1,
      0.591364,
      NULL,
      NULL,
      0.238161,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0.880640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118433,
      NULL,
      0.843903,
      NULL,
      NULL,
      NULL,
      2,
      4,
      6,
      1.783920,
      NULL,
      NULL,
      NULL,
      9.019940,
      5,
      1.416865,
      NULL,
      '32333',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.521455,
      '',
      NULL,
      '');
commit;
end;
/


