set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      '1020',
      2,
      0.803314,
      NULL,
      NULL,
      NULL,
      20.786823,
      NULL,
      3,
      1.335427,
      1.163090,
      ' 2- 9-1996',
      32.021941,
      NULL,
      133.731243,
      44.709635,
      0,
      '11-22-1987',
      NULL,
      '10- 1-1983',
      3,
      0,
      3,
      NULL,
      1.355828,
      1.591900,
      3,
      0,
      1,
      12,
      2,
      6,
      5.010949,
      33,
      31,
      4,
      13,
      NULL,
      0,
      NULL,
      1.669231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      3,
      1,
      1,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      0.609738,
      NULL,
      NULL,
      0.476919,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1.441956,
      1,
      2,
      1.836292,
      0.077161,
      NULL,
      NULL,
      1.171868,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.792938,
      1,
      1,
      NULL,
      1,
      1.926145,
      NULL,
      NULL,
      1,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      0,
      1,
      4,
      3,
      5,
      3,
      2,
      NULL,
      0,
      NULL,
      4.111289,
      2,
      '11-16-1995',
      22,
      ' 9-25-1989',
      NULL,
      2.912031,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.569256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      13.512935,
      NULL,
      1.595767,
      2,
      1.902480,
      0,
      NULL,
      1.808687,
      0.310563,
      0,
      0,
      2,
      NULL,
      3.938156,
      3,
      1,
      2,
      5.144086,
      9,
      NULL,
      1,
      5.998052,
      0.210615,
      NULL,
      NULL,
      0.288696,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.231696,
      1.324384,
      1.726565,
      1.829772,
      0,
      1,
      2,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074836,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      2.343797,
      1.822903,
      1.259624,
      2,
      3,
      1.390936,
      1,
      0,
      1.256023,
      1,
      1.133010,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.460571,
      1,
      11.294183,
      3,
      NULL,
      11.502495,
      3.000170,
      NULL,
      1,
      NULL,
      3.488238,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      26,
      48,
      51.638414,
      4,
      1,
      1,
      NULL,
      '',
      '',
      1.385712,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.609242,
      NULL,
      64,
      14,
      3.321373,
      5.279327,
      5,
      1.466312,
      0,
      0.665053,
      NULL,
      NULL,
      1.506783,
      NULL,
      NULL,
      1.498592,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.382281,
      NULL,
      NULL,
      0.162748,
      2.948423,
      2,
      1,
      NULL,
      NULL,
      0.962213,
      NULL,
      NULL,
      0.344159,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770320,
      NULL,
      NULL,
      NULL,
      4.768442,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015631,
      0,
      1,
      NULL,
      NULL,
      0.726112,
      NULL,
      NULL,
      2,
      4.107238,
      4,
      0,
      0.485225,
      NULL,
      NULL,
      NULL,
      2,
      1.191745,
      3.467037,
      2,
      0.548945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.775914,
      NULL,
      NULL,
      2.488315,
      2.148780,
      0,
      3,
      5,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.185258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.451367,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.405490,
      NULL,
      2,
      1.985533,
      NULL,
      NULL,
      0.510236,
      3,
      3.528387,
      0,
      2,
      0,
      0.699495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.139542,
      1,
      0,
      1.320347,
      1,
      3.237667,
      6.889648,
      5,
      1.815388,
      0,
      1,
      0.948466,
      0,
      2,
      2,
      2,
      2,
      0,
      1.976762,
      NULL,
      2,
      2.456782,
      3,
      4.259741,
      1.941525,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.072507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177284,
      NULL,
      NULL,
      1.108150,
      NULL,
      NULL,
      1.930848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.216867,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.188168,
      0,
      2,
      0,
      1,
      NULL,
      5,
      7.205343,
      NULL,
      NULL,
      4.098126,
      1.924750,
      NULL,
      NULL,
      2,
      0.679473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.820891,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.357535,
      2,
      NULL,
      NULL,
      18.438329,
      2,
      NULL,
      NULL,
      0,
      1.459866,
      NULL,
      NULL,
      2,
      3.867724,
      NULL,
      NULL,
      9,
      0.608522,
      NULL,
      NULL,
      1.886992,
      1.784465,
      NULL,
      NULL,
      0.118211,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.676434,
      NULL,
      NULL,
      0.554412,
      3,
      NULL,
      NULL,
      4.593864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614531,
      NULL,
      NULL,
      2,
      0,
      7.249711,
      1.175810,
      NULL,
      NULL,
      2,
      18.710800,
      30.138945,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.754815,
      NULL,
      1,
      1,
      NULL,
      0,
      1.731913,
      0,
      1,
      0.027645,
      NULL,
      1.924726,
      0,
      1.382058,
      NULL,
      0,
      0,
      1.910150,
      1.998002,
      0.772370,
      0,
      1.602484,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      5,
      3.107300,
      1.048604,
      NULL,
      0,
      1,
      0.371868,
      1,
      1.776538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.899342,
      NULL,
      3,
      0.578122,
      NULL,
      1.139690,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.631239,
      NULL,
      NULL,
      1.874546,
      0,
      NULL,
      1.867899,
      0.295422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109605,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      61,
      106,
      NULL,
      1,
      1.146289,
      '42123',
      NULL,
      '',
      0.505155,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


