set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038736';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '1130240',
      2,
      0.640417,
      0,
      NULL,
      '4310',
      NULL,
      1,
      NULL,
      NULL,
      ' 8- 6-1974',
      27,
      NULL,
      NULL,
      2,
      6,
      NULL,
      28,
      1,
      94,
      116,
      2,
      ' 4- 9-2001',
      ' 1-27-1980',
      ' 1-24-1985',
      2.972813,
      0.712253,
      0,
      0,
      NULL,
      0,
      3,
      0.065104,
      1,
      NULL,
      0,
      15,
      NULL,
      20.262307,
      19,
      0,
      8.723437,
      3,
      2,
      4.267975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.345397,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      3,
      NULL,
      0,
      0,
      0,
      1.313219,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.776706,
      1.706214,
      0,
      1,
      2.339380,
      NULL,
      0.139223,
      NULL,
      0,
      0,
      1,
      3,
      0,
      NULL,
      1,
      0.038559,
      0,
      0,
      NULL,
      11,
      0,
      2,
      1.154753,
      0.925298,
      NULL,
      NULL,
      1.904755,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      2,
      0,
      3,
      0,
      5,
      2,
      0,
      1,
      NULL,
      1,
      1,
      4,
      0,
      5,
      4,
      1,
      0,
      2,
      1,
      2,
      3,
      0,
      2.886311,
      1.974040,
      ' 7-28-1998',
      137.585010,
      ' 9-22-1991',
      12,
      1,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2,
      0,
      2,
      4,
      3,
      4,
      4,
      1,
      NULL,
      0.858343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.183116,
      0.297573,
      1,
      NULL,
      0,
      1,
      0.515666,
      0.864690,
      10.662817,
      5,
      1.900020,
      NULL,
      2,
      0.624856,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4.723606,
      8,
      NULL,
      0,
      3,
      1,
      1.374772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246153,
      2,
      0.181117,
      NULL,
      0,
      1,
      1,
      NULL,
      15,
      0,
      1.467820,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.410607,
      0,
      0,
      1,
      3,
      2,
      3,
      1,
      NULL,
      3,
      1,
      1.751303,
      3.742428,
      1.357929,
      0.369401,
      NULL,
      0,
      1,
      0.625738,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.206266,
      0.886270,
      NULL,
      0.592866,
      3.870377,
      0.188078,
      NULL,
      3,
      0,
      3.339101,
      NULL,
      1.060884,
      2.696640,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      20,
      46,
      NULL,
      0,
      0,
      2,
      '23042',
      '02234',
      NULL,
      0,
      '',
      '',
      '',
      1.397938,
      '',
      '',
      '',
      0.808415,
      27.677119,
      42,
      21.300469,
      NULL,
      NULL,
      1.628711,
      2.675879,
      4,
      0,
      NULL,
      0.152103,
      NULL,
      NULL,
      NULL,
      1.583102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.521149,
      NULL,
      NULL,
      3.051304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.701016,
      0,
      2,
      0.176269,
      0.922623,
      NULL,
      3.294746,
      NULL,
      0,
      1,
      3.165639,
      3.778772,
      1.115924,
      NULL,
      2.434767,
      1.128698,
      2.281832,
      3.509992,
      1,
      1,
      2.943258,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954754,
      NULL,
      NULL,
      0.077867,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.126571,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.799399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.896060,
      3.640041,
      NULL,
      0.076874,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.931028,
      NULL,
      NULL,
      0.664406,
      NULL,
      0,
      NULL,
      2.995991,
      2.833613,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736594,
      NULL,
      2.108790,
      2.147968,
      NULL,
      6.134226,
      2,
      1,
      1,
      3.669878,
      NULL,
      NULL,
      3,
      1,
      0,
      0.859258,
      0,
      0.751279,
      NULL,
      NULL,
      NULL,
      1.043002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.437154,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.588567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.772265,
      1,
      0.063461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.721452,
      NULL,
      NULL,
      NULL,
      3.250101,
      NULL,
      NULL,
      NULL,
      1.610235,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.151800,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.045440,
      0.740124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.693993,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.217259,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.673890,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      0.435853,
      2,
      0,
      1,
      24,
      NULL,
      3.082190,
      24.491261,
      NULL,
      1.871597,
      NULL,
      NULL,
      1.310488,
      NULL,
      NULL,
      1,
      NULL,
      2.527802,
      0.246084,
      NULL,
      NULL,
      1.562105,
      NULL,
      1.293506,
      0.628386,
      NULL,
      1.706128,
      0,
      0,
      0,
      0.427525,
      1,
      0,
      0,
      3,
      0,
      NULL,
      1.222639,
      1.388793,
      1,
      0,
      0.890918,
      1,
      NULL,
      0,
      0,
      0.311191,
      1,
      1.337721,
      0,
      0,
      3.561953,
      0,
      NULL,
      8.085761,
      29.876993,
      3.624288,
      3.839419,
      3,
      NULL,
      1.779268,
      NULL,
      4.462727,
      1.059604,
      NULL,
      2.915312,
      1.638508,
      NULL,
      0,
      NULL,
      0,
      0.148373,
      NULL,
      NULL,
      0.398548,
      0,
      0.328708,
      NULL,
      0,
      1.595059,
      0,
      0,
      1.196626,
      0.559667,
      1.100451,
      NULL,
      0,
      1,
      1,
      0.717964,
      NULL,
      2.385338,
      NULL,
      2,
      NULL,
      1.649547,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.829065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611439,
      NULL,
      1.158020,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926290,
      0.482130,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488368,
      NULL,
      1,
      NULL,
      0,
      0.183072,
      0.331284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.921052,
      0,
      1.628089,
      2.169560,
      1,
      0.850661,
      NULL,
      400.936821,
      1.911178,
      3,
      2,
      3.619265,
      3,
      2.843821,
      2,
      1,
      26.555716,
      NULL,
      3,
      0.601817,
      2,
      5,
      0,
      1,
      2,
      0,
      NULL,
      1.450425,
      0,
      0,
      12.672456,
      NULL,
      NULL,
      0.989775,
      1.813800,
      0.108411,
      1,
      0,
      0,
      0.918371,
      1,
      0,
      1,
      0,
      1.852079,
      NULL,
      NULL,
      1.156840,
      0.286023,
      1,
      0,
      1,
      1.305959,
      0.897597,
      0.138054,
      1,
      NULL,
      0,
      0.826557,
      0.349885,
      NULL,
      NULL,
      0,
      1.612910,
      NULL,
      1.598224,
      NULL,
      2.805814,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771924,
      NULL,
      1.252952,
      1,
      1,
      0,
      3,
      2,
      0,
      1.748600,
      NULL,
      NULL,
      NULL,
      77.496204,
      2,
      1.729658,
      2,
      '40411',
      '31334',
      '02443',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


