set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2232403',
      NULL,
      1.711451,
      2,
      3,
      '4213',
      1,
      1.942068,
      NULL,
      NULL,
      ' 7-23-1991',
      35,
      NULL,
      NULL,
      NULL,
      1.635358,
      ' 5- 4-2003',
      11.671295,
      NULL,
      216,
      86,
      NULL,
      ' 9-29-1987',
      NULL,
      ' 6-15-1997',
      0.242152,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      1,
      4,
      5,
      15.055593,
      NULL,
      21,
      22.264790,
      5,
      6,
      2,
      2,
      4.439744,
      0.275797,
      2,
      0,
      0,
      0,
      0.146626,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      5,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      5,
      0,
      0,
      0,
      7.311290,
      1,
      1,
      NULL,
      NULL,
      0.827396,
      NULL,
      NULL,
      1.156848,
      NULL,
      NULL,
      5,
      1,
      0.824274,
      0,
      0.752373,
      1.546983,
      1.725002,
      0,
      0.104462,
      1.035446,
      1,
      0,
      1.223779,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2,
      5,
      1,
      1,
      0,
      1,
      0.917432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      2,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.564936,
      NULL,
      1.644656,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      2,
      1,
      2,
      1,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      5,
      5,
      5,
      6,
      3,
      ' 2-17-1992',
      13,
      ' 9-21-1983',
      NULL,
      1.083904,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      4,
      1,
      NULL,
      0.832966,
      3,
      3.098728,
      3,
      1,
      0.314378,
      NULL,
      NULL,
      NULL,
      2.734790,
      NULL,
      0.556886,
      1.318771,
      6,
      1.299913,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.352603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681117,
      2.083315,
      1,
      3.890341,
      NULL,
      1.654671,
      1.583783,
      NULL,
      83.213951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1,
      0,
      2,
      1,
      2,
      2,
      0,
      3.511225,
      2.900933,
      2.327217,
      1.584224,
      0.466754,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0.493041,
      NULL,
      0,
      0,
      1,
      3,
      2,
      1.994782,
      3.937247,
      NULL,
      2.889652,
      1,
      NULL,
      1,
      NULL,
      1.081803,
      NULL,
      1,
      2.344089,
      NULL,
      5,
      0,
      NULL,
      NULL,
      16,
      5,
      58.572159,
      4,
      0,
      1.407826,
      '44102',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.860540,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.809543,
      3,
      NULL,
      0.716349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      21,
      0.476659,
      NULL,
      1.833007,
      1,
      NULL,
      1.517377,
      NULL,
      0,
      0.994221,
      0,
      0.818315,
      NULL,
      1,
      0.762800,
      1.114518,
      0.976245,
      0.764724,
      0.720282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3,
      1.176919,
      NULL,
      0,
      4,
      3.856218,
      1,
      NULL,
      0.287445,
      0.420408,
      NULL,
      0,
      0,
      NULL,
      0.209926,
      0.630370,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.132669,
      NULL,
      NULL,
      1.047747,
      NULL,
      NULL,
      1.480748,
      1.171172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.874208,
      NULL,
      1.733041,
      1.513987,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.304988,
      NULL,
      0.112583,
      NULL,
      2.141443,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      15,
      2,
      NULL,
      0.237517,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.469893,
      NULL,
      NULL,
      22.618114,
      150,
      1,
      0,
      NULL,
      '41134',
      '',
      NULL,
      2,
      '00403',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


