set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8123228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3344012',
      2.347121,
      0,
      0,
      3,
      '1031',
      0,
      NULL,
      3.681516,
      16,
      ' 4- 7-1994',
      4.224551,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-20-1988',
      17.610846,
      0,
      291.768122,
      134.346967,
      1,
      ' 4-16-1998',
      ' 8- 7-1975',
      NULL,
      0.450629,
      NULL,
      0.896025,
      0.362862,
      0.717101,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.825850,
      NULL,
      38,
      130,
      3,
      16.424600,
      3,
      2,
      5,
      0,
      1,
      1,
      1.047577,
      0.918272,
      0.437800,
      NULL,
      0,
      1,
      1,
      1,
      5,
      1,
      4,
      0,
      NULL,
      NULL,
      5,
      1,
      5,
      1,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      0.652136,
      NULL,
      NULL,
      0.933299,
      NULL,
      NULL,
      0,
      NULL,
      2.665279,
      1,
      0,
      NULL,
      1.355820,
      NULL,
      3.219678,
      0,
      NULL,
      1.704332,
      3,
      0.372159,
      1.750219,
      0.211900,
      1.489643,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1.370429,
      NULL,
      NULL,
      0.329564,
      NULL,
      NULL,
      0,
      3,
      4,
      0,
      3,
      4,
      4,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.973943,
      NULL,
      1.439577,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      0,
      0,
      3,
      NULL,
      5,
      3,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      1,
      3,
      11,
      2,
      ' 1-20-1997',
      77,
      ' 8- 8-1986',
      16,
      2.938582,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      NULL,
      0,
      3.947469,
      4.741881,
      1.628344,
      1,
      NULL,
      8.765654,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.000230,
      NULL,
      1,
      0.929720,
      NULL,
      NULL,
      2,
      2.595028,
      NULL,
      NULL,
      NULL,
      3,
      0.796777,
      1.594605,
      NULL,
      NULL,
      3,
      3,
      3,
      3,
      2,
      2,
      3,
      2,
      0,
      1.092890,
      2.893158,
      0.933300,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      9.053945,
      2,
      0,
      1,
      NULL,
      2.644228,
      5.603826,
      1.531673,
      NULL,
      1,
      2.830148,
      1.477472,
      3,
      NULL,
      3.760251,
      NULL,
      3,
      1.278801,
      NULL,
      14,
      NULL,
      56,
      1,
      0,
      2,
      '23003',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      0,
      117,
      NULL,
      3.919036,
      4.377008,
      0.151384,
      4.934507,
      3,
      0,
      NULL,
      NULL,
      0.566432,
      NULL,
      NULL,
      3,
      3,
      2,
      1.690134,
      3,
      1,
      1.387757,
      3.370196,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      0.742998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.549010,
      8,
      3.229270,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.452377,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.566658,
      NULL,
      NULL,
      1,
      0.328032,
      1.050040,
      0,
      0,
      2,
      0,
      2,
      3.604681,
      1,
      1.401655,
      1.675536,
      NULL,
      0.458885,
      0.004694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.046894,
      2.752992,
      8,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354252,
      0,
      1,
      1,
      NULL,
      NULL,
      0.840057,
      NULL,
      NULL,
      NULL,
      4,
      1.307651,
      0.654737,
      3.869616,
      3,
      NULL,
      2.873566,
      0,
      8,
      4.042926,
      0.082130,
      0.061838,
      NULL,
      NULL,
      0.023980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.209696,
      NULL,
      NULL,
      1.472691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029199,
      NULL,
      NULL,
      3,
      NULL,
      0.302678,
      7.508821,
      0.473235,
      NULL,
      5,
      9,
      2.117181,
      NULL,
      4.506109,
      5.966357,
      NULL,
      1.987530,
      0.952055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      3.212118,
      2,
      1.899512,
      1.818201,
      1.698395,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.451819,
      NULL,
      5.210128,
      NULL,
      4.300201,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      0.471123,
      1,
      2.605891,
      NULL,
      0,
      0.445229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477045,
      NULL,
      NULL,
      0.387565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305177,
      NULL,
      NULL,
      1.379680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.758897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.923404,
      NULL,
      3.606545,
      1.230213,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.617579,
      NULL,
      NULL,
      NULL,
      0.032401,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500185,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.207130,
      NULL,
      NULL,
      NULL,
      3.538651,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.140413,
      1,
      NULL,
      NULL,
      3.302232,
      1.868673,
      NULL,
      NULL,
      0.118175,
      NULL,
      NULL,
      NULL,
      2.212405,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.946892,
      1,
      NULL,
      NULL,
      10.157618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692722,
      7.721568,
      25,
      NULL,
      NULL,
      NULL,
      0.154169,
      NULL,
      NULL,
      1.160965,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.021331,
      NULL,
      NULL,
      24,
      1.613653,
      0,
      NULL,
      1.601473,
      0.850218,
      0,
      0.435035,
      NULL,
      1.148935,
      1.738912,
      0.990150,
      1.592985,
      1.457965,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.705059,
      3,
      1.872718,
      2,
      2,
      1,
      NULL,
      NULL,
      3.314439,
      0.154317,
      0,
      1,
      1.790156,
      0,
      0,
      1,
      1,
      1.645711,
      1,
      1.608260,
      1.783237,
      1.807597,
      0.576732,
      1.619121,
      3.754437,
      3,
      2,
      0.627131,
      0,
      1.443179,
      3.903279,
      2,
      NULL,
      1,
      1.052916,
      2,
      1,
      2.205312,
      NULL,
      1,
      1,
      0.158684,
      0,
      1,
      1.340635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.877106,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      2,
      0.769771,
      2,
      12.949352,
      42,
      NULL,
      1,
      3,
      '04033',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.551100,
      '',
      '',
      '');
commit;
end;
/


