set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908405';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '2131433',
      NULL,
      NULL,
      3,
      3,
      '0014',
      1,
      1,
      NULL,
      NULL,
      ' 8-11-1990',
      NULL,
      NULL,
      0,
      3.773465,
      0,
      '10-29-1979',
      NULL,
      NULL,
      33.135925,
      54,
      2,
      NULL,
      ' 2-24-1997',
      '10-28-1978',
      0,
      2.456573,
      2.542415,
      1,
      1.997782,
      2,
      2,
      1.270273,
      0.681429,
      23.431182,
      2,
      16,
      NULL,
      22.687003,
      5,
      1,
      10.412882,
      2,
      NULL,
      7,
      0,
      0,
      0,
      1,
      1.274902,
      0.713184,
      1.134662,
      NULL,
      NULL,
      NULL,
      64,
      4,
      2,
      NULL,
      1,
      0,
      0,
      3,
      2,
      NULL,
      5,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      5,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1.817298,
      2.520670,
      NULL,
      0,
      1.199938,
      2,
      0.539533,
      3.558192,
      3,
      1,
      3,
      0.345742,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278512,
      5,
      0,
      NULL,
      4,
      0,
      NULL,
      1,
      1.001508,
      NULL,
      NULL,
      0.769836,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      3.456820,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3,
      2,
      0,
      5,
      2,
      0,
      4,
      2,
      1,
      NULL,
      3,
      5,
      0,
      4,
      5,
      NULL,
      2,
      2,
      1,
      1,
      2,
      3,
      3,
      5.512716,
      NULL,
      ' 4- 7-1993',
      NULL,
      ' 0- 8-1992',
      1663.130224,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      1,
      0.991183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.515352,
      NULL,
      0,
      5,
      1.578976,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.051866,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.675923,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      781,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      3,
      3,
      0,
      2,
      1,
      1,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      7,
      0.639035,
      0,
      0,
      0.594289,
      1.626278,
      NULL,
      0,
      1.937698,
      NULL,
      NULL,
      0.542500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969087,
      NULL,
      53,
      19,
      52,
      4,
      0.438348,
      1,
      '00033',
      '43332',
      NULL,
      1,
      '',
      '',
      '',
      3.283052,
      NULL,
      '',
      '',
      1.747747,
      4.994621,
      113,
      24,
      0,
      7.486609,
      4.542778,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.142628,
      1,
      3.154052,
      NULL,
      3.320467,
      0,
      1.075619,
      2,
      3.148353,
      NULL,
      0,
      0,
      1.367578,
      3,
      3,
      0,
      0.913229,
      1,
      1,
      1,
      0.153949,
      NULL,
      NULL,
      NULL,
      0.649117,
      2,
      0.894166,
      NULL,
      NULL,
      6,
      0,
      0.358829,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.936619,
      1,
      3,
      2,
      1.855363,
      1,
      1.976213,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.617147,
      3.879958,
      3,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.815028,
      1,
      3,
      1,
      3.109497,
      1.151510,
      NULL,
      NULL,
      0,
      1,
      2.018353,
      9,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.452349,
      2,
      2,
      NULL,
      NULL,
      1,
      0.297405,
      NULL,
      NULL,
      2,
      6,
      1,
      0.147571,
      8,
      1,
      1.808036,
      NULL,
      NULL,
      NULL,
      2.886300,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.773045,
      1.513638,
      3.290071,
      3,
      NULL,
      4,
      NULL,
      NULL,
      3.003656,
      0,
      3.250944,
      1.003320,
      NULL,
      NULL,
      2.033828,
      0,
      NULL,
      1.414166,
      1,
      1,
      2,
      3.645431,
      3.666933,
      9.258626,
      7.900481,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.174235,
      0.747638,
      NULL,
      1.880373,
      3.584580,
      2,
      0,
      0.868071,
      0.816442,
      7.259554,
      1,
      7,
      1.942135,
      3,
      0,
      1.627716,
      1,
      0.591059,
      0,
      1,
      1.290049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409076,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.893449,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.811742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.200513,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.178883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405300,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      11.207910,
      1,
      1,
      2.593084,
      154,
      150.826304,
      3,
      NULL,
      6,
      1.993952,
      NULL,
      NULL,
      3.737998,
      0,
      1.548469,
      3,
      NULL,
      NULL,
      2,
      5.770448,
      3.735206,
      NULL,
      NULL,
      1.652069,
      1.780005,
      NULL,
      1,
      0.419230,
      NULL,
      NULL,
      1.479341,
      1,
      1,
      1.608668,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.700243,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416381,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.777562,
      NULL,
      NULL,
      NULL,
      1.183319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619139,
      1,
      NULL,
      1.041694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472290,
      NULL,
      1.482141,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.283816,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.920640,
      NULL,
      1.579500,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.506522,
      NULL,
      NULL,
      NULL,
      0.683540,
      0.119320,
      1.329808,
      NULL,
      1.804448,
      NULL,
      1.509045,
      NULL,
      197.985066,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.522582,
      16.938819,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      13.851528,
      NULL,
      NULL,
      3.905051,
      2,
      7,
      2.882071,
      NULL,
      1.669153,
      1,
      0,
      NULL,
      1,
      0.593492,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.735638,
      NULL,
      0,
      0.459376,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.420637,
      NULL,
      1.311518,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.375838,
      1.031339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620684,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      4,
      NULL,
      NULL,
      0,
      NULL,
      38,
      21.200011,
      0,
      0.306669,
      3,
      '42040',
      '24240',
      '',
      1.926131,
      '',
      '',
      NULL,
      0,
      '14001',
      '',
      NULL);
commit;
end;
/


