set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9749389';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.627336,
      0,
      3,
      2,
      0,
      2,
      1,
      0.536996,
      '111',
      '42210320',
      NULL,
      61.108643,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.779433,
      NULL,
      NULL,
      ' 1-23-1977',
      77.105984,
      NULL,
      NULL,
      NULL,
      0,
      ' 9-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1977',
      ' 1-22-1989',
      ' 5- 5-1990',
      NULL,
      0,
      2.615308,
      2,
      1.734250,
      0.400320,
      0,
      0,
      NULL,
      19,
      7,
      19.193835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0.604288,
      NULL,
      0.815490,
      1.973729,
      1,
      0.711601,
      0,
      61,
      7,
      0,
      7,
      3,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1.469704,
      1,
      0.003261,
      0.721061,
      NULL,
      0.269160,
      1.463293,
      NULL,
      NULL,
      1,
      1,
      0.376181,
      0,
      0.453800,
      1.482227,
      1.534349,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.555120,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      2,
      3,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.643380,
      2,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      NULL,
      3,
      3,
      2,
      4,
      0,
      0,
      0,
      0,
      4,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      3,
      4,
      3,
      0,
      '10-20-1998',
      528.571006,
      NULL,
      95,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      1.292116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482271,
      0.609698,
      NULL,
      NULL,
      1.128898,
      1.646340,
      NULL,
      2.262390,
      1,
      3,
      0,
      NULL,
      3,
      1,
      0,
      1,
      6.948351,
      8,
      1.074104,
      0,
      3.579191,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.310109,
      0,
      0.765473,
      0.304484,
      0.276780,
      NULL,
      2,
      440.188556,
      NULL,
      0.909667,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      1,
      3,
      3,
      0,
      3,
      1,
      2,
      NULL,
      0.145723,
      NULL,
      3,
      1,
      0.209523,
      1,
      5.153644,
      NULL,
      0,
      NULL,
      NULL,
      0.176960,
      0.001854,
      1,
      0.497164,
      0,
      NULL,
      0.509950,
      1.262266,
      4.298144,
      8,
      7.616441,
      8.458919,
      NULL,
      0.775476,
      1.069903,
      0,
      NULL,
      2,
      NULL,
      NULL,
      24.926822,
      NULL,
      0,
      37,
      NULL,
      43,
      46.798353,
      0,
      5,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.532227,
      '',
      '',
      '',
      NULL,
      30.907000,
      NULL,
      11,
      1.258905,
      NULL,
      NULL,
      3.547960,
      3,
      3,
      0.010795,
      1,
      0.945069,
      NULL,
      NULL,
      0.646947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566041,
      NULL,
      NULL,
      1.973596,
      NULL,
      NULL,
      0.153070,
      2,
      1.841151,
      0.250178,
      NULL,
      NULL,
      NULL,
      2.167174,
      1.039863,
      NULL,
      NULL,
      NULL,
      0.738208,
      NULL,
      NULL,
      1.273144,
      NULL,
      NULL,
      4.903422,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.082243,
      NULL,
      NULL,
      NULL,
      2,
      0.310393,
      1.932164,
      2,
      3,
      2.516355,
      3.922579,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.759007,
      NULL,
      2.181903,
      0,
      3.214836,
      3.867500,
      2.249561,
      3,
      0.241524,
      1,
      NULL,
      3.594512,
      3,
      1,
      NULL,
      NULL,
      1.261836,
      NULL,
      NULL,
      0.326868,
      2,
      1.334227,
      NULL,
      4.020097,
      NULL,
      0,
      1.217437,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.847107,
      0.996279,
      0,
      NULL,
      NULL,
      3.687460,
      2,
      3,
      3,
      0,
      0,
      1.170987,
      NULL,
      NULL,
      2.621546,
      3,
      NULL,
      1.732568,
      1,
      0.349715,
      1.144262,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.059956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067686,
      NULL,
      NULL,
      1.141864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.971884,
      0.098867,
      0.887769,
      1,
      1.022754,
      1,
      2.452172,
      0.567849,
      NULL,
      NULL,
      4,
      3.322011,
      3.988038,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2.272456,
      3,
      0,
      NULL,
      2,
      10.442462,
      4,
      5,
      0,
      3,
      2.971618,
      3.174035,
      2.594184,
      0.856613,
      2.655087,
      1.558234,
      0,
      1.921610,
      0,
      3,
      NULL,
      4.439268,
      4.002831,
      3,
      4,
      3.444267,
      0.839953,
      NULL,
      NULL,
      0,
      0,
      0.131767,
      NULL,
      0,
      1.089578,
      NULL,
      NULL,
      3.307756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.193915,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.671649,
      NULL,
      NULL,
      2.369689,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.417730,
      NULL,
      NULL,
      3.953793,
      2.986508,
      3.285272,
      0,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      17.744223,
      1.383449,
      NULL,
      NULL,
      0.667262,
      NULL,
      NULL,
      NULL,
      0.949335,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.970123,
      NULL,
      NULL,
      NULL,
      2.583830,
      NULL,
      NULL,
      NULL,
      3.539738,
      2,
      NULL,
      NULL,
      3,
      2.763504,
      NULL,
      NULL,
      3.036180,
      2.444281,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.148636,
      0,
      NULL,
      NULL,
      0.742610,
      3.699871,
      NULL,
      NULL,
      0.593182,
      NULL,
      NULL,
      NULL,
      3.007756,
      1,
      NULL,
      NULL,
      1.951536,
      2.905568,
      NULL,
      NULL,
      1.682984,
      1.864416,
      NULL,
      NULL,
      3.916530,
      1,
      NULL,
      NULL,
      1,
      0.379567,
      NULL,
      NULL,
      11.448324,
      4.025404,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      10,
      NULL,
      NULL,
      9.481381,
      4,
      NULL,
      NULL,
      NULL,
      0.900344,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.019838,
      NULL,
      NULL,
      134,
      7.781513,
      0,
      2.818954,
      NULL,
      1.576335,
      NULL,
      0,
      1,
      1.588885,
      0,
      1,
      0,
      NULL,
      1,
      3.360242,
      0.116069,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.621907,
      NULL,
      1,
      NULL,
      3,
      NULL,
      53.236289,
      NULL,
      3.554672,
      27,
      24.293144,
      0.138998,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.078489,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.204571,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.022591,
      NULL,
      1,
      0.691786,
      NULL,
      0.345069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394080,
      1,
      NULL,
      0,
      NULL,
      0.972823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.581402,
      1,
      2.200424,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.350234,
      0.355317,
      2.717928,
      NULL,
      2.714825,
      NULL,
      1.068879,
      NULL,
      NULL,
      NULL,
      1.078301,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.347713,
      NULL,
      254.549023,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      28.286724,
      14,
      NULL,
      NULL,
      3.231707,
      NULL,
      1,
      0,
      1,
      1,
      1.890454,
      0.261531,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0.594136,
      0.433619,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.816070,
      0.734788,
      NULL,
      1.446788,
      1.693988,
      NULL,
      1,
      3.915634,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.245922,
      3.511965,
      NULL,
      NULL,
      3.087972,
      NULL,
      1,
      1.274497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      31,
      52,
      4,
      1,
      5.743831,
      NULL,
      '42023',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


