set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1.721382,
      2.166597,
      2.851412,
      3.985761,
      3,
      0,
      3.593417,
      '032',
      '22220213',
      NULL,
      63.389673,
      NULL,
      1.012865,
      NULL,
      NULL,
      2,
      '3224',
      2.104396,
      1.638007,
      NULL,
      NULL,
      ' 6-16-1994',
      173.515168,
      29.812114,
      NULL,
      2.749530,
      1,
      ' 2-24-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.010525,
      1.512607,
      3,
      0.605875,
      1.229782,
      1,
      0,
      NULL,
      1.934765,
      10.496979,
      4,
      13,
      8.576076,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      3,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      2,
      1,
      6.313298,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.425786,
      NULL,
      NULL,
      0,
      4,
      0.196617,
      NULL,
      0.363580,
      0,
      1,
      0,
      0.896376,
      2,
      3.611767,
      1.598579,
      0,
      NULL,
      0,
      1,
      2.087823,
      3.462304,
      NULL,
      0,
      0,
      NULL,
      4.024189,
      1,
      0,
      0.220686,
      0.309749,
      NULL,
      NULL,
      0.908734,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      0,
      0,
      3,
      2,
      1,
      0,
      2,
      NULL,
      5,
      5,
      1,
      NULL,
      1,
      0,
      4,
      1,
      2,
      5,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      ' 0- 4-2002',
      NULL,
      ' 8- 2-1997',
      630.806183,
      1,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0,
      4,
      4,
      2,
      1.926265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.815739,
      0.869016,
      NULL,
      7,
      1,
      5,
      1.286547,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.375848,
      0.187796,
      1,
      3,
      0,
      0.535441,
      1,
      1.632799,
      NULL,
      2,
      1.786217,
      NULL,
      NULL,
      NULL,
      2,
      1.662199,
      1,
      2,
      1,
      0,
      0,
      1,
      2,
      NULL,
      2,
      NULL,
      1,
      2.879771,
      1.505115,
      2,
      4,
      NULL,
      1,
      1,
      0.019131,
      0.518661,
      NULL,
      0.410110,
      1,
      1,
      0.390242,
      NULL,
      0,
      NULL,
      3,
      1,
      4.762628,
      11.763573,
      NULL,
      2.061286,
      0,
      NULL,
      3,
      0.408949,
      NULL,
      1,
      3,
      0.396546,
      42,
      3,
      NULL,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '40021',
      '20222',
      '',
      1.197792,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.370952,
      7,
      80,
      6.136310,
      2,
      35.313195,
      NULL,
      1.730344,
      5,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.671873,
      0.444239,
      0.802257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.548231,
      NULL,
      1,
      NULL,
      1.601968,
      0.547129,
      1.824384,
      1.046528,
      0.466691,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987043,
      1.173438,
      6.575126,
      NULL,
      3.858072,
      1,
      1.136898,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.747028,
      0.700622,
      NULL,
      1.008259,
      1.177880,
      2.794246,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      2.543561,
      2,
      2,
      3,
      0.251687,
      1,
      3.935907,
      0.857160,
      0.229650,
      3,
      3,
      NULL,
      0.113263,
      0.341011,
      NULL,
      NULL,
      0.757629,
      NULL,
      NULL,
      2.416828,
      NULL,
      1,
      4.576193,
      2,
      0.250279,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1.195608,
      1,
      NULL,
      NULL,
      NULL,
      3.471792,
      1,
      0.802806,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      1.999979,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.731099,
      0.217189,
      NULL,
      NULL,
      1.229191,
      NULL,
      NULL,
      0.675805,
      NULL,
      NULL,
      0.483163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717182,
      NULL,
      NULL,
      NULL,
      1.084700,
      0,
      0.594859,
      NULL,
      NULL,
      5.657515,
      NULL,
      0,
      7,
      NULL,
      2.427638,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.554806,
      0,
      0.001280,
      0,
      3.692310,
      2.246405,
      0,
      9,
      NULL,
      3,
      0,
      1.901042,
      2,
      2.702734,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      1.499883,
      NULL,
      5,
      0.324321,
      1.440544,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      0,
      1.011849,
      0.466015,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.729344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.199271,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.200275,
      1.764348,
      0,
      NULL,
      3,
      1,
      NULL,
      4,
      0.710761,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.904418,
      2,
      NULL,
      NULL,
      1.201276,
      2.834522,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.713142,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.630313,
      1.587102,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.037128,
      NULL,
      NULL,
      NULL,
      0.187976,
      0,
      NULL,
      NULL,
      3,
      1.775887,
      NULL,
      NULL,
      1.618530,
      0,
      NULL,
      NULL,
      3,
      4,
      NULL,
      NULL,
      0.635750,
      2.263344,
      1.372231,
      5,
      4,
      1.641699,
      29.191568,
      32.180290,
      2,
      3,
      3.111319,
      0.482973,
      NULL,
      NULL,
      0,
      9,
      10,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.516207,
      3.704124,
      1.669606,
      0,
      0.853585,
      0,
      1,
      0.849525,
      2,
      0.495415,
      3,
      1,
      3,
      0.892556,
      0,
      1,
      1.413833,
      1.315852,
      1,
      0.100404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.995104,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17.681311,
      NULL,
      0.249310,
      1.053651,
      1,
      2.435958,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.900206,
      NULL,
      1.621601,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.304689,
      NULL,
      0,
      NULL,
      0.484088,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.273947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099809,
      0.545758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.309230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.020478,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2.308923,
      2,
      3.097527,
      3,
      1.397239,
      1,
      1,
      3.838603,
      0.676221,
      2.192306,
      1.586696,
      1,
      1,
      3,
      0,
      0,
      NULL,
      1,
      3.750412,
      2.534751,
      NULL,
      1.463786,
      0,
      NULL,
      1,
      0.934066,
      NULL,
      0,
      1,
      0.272651,
      0,
      0.588279,
      1.681271,
      1,
      NULL,
      0.355562,
      NULL,
      1.636884,
      1.453777,
      1.178343,
      1,
      0.221597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.691178,
      NULL,
      0,
      1,
      1.769696,
      0,
      2,
      5,
      1.734644,
      0.834461,
      3,
      58.878829,
      36,
      2,
      NULL,
      NULL,
      '33224',
      '44020',
      '',
      NULL,
      NULL,
      '',
      '',
      1.595901,
      NULL,
      '',
      '');
commit;
end;
/


