set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.575262,
      2,
      5.189590,
      2.749716,
      NULL,
      3,
      3.813487,
      1.712398,
      '443',
      '31013114',
      11,
      13.695886,
      '1310313',
      0.446458,
      1.934650,
      1,
      1,
      '3021',
      3,
      1,
      NULL,
      NULL,
      ' 4-12-1987',
      92.907785,
      NULL,
      NULL,
      1.896872,
      0.133798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.213073,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      4.169439,
      2,
      6.524334,
      1.548733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.005641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      2,
      5,
      NULL,
      0,
      0,
      9.828035,
      1,
      2,
      2,
      NULL,
      1.194844,
      NULL,
      NULL,
      1.512947,
      NULL,
      NULL,
      2,
      0,
      0.264006,
      0.766783,
      0.729907,
      0.148130,
      NULL,
      2.808713,
      2,
      0,
      NULL,
      0,
      3,
      3,
      0.268215,
      3.192741,
      3.546919,
      3,
      2.385126,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.645531,
      NULL,
      NULL,
      NULL,
      0.286843,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      4,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.309595,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      4,
      1,
      1,
      3,
      NULL,
      1,
      1,
      5,
      NULL,
      NULL,
      5,
      4,
      5,
      4,
      2,
      0,
      NULL,
      1.181455,
      NULL,
      ' 7-12-1983',
      499,
      ' 0- 6-1982',
      606.721907,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445852,
      1.477112,
      1.414597,
      0,
      0.567049,
      1.334336,
      0,
      NULL,
      NULL,
      NULL,
      0.424469,
      NULL,
      1.489440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.534843,
      0,
      NULL,
      NULL,
      1.230761,
      NULL,
      NULL,
      NULL,
      1,
      0.473696,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      3,
      0,
      3,
      2,
      3.126883,
      2.426027,
      1.620498,
      2.976964,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1.576751,
      1,
      NULL,
      NULL,
      1,
      0,
      1.547602,
      2.250288,
      NULL,
      7.926420,
      9,
      6.417792,
      1.697210,
      NULL,
      1.653068,
      NULL,
      0.593760,
      6,
      0.081503,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      '21041',
      NULL,
      1.723155,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.055332,
      20.268722,
      100,
      12,
      2.272510,
      39.263426,
      NULL,
      1.864788,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794568,
      NULL,
      NULL,
      1.010497,
      NULL,
      1.514796,
      0.418033,
      NULL,
      NULL,
      1.271534,
      NULL,
      NULL,
      0,
      2,
      3.239817,
      NULL,
      0.638110,
      1,
      0.900197,
      0.657436,
      0,
      1.540391,
      1,
      NULL,
      0.806063,
      0,
      0.538105,
      2,
      1.707400,
      0.505541,
      10,
      3.461863,
      NULL,
      NULL,
      0.499217,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002589,
      0,
      1,
      3.900620,
      2,
      2,
      3,
      NULL,
      0.404082,
      1.531439,
      NULL,
      1.679555,
      1.887832,
      1.100685,
      0.484208,
      3,
      3,
      2.523738,
      1,
      NULL,
      NULL,
      NULL,
      0.866034,
      1,
      1,
      1,
      0.621690,
      3.357343,
      1.468477,
      NULL,
      NULL,
      1.641960,
      NULL,
      NULL,
      1.568780,
      0,
      0.482807,
      5,
      NULL,
      1.986376,
      0,
      1.237514,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.210252,
      0.877860,
      1,
      NULL,
      0.004678,
      1,
      NULL,
      NULL,
      3.949826,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.361366,
      4,
      1,
      3.807044,
      0,
      0.644380,
      1.062911,
      NULL,
      NULL,
      0,
      1,
      1.476756,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922632,
      NULL,
      NULL,
      0.604495,
      NULL,
      NULL,
      1.758182,
      NULL,
      NULL,
      0.723821,
      NULL,
      NULL,
      0.611752,
      0.820522,
      0,
      0.777276,
      NULL,
      NULL,
      1.511731,
      0,
      NULL,
      0.510437,
      4.736257,
      2.920853,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.152433,
      1.288086,
      NULL,
      1,
      0,
      0.080445,
      NULL,
      3.464789,
      3.535849,
      6,
      3.118816,
      1.788723,
      0.225909,
      3.875167,
      1,
      3,
      1,
      3,
      NULL,
      1,
      1.764261,
      0.147353,
      7.700778,
      4,
      0.865992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.107225,
      1,
      1,
      0,
      0,
      3.082872,
      NULL,
      NULL,
      1.074863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.608897,
      NULL,
      NULL,
      0.926614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2,
      3.973000,
      0,
      3,
      0,
      0.107217,
      NULL,
      3.336529,
      0.946515,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      1.350607,
      NULL,
      NULL,
      NULL,
      1.818400,
      NULL,
      NULL,
      NULL,
      2.370564,
      NULL,
      NULL,
      NULL,
      0.276241,
      NULL,
      NULL,
      NULL,
      2.199759,
      NULL,
      NULL,
      NULL,
      0.699806,
      2,
      NULL,
      NULL,
      3,
      2.764945,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.719827,
      0,
      NULL,
      NULL,
      0.789386,
      0.045450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.546835,
      NULL,
      NULL,
      2.084449,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.536794,
      2.163527,
      7,
      NULL,
      1,
      27.359343,
      NULL,
      NULL,
      3.858198,
      2.186342,
      1,
      NULL,
      NULL,
      1.793645,
      0.798966,
      NULL,
      0.243344,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.434387,
      NULL,
      NULL,
      0.803033,
      1,
      NULL,
      NULL,
      0.748895,
      0,
      NULL,
      NULL,
      2.209354,
      1,
      2,
      0,
      3,
      1,
      3.345327,
      1.194027,
      NULL,
      1.598016,
      0.433109,
      1.492152,
      3.945281,
      NULL,
      1.420273,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.602744,
      NULL,
      NULL,
      3,
      NULL,
      2.726877,
      NULL,
      NULL,
      NULL,
      0.749429,
      NULL,
      0.996635,
      NULL,
      1.766016,
      NULL,
      0.974784,
      NULL,
      0,
      NULL,
      1.889103,
      NULL,
      0.038150,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.373942,
      NULL,
      1.591060,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667848,
      1.992267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.291255,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      5.588302,
      3,
      3.779068,
      NULL,
      2,
      0,
      1.726523,
      1.290071,
      2,
      0,
      2.179354,
      0,
      1.373627,
      2,
      NULL,
      NULL,
      2.715840,
      3.195442,
      NULL,
      1.712899,
      3.309310,
      NULL,
      0.405524,
      NULL,
      0,
      1.379594,
      0.475884,
      1.561642,
      3.203063,
      0.853827,
      0.252371,
      1.310225,
      1.266955,
      0,
      0.566778,
      NULL,
      0,
      1,
      0,
      1.513969,
      0,
      NULL,
      2,
      0,
      0.112366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.280029,
      0,
      1,
      0.702566,
      NULL,
      NULL,
      2,
      5,
      2,
      0.640861,
      3.508986,
      58,
      NULL,
      NULL,
      NULL,
      2.822220,
      '11023',
      '23143',
      '',
      0.336468,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


