set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9024643';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0144010',
      0.943906,
      0,
      3,
      3,
      '2142',
      2,
      1.749136,
      NULL,
      NULL,
      ' 5-15-1974',
      6.181172,
      NULL,
      1,
      1,
      0.278357,
      '10- 9-1980',
      42.032581,
      NULL,
      54.434685,
      183,
      0,
      ' 1-15-1999',
      '10- 5-1975',
      ' 6- 0-1974',
      NULL,
      0.117970,
      NULL,
      0.305623,
      1.811191,
      1.130192,
      3,
      2,
      NULL,
      NULL,
      NULL,
      7.086519,
      5.009069,
      NULL,
      2,
      1,
      1,
      3,
      5,
      NULL,
      0,
      2,
      0,
      0,
      0.622924,
      NULL,
      0.428209,
      1.372531,
      1,
      1,
      1,
      2,
      NULL,
      4,
      1.999452,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.663049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.801874,
      1,
      0,
      1.376582,
      1.710928,
      2.191946,
      0,
      1.726860,
      1,
      1,
      1.377857,
      0,
      1,
      1,
      1,
      1,
      NULL,
      2.532252,
      1.203291,
      NULL,
      NULL,
      1.618049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1.884913,
      NULL,
      1,
      5,
      1,
      NULL,
      1,
      1,
      5,
      0,
      1,
      0,
      1,
      1,
      1,
      2,
      NULL,
      5,
      4,
      4,
      4,
      2,
      0,
      3,
      2,
      2,
      2,
      0,
      3.485581,
      NULL,
      ' 3-19-1984',
      NULL,
      ' 1-26-1978',
      NULL,
      3,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.960792,
      1,
      0,
      0.796965,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.390519,
      0.999241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.883620,
      0.287345,
      1,
      0.426599,
      1.109586,
      1.945808,
      1.128148,
      1,
      NULL,
      2.257824,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.905250,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.107198,
      2.755251,
      0.891703,
      2.394426,
      0,
      NULL,
      3.518164,
      0,
      NULL,
      NULL,
      0,
      1.178762,
      NULL,
      0,
      0.586062,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      7.616961,
      NULL,
      3,
      0,
      NULL,
      0,
      2.789153,
      1,
      NULL,
      2,
      7.792280,
      1,
      0.080493,
      NULL,
      34,
      7,
      72,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      2,
      '21333',
      '',
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      NULL,
      36,
      2,
      3,
      13.872474,
      3.310622,
      11.948717,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.999312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.327397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.182364,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      1.471014,
      0.406194,
      1,
      NULL,
      0,
      0.991126,
      2.201517,
      1,
      1.969573,
      0.260539,
      1.945337,
      1,
      3,
      1.680909,
      0,
      NULL,
      NULL,
      NULL,
      1.412390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606900,
      NULL,
      NULL,
      NULL,
      0.985958,
      NULL,
      NULL,
      2,
      0,
      0.888867,
      2,
      0.815125,
      NULL,
      1,
      NULL,
      NULL,
      0.921734,
      2.850783,
      2.668785,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      1,
      6.879717,
      3.840881,
      5,
      NULL,
      2,
      1.475133,
      NULL,
      NULL,
      NULL,
      0.126599,
      NULL,
      NULL,
      0,
      3,
      2.504746,
      4.172664,
      NULL,
      NULL,
      3,
      1,
      0.185088,
      0.491806,
      3.925268,
      2.961957,
      0,
      0,
      1.939911,
      3.235648,
      6,
      NULL,
      1,
      2,
      1.731851,
      0,
      NULL,
      NULL,
      1,
      1,
      0.837364,
      3,
      NULL,
      3,
      4.999846,
      NULL,
      NULL,
      5,
      NULL,
      2,
      NULL,
      4,
      2,
      1.254275,
      NULL,
      0,
      1,
      1.062243,
      1.597705,
      NULL,
      NULL,
      0.566364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877696,
      NULL,
      NULL,
      1.373273,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.620121,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.285578,
      1,
      0.475369,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.478849,
      NULL,
      NULL,
      NULL,
      0.739602,
      NULL,
      NULL,
      NULL,
      1.362367,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.567685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.067366,
      NULL,
      NULL,
      NULL,
      3.506493,
      NULL,
      NULL,
      NULL,
      1.464396,
      NULL,
      NULL,
      NULL,
      0.957932,
      NULL,
      NULL,
      NULL,
      1.244457,
      NULL,
      NULL,
      NULL,
      0.951564,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.749931,
      NULL,
      0.466498,
      0.175916,
      0,
      1.335119,
      NULL,
      1,
      1.303361,
      0,
      0,
      0,
      1,
      0,
      0.858156,
      0,
      0.456679,
      NULL,
      1,
      1.341563,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      5,
      1,
      3,
      1,
      3,
      NULL,
      NULL,
      1.152331,
      1.107428,
      1.741152,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763479,
      0.332220,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.529299,
      NULL,
      1.371568,
      3.488392,
      NULL,
      1.246342,
      1,
      NULL,
      0,
      1.873391,
      NULL,
      2.406328,
      1,
      NULL,
      0,
      2,
      NULL,
      3.938092,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.898796,
      NULL,
      0.845164,
      NULL,
      2.270522,
      NULL,
      NULL,
      NULL,
      1.615550,
      NULL,
      NULL,
      NULL,
      0.336119,
      NULL,
      NULL,
      NULL,
      1.515632,
      NULL,
      1,
      NULL,
      1,
      NULL,
      19.697826,
      1.119145,
      NULL,
      1.476162,
      NULL,
      0,
      NULL,
      1.187981,
      NULL,
      4,
      0,
      1,
      0,
      NULL,
      2.747395,
      NULL,
      49.970087,
      NULL,
      0.176169,
      NULL,
      '14400',
      NULL,
      '',
      2.841949,
      '43210',
      '',
      '',
      NULL,
      '1023',
      '',
      '');
commit;
end;
/


