set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9035420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4131343',
      NULL,
      0,
      0,
      NULL,
      '4000',
      1.947088,
      0,
      NULL,
      NULL,
      ' 6-29-1992',
      11,
      NULL,
      4,
      NULL,
      1.357195,
      ' 3-23-1992',
      6.474412,
      NULL,
      88,
      100,
      0,
      ' 3- 8-1993',
      '11-20-1977',
      ' 3-19-1983',
      3,
      3.690051,
      3,
      0.562307,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      NULL,
      7,
      1,
      9,
      17.947701,
      4,
      NULL,
      0,
      1,
      4,
      1.478745,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.422104,
      2,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      0,
      4,
      NULL,
      5,
      1,
      0,
      0,
      2,
      1,
      0,
      5,
      NULL,
      4,
      0.079277,
      0,
      0,
      1,
      0,
      1.466879,
      NULL,
      NULL,
      0.239390,
      NULL,
      NULL,
      1,
      1,
      1,
      1.835413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.340228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0.263907,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.811311,
      1,
      NULL,
      NULL,
      5,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5,
      3,
      1,
      0,
      5,
      3,
      1,
      0,
      2,
      NULL,
      1,
      2.461641,
      1.002588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.013355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.892953,
      0.932972,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      3.230165,
      1.956482,
      NULL,
      NULL,
      NULL,
      3,
      5.972271,
      5,
      9,
      1.175301,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.200826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.293480,
      0.675870,
      0.248872,
      1,
      NULL,
      1,
      NULL,
      2,
      44.339563,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490297,
      2,
      1,
      NULL,
      2,
      2,
      3,
      0,
      3,
      0,
      2,
      1,
      0.346232,
      1,
      0.048972,
      1,
      0.097272,
      1.077048,
      1.380480,
      0.319232,
      0,
      NULL,
      0,
      0.494875,
      0,
      0,
      1,
      0,
      NULL,
      6,
      1.175593,
      0,
      6.149640,
      4.777591,
      1,
      6,
      1,
      5.408425,
      0.132975,
      5.348541,
      1.497877,
      3.020553,
      3.875525,
      18,
      3,
      0.586423,
      NULL,
      80,
      71,
      118,
      4,
      NULL,
      5,
      '31204',
      '44234',
      '',
      2.384658,
      '40410',
      '',
      '',
      0.314782,
      '',
      '',
      '',
      NULL,
      32.957608,
      57.357651,
      9,
      0.485307,
      27.284042,
      NULL,
      NULL,
      1,
      1.976863,
      NULL,
      2,
      2,
      1.927545,
      1,
      1.796517,
      NULL,
      0,
      1.778283,
      NULL,
      NULL,
      0.765566,
      NULL,
      NULL,
      1.861452,
      NULL,
      NULL,
      NULL,
      1,
      2.713522,
      2,
      0,
      1.520687,
      0.016540,
      0,
      0.505440,
      1,
      NULL,
      NULL,
      2,
      0.768037,
      1,
      1,
      NULL,
      NULL,
      1,
      1.661415,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.148124,
      2.615122,
      2.911776,
      1.732131,
      NULL,
      0,
      1.704702,
      NULL,
      0,
      1.466718,
      0,
      0,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2.236476,
      NULL,
      2.946615,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      1.492842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621993,
      1.989802,
      1,
      1,
      1.308941,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354142,
      1,
      NULL,
      NULL,
      NULL,
      1.020148,
      1.776027,
      NULL,
      NULL,
      7,
      1,
      NULL,
      3,
      0.372285,
      1,
      1.784753,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.115672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      3.718504,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654245,
      NULL,
      NULL,
      0,
      NULL,
      0.496065,
      NULL,
      0,
      1.603525,
      3,
      3,
      0.080991,
      0.907457,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      1.668080,
      0.314448,
      NULL,
      1.011466,
      2.591413,
      1,
      0,
      NULL,
      1,
      0.527008,
      0.666251,
      0.997791,
      2.216688,
      NULL,
      NULL,
      2.646558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.708088,
      NULL,
      NULL,
      1.969028,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.257603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.918800,
      3,
      NULL,
      0,
      3,
      NULL,
      5,
      NULL,
      1,
      NULL,
      200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.308273,
      NULL,
      0.707153,
      0,
      1.969502,
      NULL,
      NULL,
      NULL,
      0.752797,
      NULL,
      NULL,
      NULL,
      1.331489,
      NULL,
      3.770281,
      0.180136,
      2,
      NULL,
      1.573776,
      NULL,
      NULL,
      NULL,
      1.700406,
      NULL,
      3,
      NULL,
      3.064476,
      NULL,
      2.295209,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.095568,
      1,
      0,
      NULL,
      NULL,
      1.919646,
      2.939893,
      NULL,
      2,
      1,
      0.349863,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      1.395832,
      3.319287,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      1.873701,
      9,
      NULL,
      1.750736,
      0,
      1,
      NULL,
      3,
      1.623320,
      9,
      2,
      3,
      99,
      8,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257945,
      NULL,
      NULL,
      0.679710,
      NULL,
      1.377421,
      NULL,
      11,
      NULL,
      1,
      0.029743,
      1,
      2,
      NULL,
      2,
      NULL,
      0,
      0,
      2,
      0.857966,
      0,
      1,
      0.220898,
      1.891555,
      0.331410,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.122130,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      228,
      NULL,
      NULL,
      NULL,
      15.322043,
      NULL,
      1,
      0.880689,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.426154,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.256471,
      NULL,
      NULL,
      NULL,
      1.809881,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      2.568935,
      2.791278,
      0,
      0.251321,
      3.925874,
      0.714004,
      2.327849,
      0.735375,
      1.945088,
      NULL,
      1,
      0.413687,
      0.342638,
      NULL,
      0,
      0,
      0,
      0.249059,
      0,
      2.103394,
      NULL,
      NULL,
      0.674484,
      1.853144,
      NULL,
      1,
      3,
      1.219508,
      0,
      NULL,
      1.537149,
      NULL,
      0.977150,
      0,
      1,
      1.197218,
      1.538552,
      0,
      NULL,
      NULL,
      NULL,
      3.596924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680711,
      1,
      0,
      0,
      NULL,
      1.394323,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      125.162482,
      5,
      NULL,
      1.647441,
      4.811998,
      '10240',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


