set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '23',
      '30',
      21.647092,
      34.051740,
      '4401400',
      NULL,
      1.780706,
      6,
      0,
      '3133',
      4.164953,
      1,
      NULL,
      NULL,
      NULL,
      35.113151,
      65,
      NULL,
      NULL,
      0.267068,
      ' 7-13-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 8-10-1985',
      ' 5- 8-1983',
      NULL,
      1,
      NULL,
      0.222126,
      NULL,
      1.747936,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      9.607697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      5,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.083542,
      1.660503,
      0.804864,
      2,
      2.110798,
      1,
      3,
      2.392194,
      NULL,
      2,
      1.668814,
      0.741175,
      NULL,
      0.511822,
      0,
      1,
      0,
      0,
      6,
      0,
      1,
      1,
      0.420551,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0.670845,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      5,
      3,
      0,
      2,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0.810891,
      1,
      ' 2-23-1977',
      18.473181,
      ' 8-17-1987',
      1,
      1.966366,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.382743,
      1,
      4,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.566333,
      3.360645,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624965,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.673921,
      0.345955,
      1.861708,
      1.160920,
      7,
      1.638062,
      1.432374,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      3,
      3,
      3,
      1,
      3,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.268327,
      0.487693,
      0.707867,
      0,
      0,
      NULL,
      NULL,
      0.707204,
      NULL,
      0,
      NULL,
      0.447905,
      1.705674,
      1.546546,
      7.205550,
      0.152511,
      3,
      3.043863,
      5.586503,
      1.143241,
      4.961327,
      0,
      5,
      3,
      NULL,
      2,
      27.073248,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      34.377467,
      0,
      1,
      3,
      '42311',
      '13001',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      2.169872,
      26.601322,
      17.573927,
      32,
      NULL,
      NULL,
      0.457202,
      0,
      NULL,
      NULL,
      2.162917,
      1,
      0.134895,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.573865,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634100,
      0.245677,
      1,
      0,
      0.801123,
      3,
      2,
      0.268496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.717773,
      0,
      2.411993,
      NULL,
      3.574506,
      3,
      0,
      0.460403,
      NULL,
      NULL,
      1,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.211283,
      NULL,
      NULL,
      3,
      1.199103,
      3,
      3.295111,
      1.397818,
      0,
      2,
      0.314779,
      NULL,
      1.682793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.470780,
      NULL,
      NULL,
      1,
      4,
      0,
      1.927164,
      NULL,
      NULL,
      NULL,
      0.071328,
      0.269604,
      1.872864,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      1,
      1.440110,
      NULL,
      NULL,
      5.563544,
      5,
      1.872907,
      1,
      NULL,
      NULL,
      0.814124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342375,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.826224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.988791,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.172588,
      1,
      NULL,
      1.355961,
      NULL,
      NULL,
      2,
      1.350340,
      NULL,
      NULL,
      2,
      3.753674,
      2,
      1.018977,
      3,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.947728,
      2.333706,
      2,
      4,
      3.854404,
      NULL,
      1.840073,
      NULL,
      0,
      NULL,
      1,
      0,
      1.023853,
      1.887102,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.495640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.831448,
      NULL,
      2,
      0.976388,
      3,
      NULL,
      5.157030,
      NULL,
      NULL,
      NULL,
      0.340528,
      NULL,
      NULL,
      NULL,
      0.426801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.553484,
      NULL,
      3.857436,
      NULL,
      NULL,
      NULL,
      1.843353,
      NULL,
      0.563388,
      NULL,
      1,
      NULL,
      0.602030,
      NULL,
      1.128533,
      NULL,
      0.698479,
      NULL,
      1.124093,
      NULL,
      0.921175,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.331947,
      NULL,
      2,
      NULL,
      2.320428,
      NULL,
      1,
      NULL,
      0.768299,
      NULL,
      1.985905,
      NULL,
      NULL,
      NULL,
      0.165310,
      NULL,
      3,
      NULL,
      0.655228,
      NULL,
      2.523610,
      NULL,
      NULL,
      NULL,
      1.984639,
      0.708663,
      3.083047,
      6,
      0,
      3,
      1,
      180,
      3.627023,
      2.023981,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      46,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.274328,
      333.946735,
      918.578271,
      NULL,
      1,
      1.979265,
      NULL,
      1.938965,
      1,
      NULL,
      NULL,
      0,
      1.900254,
      1.455182,
      0.598424,
      0,
      1,
      0.708303,
      0.013378,
      0.654895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.265282,
      1,
      1.772512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445539,
      3.330001,
      NULL,
      0,
      NULL,
      0,
      NULL,
      38.194783,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421602,
      NULL,
      2.439112,
      NULL,
      12,
      NULL,
      3.869737,
      NULL,
      1.919747,
      NULL,
      1,
      NULL,
      NULL,
      3.869062,
      6.179672,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      4.439743,
      1,
      0.525354,
      NULL,
      NULL,
      1.949062,
      0,
      0.963279,
      2,
      0,
      NULL,
      0,
      0,
      1,
      1.083405,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0.980044,
      0,
      0.564869,
      1.060154,
      NULL,
      1.964685,
      0,
      0,
      NULL,
      0.825909,
      0.125968,
      0,
      0.866558,
      0.521138,
      NULL,
      0.838985,
      3,
      NULL,
      0.867090,
      NULL,
      1.709667,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0.353584,
      NULL,
      NULL,
      27,
      54.887271,
      0,
      NULL,
      NULL,
      '04030',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.883332,
      NULL,
      NULL,
      '');
commit;
end;
/


